/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.utility;

import com.infinityraider.infinitylib.InfinityMod;
import java.text.MessageFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InfinityLogger {
    private final InfinityMod mod;
    private final Logger logger;

    public InfinityLogger(InfinityMod mod) {
        this.mod = mod;
        this.logger = LogManager.getLogger();
    }

    public void log(Level logLevel, String format, Object ... objects) {
        try {
            this.logger.log(logLevel, "[" + this.mod.getModId() + "]" + MessageFormat.format(format, objects));
        }
        catch (IllegalArgumentException ex) {
            this.logger.log(logLevel, "[" + this.mod.getModId() + "]" + format);
        }
    }

    public void all(String format, Object ... objects) {
        this.log(Level.ALL, format, objects);
    }

    public void debug(String format, Object ... objects) {
        this.log(Level.DEBUG, "[DEBUG]: " + format, objects);
    }

    public void error(String format, Object ... objects) {
        this.log(Level.ERROR, format, objects);
    }

    public void fatal(String format, Object ... objects) {
        this.log(Level.FATAL, format, objects);
    }

    public void info(String format, Object ... objects) {
        this.log(Level.INFO, format, objects);
    }

    public void off(String format, Object ... objects) {
        this.log(Level.OFF, format, objects);
    }

    public void trace(String format, Object ... objects) {
        this.log(Level.TRACE, format, objects);
    }

    public void warn(String format, Object ... objects) {
        this.log(Level.WARN, format, objects);
    }

    public void printStackTrace(Exception e) {
        e.printStackTrace();
    }
}

