/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.dualwield;

import com.infinityraider.infinitylib.modules.dualwield.IDualWieldedWeapon;
import com.infinityraider.infinitylib.modules.dualwield.MessageAttackDualWielded;
import com.infinityraider.infinitylib.modules.dualwield.MessageMouseButtonPressed;
import com.infinityraider.infinitylib.modules.dualwield.ModuleDualWield;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class MouseClickHandler {
    private static final MouseClickHandler INSTANCE = new MouseClickHandler();
    private PlayerController playerController;
    private boolean leftButtonPressed = false;
    private boolean rightButtonPressed = false;
    private static final int LMB = 0;
    private static final int RMB = 1;

    private MouseClickHandler() {
    }

    public static MouseClickHandler getInstance() {
        return INSTANCE;
    }

    @SubscribeEvent
    public void onLeftClick(InputEvent.RawMouseEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184592_cb();
        if (event.getButton() != 0) {
            return;
        }
        boolean bl = this.leftButtonPressed = !this.leftButtonPressed;
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof IDualWieldedWeapon) {
            if (this.leftButtonPressed) {
                boolean shift = Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d();
                boolean ctrl = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
                IDualWieldedWeapon weapon = (IDualWieldedWeapon)stack.func_77973_b();
                this.attackEntity(weapon, player, stack, true, shift, ctrl, Hand.OFF_HAND);
                weapon.onItemUsed(stack, (PlayerEntity)player, shift, ctrl, Hand.OFF_HAND);
                new MessageMouseButtonPressed(true, shift, ctrl).sendToServer();
                Minecraft.func_71410_x().field_71439_g.func_184609_a(Hand.OFF_HAND);
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClick(InputEvent.RawMouseEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184614_ca();
        if (event.getButton() != 1) {
            return;
        }
        boolean bl = this.rightButtonPressed = !this.rightButtonPressed;
        if (stack == null || stack.func_190926_b()) {
            return;
        }
        if (stack.func_77973_b() instanceof IDualWieldedWeapon) {
            if (this.rightButtonPressed) {
                boolean shift = Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_151470_d();
                boolean ctrl = Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d();
                IDualWieldedWeapon weapon = (IDualWieldedWeapon)stack.func_77973_b();
                this.attackEntity(weapon, player, stack, false, shift, ctrl, Hand.MAIN_HAND);
                weapon.onItemUsed(stack, (PlayerEntity)player, shift, ctrl, Hand.MAIN_HAND);
                new MessageMouseButtonPressed(false, shift, ctrl).sendToServer();
                Minecraft.func_71410_x().field_71439_g.func_184609_a(Hand.MAIN_HAND);
            }
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    private void attackEntity(IDualWieldedWeapon weapon, ClientPlayerEntity player, ItemStack stack, boolean left, boolean shift, boolean ctrl, Hand hand) {
        if (Minecraft.func_71410_x().field_71476_x == null) {
            return;
        }
        Entity target = null;
        RayTraceResult mouseOverObj = Minecraft.func_71410_x().field_71476_x;
        if (mouseOverObj instanceof EntityRayTraceResult) {
            target = ((EntityRayTraceResult)mouseOverObj).func_216348_a();
        }
        if (target != null && !weapon.onItemAttack(stack, (PlayerEntity)player, target, shift, ctrl, left ? Hand.OFF_HAND : Hand.MAIN_HAND)) {
            if (this.playerController == null) {
                this.playerController = Minecraft.func_71410_x().field_71442_b;
            }
            if (this.playerController != null) {
                new MessageAttackDualWielded(target, left, shift, ctrl).sendToServer();
                if (this.playerController.func_178889_l() != GameType.SPECTATOR) {
                    ModuleDualWield.getInstance().attackTargetEntityWithCurrentItem((PlayerEntity)player, target, weapon, stack, hand);
                    player.func_184821_cY();
                }
            }
        }
    }
}

