/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.mods.myrtrees.common.blockentity.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.alwa.mods.myrtrees.common.MyrtreesConfig;
import io.alwa.mods.myrtrees.common.blockentity.WoodenBucketBlockEntity;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;

public class WoodenBucketRenderer
extends TileEntityRenderer<WoodenBucketBlockEntity> {
    public static ResourceLocation LATEX_TEXTURE = new ResourceLocation("myrtrees:block/latex");

    public WoodenBucketRenderer(TileEntityRendererDispatcher blockEntityRenderDispatcher) {
        super(blockEntityRenderDispatcher);
    }

    public void render(WoodenBucketBlockEntity bucket, float partialTicks, MatrixStack poseStack, IRenderTypeBuffer multiBufferSource, int i, int j) {
        int amount = bucket.latex;
        if (amount <= 0) {
            return;
        }
        float o0 = 0.25f;
        float o1 = 0.75f;
        float y0 = 0.375f;
        float y11 = 0.675f;
        float fluidLevel = y0 + (y11 - y0) * (float)amount / (float)MyrtreesConfig.BUCKET_CAPACITY;
        IVertexBuilder buffer = multiBufferSource.getBuffer(RenderType.func_228645_f_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(LATEX_TEXTURE);
        float u0 = sprite.func_94209_e();
        float v0 = sprite.func_94206_g();
        float u1 = sprite.func_94212_f();
        float v1 = sprite.func_94210_h();
        float uo = (u1 - u0) / 16.0f;
        float vo = (v1 - v0) / 16.0f;
        int color = -1;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Direction facing = (Direction)bucket.func_195044_w().func_177229_b((Property)HorizontalBlock.field_185512_D);
        o0 = 0.25f;
        o1 = 0.75f;
        float translation = 0.1875f;
        poseStack.func_227860_a_();
        if (facing.func_176740_k() == Direction.Axis.X) {
            poseStack.func_227861_a_(facing.func_176743_c() == Direction.AxisDirection.NEGATIVE ? (double)translation : (double)(-translation), 0.0, 0.0);
        } else {
            poseStack.func_227861_a_(0.0, 0.0, facing.func_176743_c() == Direction.AxisDirection.NEGATIVE ? (double)translation : (double)(-translation));
        }
        Matrix4f m = poseStack.func_227866_c_().func_227870_a_();
        Matrix3f n = poseStack.func_227866_c_().func_227872_b_();
        LevelRenderer renderer = (x, z, u, v) -> buffer.func_227888_a_(m, x, fluidLevel, z).func_225586_a_(r, g, b, a).func_225583_a_(u, v).func_227891_b_(j).func_227886_a_(i).func_227887_a_(n, 0.0f, 1.0f, 0.0f).func_181675_d();
        renderer.vertex(o0, o0, u0 + uo, v0 + vo);
        renderer.vertex(o0, o1, u1 - uo, v0 + vo);
        renderer.vertex(o1, o1, u1 - uo, v1 - vo);
        renderer.vertex(o1, o0, u0 + uo, v1 - vo);
        poseStack.func_227865_b_();
    }

    private static interface LevelRenderer {
        public void vertex(float var1, float var2, float var3, float var4);
    }
}

