/*
 * Decompiled with CFR 0.152.
 */
package io.alwa.mods.myrtrees.common.block;

import io.alwa.mods.myrtrees.common.MyrtreesConfig;
import io.alwa.mods.myrtrees.common.block.FilledRubberwoodLogBlock;
import io.alwa.mods.myrtrees.common.block.RubberwoodLogBlock;
import io.alwa.mods.myrtrees.common.blockentity.WoodenBucketBlockEntity;
import io.alwa.mods.myrtrees.common.item.MyrtreesItems;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class WoodenBucketBlock
extends Block
implements ITileEntityProvider {
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0);

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader blockGetter, BlockPos blockPos, ISelectionContext collisionContext) {
        return SHAPE;
    }

    public WoodenBucketBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196634_T));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        if (context.func_196000_l().func_176740_k().func_200128_b()) {
            return null;
        }
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l());
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    private boolean canAttachTo(IBlockReader blockGetter, BlockPos blockPos, Direction direction) {
        return blockGetter.func_180495_p(blockPos).func_177230_c() instanceof RubberwoodLogBlock || blockGetter.func_180495_p(blockPos).func_177230_c() instanceof FilledRubberwoodLogBlock;
    }

    public BlockState func_196271_a(BlockState blockState, Direction direction, BlockState blockState2, IWorld levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return !this.func_196260_a(blockState, (IWorldReader)levelAccessor, blockPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public boolean func_196260_a(BlockState blockState, IWorldReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.func_177229_b((Property)FACING);
        return this.canAttachTo((IBlockReader)levelReader, blockPos.func_177972_a(direction.func_176734_d()), direction);
    }

    public void func_176208_a(World level, BlockPos blockPos, BlockState blockState, PlayerEntity player) {
        TileEntity blockEntity = level.func_175625_s(blockPos);
        if (blockEntity instanceof WoodenBucketBlockEntity) {
            WoodenBucketBlockEntity bucket = (WoodenBucketBlockEntity)blockEntity;
            if (!level.field_72995_K && player.func_184812_l_()) {
                ItemStack itemStack = new ItemStack((IItemProvider)MyrtreesItems.WOODEN_BUCKET.get());
                if (bucket.latex > 0) {
                    CompoundNBT compoundTag = new CompoundNBT();
                    compoundTag.func_74768_a("latex", bucket.latex);
                    if (!compoundTag.isEmpty()) {
                        itemStack.func_77983_a("BlockEntityTag", (INBT)compoundTag);
                    }
                }
                ItemEntity itemEntity = new ItemEntity(level, (double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5, itemStack);
                itemEntity.func_174869_p();
                level.func_217376_c((Entity)itemEntity);
            }
        }
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader blockGetter) {
        return new WoodenBucketBlockEntity();
    }

    @Deprecated
    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        TileEntity entity = level.func_175625_s(pos);
        if (entity instanceof WoodenBucketBlockEntity) {
            WoodenBucketBlockEntity e = (WoodenBucketBlockEntity)entity;
            if (e.latex >= MyrtreesConfig.LATEX_FOR_ITEM) {
                e.latex -= MyrtreesConfig.LATEX_FOR_ITEM;
                if (!level.func_201670_d()) {
                    WoodenBucketBlock.func_180635_a((World)level, (BlockPos)pos.func_177984_a(), (ItemStack)new ItemStack((IItemProvider)MyrtreesItems.LATEX.get()));
                    e.func_70296_d();
                }
            }
            if (!level.func_201670_d()) {
                player.func_146105_b((ITextComponent)new StringTextComponent(String.format("%,d / %,d", e.latex, MyrtreesConfig.BUCKET_CAPACITY)), true);
            }
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader level, List<ITextComponent> list, ITooltipFlag flag) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            list.add((ITextComponent)new StringTextComponent(String.format("%,d / %,d", stack.func_77978_p().func_74775_l("BlockEntityTag").func_74762_e("latex"), MyrtreesConfig.BUCKET_CAPACITY)).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

