/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config.v2;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.config.v2.ConfigHolder;
import fuzs.puzzleslib.config.v2.annotation.ConfigBuilder;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class AbstractConfig {
    private final String name;
    private final Map<List<String>, String[]> categoryComments = Maps.newHashMap();

    public AbstractConfig(String name) {
        this.name = name;
    }

    public final void setupConfig(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback) {
        AbstractConfig.setupConfig(this, builder, saveCallback);
    }

    protected void addToBuilder(ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback) {
    }

    protected void afterConfigReload() {
    }

    protected final void addComment(String ... comment) {
        this.addComment(Lists.newArrayList(), comment);
    }

    protected final void addComment(List<String> path, String ... comment) {
        this.categoryComments.put(path, comment);
    }

    public static void setupConfig(AbstractConfig config, ForgeConfigSpec.Builder builder, ConfigHolder.ConfigCallback saveCallback) {
        boolean withCategory;
        boolean bl = withCategory = config.name != null && !config.name.isEmpty();
        if (withCategory) {
            String[] comment = config.categoryComments.get(Lists.newArrayList());
            if (comment != null && comment.length != 0) {
                builder.comment(comment);
            }
            builder.push(config.name);
        }
        ConfigBuilder.serialize(builder, saveCallback, (Map<List<String>, String[]>)Maps.newHashMap(config.categoryComments), config);
        config.addToBuilder(builder, saveCallback);
        if (withCategory) {
            builder.pop();
        }
    }
}

