/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.detail.ExternalObjects;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Fluidics;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Overlay;
import wile.engineersdecor.libmc.detail.RfEnergy;

public class EdMilker {
    public static void on_config(int energy_consumption_per_tick, int min_milking_delay_per_cow) {
        MilkerTileEntity.on_config(energy_consumption_per_tick, min_milking_delay_per_cow);
    }

    public static class SingleMoveGoal
    extends MoveToBlockGoal {
        private static final HashMap<Integer, SingleMoveGoal> tracked_entities_ = new HashMap();
        private static final int motion_timeout = 400;
        private boolean aborted_;
        private boolean in_position_;
        private boolean was_aborted_;
        private Vector3d target_pos_;
        private TargetPositionInValidCheck abort_condition_;
        private StrollEvent on_target_position_reached_;
        private StrollEvent on_aborted_;

        private static void log(String s) {
        }

        public SingleMoveGoal(CreatureEntity creature, Vector3d pos, double speed, TargetPositionInValidCheck abort_condition, @Nullable StrollEvent on_position_reached, @Nullable StrollEvent on_aborted) {
            super(creature, speed, 32, 32);
            this.abort_condition_ = abort_condition;
            this.on_target_position_reached_ = on_position_reached;
            this.on_aborted_ = on_aborted;
            this.field_179494_b = new BlockPos(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
            this.field_179493_e = 0;
            this.field_179496_a = 0;
            this.aborted_ = false;
            this.was_aborted_ = false;
            this.target_pos_ = pos;
        }

        public static void startFor(CreatureEntity entity, BlockPos target_pos, int priority, double speed, TargetPositionInValidCheck abort_condition) {
            SingleMoveGoal.startFor(entity, new Vector3d((double)target_pos.func_177958_n(), (double)target_pos.func_177956_o(), (double)target_pos.func_177952_p()), priority, speed, abort_condition, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean startFor(CreatureEntity entity, Vector3d target_pos, int priority, double speed, TargetPositionInValidCheck abort_condition, @Nullable StrollEvent on_position_reached, @Nullable StrollEvent on_aborted) {
            HashMap<Integer, SingleMoveGoal> hashMap = tracked_entities_;
            synchronized (hashMap) {
                SingleMoveGoal goal = tracked_entities_.getOrDefault(entity.func_145782_y(), null);
                if (goal != null) {
                    if (!goal.aborted()) {
                        return false;
                    }
                    entity.field_70714_bg.func_85156_a((Goal)goal);
                }
                SingleMoveGoal.log("::start(" + entity.func_145782_y() + ")");
                goal = new SingleMoveGoal(entity, target_pos, speed, abort_condition, on_position_reached, on_aborted);
                tracked_entities_.put(entity.func_145782_y(), goal);
                entity.field_70714_bg.func_75776_a(priority, (Goal)goal);
                return true;
            }
        }

        public static boolean isActiveFor(CreatureEntity entity) {
            return entity != null && entity.field_70714_bg.func_220888_c().anyMatch(g -> g.func_220772_j() instanceof SingleMoveGoal && !((SingleMoveGoal)g.func_220772_j()).aborted());
        }

        public static void abortFor(CreatureEntity entity) {
            World world;
            SingleMoveGoal.log("::abort(" + entity.func_145782_y() + ")");
            if (entity.func_70089_S()) {
                entity.field_70714_bg.func_220888_c().filter(g -> g.func_220772_j() instanceof SingleMoveGoal).forEach(g -> ((SingleMoveGoal)g.func_220772_j()).abort());
            }
            if ((world = entity.func_130014_f_()) != null) {
                List to_remove = tracked_entities_.keySet().stream().filter(i -> world.func_73045_a(i.intValue()) == null).collect(Collectors.toList());
                Iterator iterator = to_remove.iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    tracked_entities_.remove(id);
                }
            }
        }

        public Vector3d getTargetPosition() {
            return this.target_pos_;
        }

        public CreatureEntity getCreature() {
            return this.field_179495_c;
        }

        public synchronized void abort() {
            this.aborted_ = true;
        }

        public synchronized boolean aborted() {
            return this.aborted_;
        }

        public synchronized void initialize(Vector3d target_pos, double speed, TargetPositionInValidCheck abort_condition, @Nullable StrollEvent on_position_reached, @Nullable StrollEvent on_aborted) {
            this.abort_condition_ = abort_condition;
            this.on_target_position_reached_ = on_position_reached;
            this.on_aborted_ = on_aborted;
            this.field_179494_b = new BlockPos(target_pos.func_82615_a(), target_pos.func_82617_b(), target_pos.func_82616_c());
            this.field_179493_e = 0;
            this.field_179496_a = 0;
            this.aborted_ = false;
            this.was_aborted_ = false;
            this.target_pos_ = new Vector3d(target_pos.func_82615_a(), target_pos.func_82617_b(), target_pos.func_82616_c());
        }

        public void func_75251_c() {
            this.field_179496_a = 0;
            this.field_179493_e = 0;
        }

        public double func_203110_f() {
            return 0.7;
        }

        public boolean func_203108_i() {
            return !this.aborted() && (this.field_179493_e & 7) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean func_75250_a() {
            if (this.aborted_) {
                if (!this.was_aborted_ && this.on_aborted_ != null) {
                    this.on_aborted_.apply(this, (IWorldReader)this.field_179495_c.field_70170_p, this.target_pos_);
                }
                this.was_aborted_ = true;
                return false;
            }
            if (!this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, this.field_179494_b)) {
                SingleMoveGoal singleMoveGoal = this;
                synchronized (singleMoveGoal) {
                    this.aborted_ = true;
                }
                return false;
            }
            if (--this.field_179496_a > 0) {
                return false;
            }
            this.field_179496_a = 10;
            return true;
        }

        public void func_75249_e() {
            this.field_179493_e = 0;
            if (!this.field_179495_c.func_70661_as().func_75492_a(this.target_pos_.func_82615_a(), this.target_pos_.func_82617_b(), this.target_pos_.func_82616_c(), this.field_179492_d)) {
                this.abort();
                SingleMoveGoal.log("startExecuting() -> abort, no path");
            } else {
                SingleMoveGoal.log("startExecuting() -> started");
            }
        }

        public boolean func_75253_b() {
            if (this.aborted()) {
                SingleMoveGoal.log("shouldContinueExecuting() -> already aborted");
                return false;
            }
            if (this.field_179495_c.func_70661_as().func_75500_f()) {
                if (!this.field_179495_c.func_70661_as().func_75484_a(this.field_179495_c.func_70661_as().func_225466_a(this.target_pos_.func_82615_a(), this.target_pos_.func_82617_b(), this.target_pos_.func_82616_c(), 0), this.field_179492_d)) {
                    SingleMoveGoal.log("shouldContinueExecuting() -> abort, no path");
                    this.abort();
                    return false;
                }
                return true;
            }
            if (this.field_179493_e > 400) {
                SingleMoveGoal.log("shouldContinueExecuting() -> abort, timeout");
                this.abort();
                return false;
            }
            if (!this.func_179488_a((IWorldReader)this.field_179495_c.field_70170_p, this.field_179494_b)) {
                SingleMoveGoal.log("shouldContinueExecuting() -> abort, !shouldMoveTo()");
                this.abort();
                return false;
            }
            SingleMoveGoal.log("shouldContinueExecuting() -> yes");
            return true;
        }

        protected boolean func_179488_a(IWorldReader world, BlockPos pos) {
            if (this.abort_condition_.test(this, world, pos)) {
                SingleMoveGoal.log("shouldMoveTo() -> abort_condition");
                return false;
            }
            return true;
        }

        public void func_75246_d() {
            BlockPos testpos = new BlockPos(this.target_pos_.func_82615_a(), this.field_179495_c.func_213303_ch().func_82617_b(), this.target_pos_.func_82616_c());
            if (!testpos.func_218137_a((IPosition)this.field_179495_c.func_213303_ch(), this.func_203110_f())) {
                if (++this.field_179493_e > 400) {
                    SingleMoveGoal.log("tick() -> abort, timeoutCounter");
                    this.abort();
                    return;
                }
                if (this.func_203108_i() && !this.field_179495_c.func_70661_as().func_75492_a(this.target_pos_.func_82615_a(), this.target_pos_.func_82617_b(), this.target_pos_.func_82616_c(), this.field_179492_d)) {
                    SingleMoveGoal.log("tick() -> abort, !tryMoveToXYZ()");
                    this.abort();
                }
            } else {
                SingleMoveGoal.log("tick() -> abort, in position)");
                this.in_position_ = true;
                this.abort();
                if (this.on_target_position_reached_ != null) {
                    this.on_target_position_reached_.apply(this, (IWorldReader)this.field_179495_c.field_70170_p, this.target_pos_);
                }
            }
        }

        @FunctionalInterface
        public static interface StrollEvent {
            public void apply(SingleMoveGoal var1, IWorldReader var2, Vector3d var3);
        }

        @FunctionalInterface
        public static interface TargetPositionInValidCheck {
            public boolean test(SingleMoveGoal var1, IWorldReader var2, BlockPos var3);
        }
    }

    public static class MilkerTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    IFluidTank,
    ICapabilityProvider {
        public static final int BUCKET_SIZE = 1000;
        public static final int TICK_INTERVAL = 80;
        public static final int PROCESSING_TICK_INTERVAL = 20;
        public static final int TANK_CAPACITY = 12000;
        public static final int MAX_MILKING_TANK_LEVEL = 11500;
        public static final int FILLED_INDICATION_THRESHOLD = 1000;
        public static final int MAX_ENERGY_BUFFER = 16000;
        public static final int MAX_ENERGY_TRANSFER = 512;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 0;
        public static final int DEFAULT_MILKING_DELAY_PER_COW = 4000;
        private static final FluidStack NO_MILK_FLUID = new FluidStack((Fluid)Fluids.field_204546_a, 0);
        private static final Direction[] FLUID_TRANSFER_DIRECTRIONS = new Direction[]{Direction.DOWN, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        private static FluidStack milk_fluid_ = NO_MILK_FLUID;
        private static final HashMap<ItemStack, ItemStack> milk_containers_ = new HashMap();
        private static int energy_consumption_ = 0;
        private static long min_milking_delay_per_cow_ticks_ = 4000L;
        private int tick_timer_;
        private UUID tracked_cow_ = null;
        private MilkingState state_ = MilkingState.IDLE;
        private int state_timeout_ = 0;
        private int state_timer_ = 0;
        private BlockPos tracked_cow_original_position_ = null;
        private final RfEnergy.Battery battery_;
        private final LazyOptional<IEnergyStorage> energy_handler_;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(12000, 0, 1000, fs -> this.has_milk_fluid() && fs.isFluidEqual(milk_fluid_));
        private final LazyOptional<IFluidHandler> fluid_handler_ = this.tank_.createFluidHandler();
        private static final HashMap<Integer, Long> tracked_cows_ = new HashMap();

        public static void on_config(int energy_consumption_per_tick, int min_milking_delay_per_cow) {
            Fluid milk;
            energy_consumption_ = MathHelper.func_76125_a((int)energy_consumption_per_tick, (int)0, (int)1024);
            min_milking_delay_per_cow_ticks_ = MathHelper.func_76125_a((int)min_milking_delay_per_cow, (int)1000, (int)24000);
            ResourceLocation milk_rl = ForgeRegistries.FLUIDS.getKeys().stream().filter(rl -> rl.func_110623_a().equals("milk")).findFirst().orElse(null);
            if (milk_rl != null && (milk = (Fluid)ForgeRegistries.FLUIDS.getValue(milk_rl)) != null) {
                milk_fluid_ = new FluidStack(milk, 1000);
            }
            milk_containers_.put(new ItemStack((IItemProvider)Items.field_151133_ar), new ItemStack((IItemProvider)Items.field_151117_aB));
            if (ExternalObjects.BOTTLED_MILK_BOTTLE_DRINKLABLE != null) {
                milk_containers_.put(new ItemStack((IItemProvider)Items.field_151069_bo), new ItemStack((IItemProvider)ExternalObjects.BOTTLED_MILK_BOTTLE_DRINKLABLE));
            }
            ModConfig.log("Config milker: energy consumption:" + energy_consumption_ + "rf/t" + (milk_fluid_ == NO_MILK_FLUID ? "[no milk fluid registered]" : " [milk fluid available]") + (ExternalObjects.BOTTLED_MILK_BOTTLE_DRINKLABLE == null ? "" : " [bottledmilk mod available]"));
        }

        public MilkerTileEntity() {
            this(ModContent.TET_SMALL_MILKING_MACHINE);
        }

        public MilkerTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.battery_ = new RfEnergy.Battery(16000, 512, 0);
            this.energy_handler_ = this.battery_.createEnergyHandler();
            this.reset();
        }

        public void reset() {
            this.tank_.clear();
            this.battery_.clear();
            this.tick_timer_ = 0;
            this.tracked_cow_ = null;
            this.state_ = MilkingState.IDLE;
            this.state_timeout_ = 0;
        }

        public CompoundNBT destroy_getnbt() {
            UUID cowuid = this.tracked_cow_;
            CompoundNBT nbt = new CompoundNBT();
            this.writenbt(nbt, false);
            this.reset();
            if (cowuid == null) {
                return nbt;
            }
            this.field_145850_b.func_175647_a(CowEntity.class, new AxisAlignedBB(this.field_174879_c).func_72314_b(16.0, 16.0, 16.0), e -> e.func_110124_au().equals(cowuid)).forEach(e -> e.func_94061_f(false));
            return nbt;
        }

        public void readnbt(CompoundNBT nbt, boolean update_packet) {
            this.battery_.load(nbt);
            this.tank_.load(nbt);
        }

        protected void writenbt(CompoundNBT nbt, boolean update_packet) {
            this.tank_.save(nbt);
            if (!this.battery_.isEmpty()) {
                this.battery_.save(nbt);
            }
        }

        private IFluidHandler fluid_handler() {
            return (IFluidHandler)this.fluid_handler_.orElse(null);
        }

        private int fluid_level() {
            return this.tank_.getFluidAmount();
        }

        private FluidStack drain(int amount) {
            return this.tank_.drain(amount);
        }

        public void state_message(PlayerEntity player) {
            StringTextComponent rf = energy_consumption_ <= 0 ? new StringTextComponent("") : Auxiliaries.localizable("block.engineersdecor.small_milking_machine.status.rf", this.battery_.getEnergyStored());
            Overlay.show(player, (ITextComponent)Auxiliaries.localizable("block.engineersdecor.small_milking_machine.status", this.tank_.getFluidAmount(), rf));
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt, false);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
        }

        private boolean has_milk_fluid() {
            return !NO_MILK_FLUID.isFluidEqual(milk_fluid_);
        }

        @Nonnull
        public FluidStack getFluid() {
            return this.has_milk_fluid() ? new FluidStack(milk_fluid_, this.fluid_level()) : FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return this.has_milk_fluid() ? this.fluid_level() : 0;
        }

        public int getCapacity() {
            return 12000;
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.has_milk_fluid() && stack.isFluidEqual(milk_fluid_);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return !resource.isFluidEqual(milk_fluid_) ? FluidStack.EMPTY : this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!this.has_milk_fluid() || this.fluid_level() <= 0) {
                return FluidStack.EMPTY;
            }
            return this.tank_.drain(maxDrain, action);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.has_milk_fluid()) {
                return this.fluid_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY && energy_consumption_ > 0) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private void log(String s) {
        }

        private static ItemStack milk_filled_container_item(ItemStack stack) {
            return milk_containers_.entrySet().stream().filter(e -> Inventories.areItemStacksIdentical((ItemStack)e.getKey(), stack)).map(Map.Entry::getValue).findFirst().orElse(ItemStack.field_190927_a);
        }

        private boolean fill_adjacent_inventory_item_containers(Direction block_facing) {
            IItemHandler src = Inventories.itemhandler(this.field_145850_b, this.field_174879_c.func_177972_a(block_facing), block_facing.func_176734_d());
            IItemHandler dst = Inventories.itemhandler(this.field_145850_b, this.field_174879_c.func_177977_b(), Direction.UP);
            if (src == null) {
                src = dst;
            } else if (dst == null) {
                dst = src;
            }
            if (src == null || dst == null) {
                return false;
            }
            boolean dirty = false;
            while (this.tank_.getFluidAmount() >= 1000) {
                boolean inserted = false;
                for (Map.Entry<ItemStack, ItemStack> e : milk_containers_.entrySet()) {
                    if (Inventories.extract(src, e.getKey(), 1, true).func_190926_b() || !Inventories.insert(dst, e.getValue().func_77946_l(), false).func_190926_b()) continue;
                    Inventories.extract(src, e.getKey(), 1, false);
                    this.tank_.drain(1000);
                    inserted = true;
                    dirty = true;
                    break;
                }
                if (inserted) continue;
                break;
            }
            return dirty;
        }

        private boolean fill_adjacent_tank() {
            if (this.fluid_level() <= 0 || !this.has_milk_fluid()) {
                return false;
            }
            FluidStack fs = new FluidStack(milk_fluid_, Math.max(this.fluid_level(), 1000));
            for (Direction dir : Direction.values()) {
                int amount = Fluidics.fill(this.func_145831_w(), this.func_174877_v().func_177972_a(dir), dir.func_176734_d(), fs);
                if (amount <= 0) continue;
                this.tank_.drain(amount);
                return true;
            }
            return false;
        }

        private void release_cow(CowEntity cow) {
            this.log("release cow");
            if (cow != null) {
                cow.func_94061_f(false);
                SingleMoveGoal.abortFor((CreatureEntity)cow);
                tracked_cows_.remove(cow.func_145782_y());
                Iterator iterator = tracked_cows_.keySet().stream().filter(i -> cow.func_130014_f_().func_73045_a(i.intValue()) == null).collect(Collectors.toList()).iterator();
                while (iterator.hasNext()) {
                    int id = (Integer)iterator.next();
                    tracked_cows_.remove(id);
                }
            }
            this.tracked_cow_ = null;
            this.state_ = MilkingState.IDLE;
            this.tick_timer_ = 80;
        }

        private boolean milking_process() {
            long t;
            if (this.tracked_cow_ == null && this.fluid_level() >= 11500) {
                return false;
            }
            Direction facing = ((Direction)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((Property)MilkerBlock.HORIZONTAL_FACING)).func_176734_d();
            Vector3d target_pos = Vector3d.func_237491_b_((Vector3i)this.func_174877_v().func_177972_a(facing)).func_72441_c(0.5, 0.0, 0.5);
            CowEntity cow = null;
            AxisAlignedBB aabb = new AxisAlignedBB(this.field_174879_c.func_177967_a(facing, 3)).func_72314_b(4.0, 2.0, 4.0);
            List cows = this.field_145850_b.func_175647_a(CowEntity.class, aabb, arg_0 -> this.lambda$milking_process$6(t = this.field_145850_b.func_82737_E(), arg_0));
            if (cows.size() == 1) {
                cow = (CowEntity)cows.get(0);
            } else if (cows.size() > 1) {
                cow = (CowEntity)cows.get(this.field_145850_b.field_73012_v.nextInt(cows.size() - 1));
            }
            if (this.state_ != MilkingState.IDLE && (this.state_timeout_ -= 20) <= 0) {
                this.release_cow(cow);
                this.log("Cow motion timeout");
                cow = null;
            }
            if (cow == null || !cow.func_70089_S()) {
                this.release_cow(cow);
                cow = null;
            }
            if (this.tracked_cow_ == null) {
                this.state_ = MilkingState.IDLE;
            }
            if (cow == null) {
                this.log("Init: No cow");
                return false;
            }
            this.tick_timer_ = 20;
            this.state_timer_ -= 20;
            if (this.state_timer_ > 0) {
                return false;
            }
            switch (this.state_) {
                case IDLE: {
                    List blocking_entities = this.field_145850_b.func_217357_a(LivingEntity.class, new AxisAlignedBB(this.field_174879_c.func_177972_a(facing)).func_72314_b(0.5, 0.5, 0.5));
                    if (blocking_entities.size() > 0) {
                        this.tick_timer_ = 80;
                        this.log("Idle: Position blocked");
                        if (blocking_entities.get(0) instanceof CowEntity) {
                            CowEntity blocker = (CowEntity)blocking_entities.get(0);
                            BlockPos p = this.func_174877_v().func_177967_a(facing, 2);
                            this.log("Idle: Shove off");
                            blocker.func_94061_f(false);
                            SingleMoveGoal.startFor((CreatureEntity)blocker, p, 2, 1.0, (goal, world, pos) -> pos.func_177951_i((Vector3i)goal.getCreature().func_233580_cy_()) > 100.0);
                        }
                        return false;
                    }
                    if (cow.func_110167_bD() || cow.func_70631_g_() || cow.func_70880_s() || !cow.func_233570_aj_() || cow.func_184207_aI() || cow.func_70051_ag()) {
                        return false;
                    }
                    tracked_cows_.put(cow.func_145782_y(), cow.func_130014_f_().func_82737_E());
                    this.tracked_cow_ = cow.func_110124_au();
                    this.state_ = MilkingState.PICKED;
                    this.state_timeout_ = 200;
                    this.tracked_cow_original_position_ = cow.func_233580_cy_();
                    this.log("Idle: Picked cow " + this.tracked_cow_);
                    return false;
                }
                case PICKED: {
                    SingleMoveGoal.startFor((CreatureEntity)cow, target_pos, 2, 1.0, (goal, world, pos) -> pos.func_177951_i((Vector3i)goal.getCreature().func_233580_cy_()) > 100.0, (goal, world, pos) -> {
                        this.log("move: position reached");
                        goal.getCreature().func_70012_b(goal.getTargetPosition().func_82615_a(), goal.getTargetPosition().func_82617_b(), goal.getTargetPosition().func_82616_c(), facing.func_185119_l(), 0.0f);
                    }, (goal, world, pos) -> this.log("move: aborted"));
                    this.state_ = MilkingState.COMING;
                    this.state_timeout_ = 400;
                    this.log("Picked: coming to " + target_pos);
                    return false;
                }
                case COMING: {
                    if (target_pos.func_72436_e(cow.func_213303_ch()) <= 1.0) {
                        this.log("Coming: position reached");
                        this.state_ = MilkingState.POSITIONING;
                        this.state_timeout_ = 100;
                    } else if (!SingleMoveGoal.isActiveFor((CreatureEntity)cow)) {
                        this.release_cow(cow);
                        this.log("Coming: aborted");
                    } else {
                        this.state_timeout_ -= 100;
                    }
                    return false;
                }
                case POSITIONING: {
                    this.log("Positioning: start milking");
                    SingleMoveGoal.abortFor((CreatureEntity)cow);
                    cow.func_94061_f(true);
                    cow.func_70012_b(target_pos.func_82615_a(), target_pos.func_82617_b(), target_pos.func_82616_c(), facing.func_185119_l(), 0.0f);
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187564_an, SoundCategory.BLOCKS, 0.5f, 1.0f);
                    this.state_timeout_ = 600;
                    this.state_ = MilkingState.MILKING;
                    this.state_timer_ = 30;
                    return false;
                }
                case MILKING: {
                    this.tank_.fill(milk_fluid_.copy(), IFluidHandler.FluidAction.EXECUTE);
                    this.state_timeout_ = 600;
                    this.state_ = MilkingState.LEAVING;
                    this.state_timer_ = 20;
                    cow.func_94061_f(false);
                    cow.func_70661_as().func_75499_g();
                    this.log("Milking: done, leave");
                    return true;
                }
                case LEAVING: {
                    BlockPos p = this.tracked_cow_original_position_ != null ? this.tracked_cow_original_position_ : this.func_174877_v().func_177967_a(facing, 2).func_177972_a(facing.func_176735_f());
                    SingleMoveGoal.startFor((CreatureEntity)cow, p, 2, 1.0, (goal, world, pos) -> pos.func_177951_i((Vector3i)goal.getCreature().func_233580_cy_()) > 100.0);
                    this.state_timeout_ = 600;
                    this.state_timer_ = 500;
                    this.tick_timer_ = 80;
                    this.state_ = MilkingState.WAITING;
                    tracked_cows_.put(cow.func_145782_y(), cow.func_130014_f_().func_82737_E());
                    this.log("Leaving: process done");
                    return true;
                }
                case WAITING: {
                    this.tick_timer_ = 80;
                    if (this.state_timer_ < 40) {
                        this.tracked_cow_ = null;
                        this.release_cow(null);
                    }
                    this.log("Waiting time elapsed");
                    return true;
                }
            }
            this.release_cow(cow);
            return this.tracked_cow_ != null;
        }

        public void func_73660_a() {
            BlockState new_state;
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 80;
            boolean dirty = false;
            BlockState block_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(block_state.func_177230_c() instanceof MilkerBlock)) {
                return;
            }
            if (!this.field_145850_b.func_175640_z(this.field_174879_c) || this.state_ != MilkingState.IDLE) {
                if (energy_consumption_ > 0 && !this.battery_.draw(energy_consumption_)) {
                    return;
                }
                if (this.milking_process()) {
                    dirty = true;
                }
                if (this.has_milk_fluid() && !this.tank_.isEmpty()) {
                    this.log("Fluid transfer");
                    for (Direction facing : FLUID_TRANSFER_DIRECTRIONS) {
                        FluidStack fs;
                        int nfilled;
                        IFluidHandler fh = (IFluidHandler)FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(facing), (Direction)facing.func_176734_d()).orElse(null);
                        if (fh == null || (nfilled = fh.fill(fs = this.tank_.drain(1000, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.EXECUTE)) <= 0) continue;
                        this.tank_.drain(nfilled, IFluidHandler.FluidAction.EXECUTE);
                        dirty = true;
                        break;
                    }
                }
                if (!dirty && this.fluid_level() > 0) {
                    this.log("Try item transfer");
                    if (this.fill_adjacent_tank() || this.fluid_level() >= 1000 && this.fill_adjacent_inventory_item_containers((Direction)block_state.func_177229_b((Property)MilkerBlock.HORIZONTAL_FACING))) {
                        dirty = true;
                    }
                }
            }
            if (block_state != (new_state = (BlockState)((BlockState)block_state.func_206870_a((Property)MilkerBlock.FILLED, (Comparable)Boolean.valueOf(this.fluid_level() >= 1000))).func_206870_a((Property)MilkerBlock.ACTIVE, (Comparable)Boolean.valueOf(this.state_ == MilkingState.MILKING)))) {
                this.field_145850_b.func_180501_a(this.field_174879_c, new_state, 19);
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        private /* synthetic */ boolean lambda$milking_process$6(long t, CowEntity e) {
            if (e.func_110124_au().equals(this.tracked_cow_)) {
                return true;
            }
            if (this.tracked_cow_ != null || e.func_70631_g_() || e.func_70880_s() || e.func_184207_aI()) {
                return false;
            }
            if (!e.func_70661_as().func_75500_f()) {
                return false;
            }
            return Math.abs(tracked_cows_.getOrDefault(e.func_145782_y(), 0L) - t) >= min_milking_delay_per_cow_ticks_;
        }

        private static enum MilkingState {
            IDLE,
            PICKED,
            COMING,
            POSITIONING,
            MILKING,
            LEAVING,
            WAITING;

        }
    }

    public static class MilkerBlock
    extends DecorBlock.Horizontal
    implements IDecorBlock {
        public static final BooleanProperty FILLED = BooleanProperty.func_177716_a((String)"filled");
        public static final BooleanProperty ACTIVE = BooleanProperty.func_177716_a((String)"active");

        public MilkerBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB[] unrotatedAABBs) {
            super(config, builder, unrotatedAABBs);
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{ACTIVE});
            builder.func_206894_a(new Property[]{FILLED});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)FILLED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ACTIVE, (Comparable)Boolean.valueOf(false));
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState state, World world, BlockPos pos) {
            MilkerTileEntity te = this.getTe(world, pos);
            return te == null ? 0 : MathHelper.func_76125_a((int)(16 * te.fluid_level() / 12000), (int)0, (int)15);
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new MilkerTileEntity();
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
            ItemStack insert_stack;
            ItemStack remainder;
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            MilkerTileEntity te = this.getTe(world, pos);
            if (te == null) {
                return ActionResultType.FAIL;
            }
            ItemStack in_stack = player.func_184586_b(hand);
            ItemStack out_stack = MilkerTileEntity.milk_filled_container_item(in_stack);
            if (in_stack.func_190926_b()) {
                te.state_message(player);
                return ActionResultType.CONSUME;
            }
            if (out_stack.func_190926_b() && te.fluid_handler() != null) {
                return FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)te.fluid_handler()) ? ActionResultType.CONSUME : ActionResultType.FAIL;
            }
            boolean drained = false;
            PlayerMainInvWrapper player_inventory = new PlayerMainInvWrapper(player.field_71071_by);
            if (te.fluid_level() >= 1000 && (remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)player_inventory, (ItemStack)(insert_stack = out_stack.func_77946_l()), (boolean)false)).func_190916_E() < insert_stack.func_190916_E()) {
                te.drain(1000);
                in_stack.func_190918_g(1);
                drained = true;
                if (remainder.func_190916_E() > 0) {
                    ItemEntity ei = new ItemEntity(world, player.func_213303_ch().func_82615_a(), player.func_213303_ch().func_82617_b() + 0.5, player.func_213303_ch().func_82616_c(), remainder);
                    ei.func_174867_a(40);
                    ei.func_213293_j(0.0, 0.0, 0.0);
                    world.func_217376_c((Entity)ei);
                }
            }
            if (drained) {
                world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 0.8f, 1.0f);
            }
            return ActionResultType.CONSUME;
        }

        @Nullable
        private MilkerTileEntity getTe(World world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            return !(te instanceof MilkerTileEntity) ? null : (MilkerTileEntity)te;
        }
    }
}

