/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.FurnaceFuelSlot;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.client.ContainerGui;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.RfEnergy;

public class EdFurnace {
    public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick, String accepted_heaters_csv) {
        FurnaceTileEntity.on_config(speed_percent, fuel_efficiency_percent, boost_energy_per_tick, accepted_heaters_csv);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class FurnaceGui
    extends ContainerGui<FurnaceContainer> {
        protected final PlayerEntity player_;

        public FurnaceGui(FurnaceContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super(container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            this.func_230459_a_(mx, mouseX, mouseY);
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.enableBlend();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_lab_furnace_gui.png"));
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_238474_b_(mx, x0, y0, 0, 0, w, h);
            if (((FurnaceContainer)this.func_212873_a_()).field(4) != 0) {
                int k = this.flame_px(13);
                this.func_238474_b_(mx, x0 + 59, y0 + 36 + 12 - k, 176, 12 - k, 14, k + 1);
            }
            this.func_238474_b_(mx, x0 + 79, y0 + 36, 176, 15, 1 + this.progress_px(17), 15);
            RenderSystem.disableBlend();
        }

        private int progress_px(int pixels) {
            int tc = ((FurnaceContainer)this.func_212873_a_()).field(2);
            int T = ((FurnaceContainer)this.func_212873_a_()).field(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int flame_px(int pixels) {
            int ibt = ((FurnaceContainer)this.func_212873_a_()).field(1);
            return ((FurnaceContainer)this.func_212873_a_()).field(0) * pixels / (ibt > 0 ? ibt : 200);
        }
    }

    public static class FurnaceContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 11;
        protected final PlayerEntity player_;
        protected final IInventory inventory_;
        protected final IWorldPosCallable wpc_;
        private final IIntArray fields_;
        private final IRecipeType<? extends AbstractCookingRecipe> recipe_type_;

        public int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public PlayerEntity player() {
            return this.player_;
        }

        public IInventory inventory() {
            return this.inventory_;
        }

        public World world() {
            return this.player_.field_70170_p;
        }

        public FurnaceContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(11), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(5));
        }

        private FurnaceContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_SMALL_LAB_FURNACE, cid);
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            this.recipe_type_ = FurnaceTileEntity.RECIPE_TYPE;
            this.func_75146_a(new Slot(this.inventory_, 0, 59, 17));
            this.func_75146_a(new BFuelSlot(this.inventory_, 1, 59, 53, this));
            this.func_75146_a(new BSlotResult(this.player_, this.inventory_, 2, 101, 35));
            this.func_75146_a(new BSlotInpFifo(this.inventory_, 3, 34, 17));
            this.func_75146_a(new BSlotInpFifo(this.inventory_, 4, 16, 17));
            this.func_75146_a(new BSlotFuelFifo(this.inventory_, 5, 34, 53));
            this.func_75146_a(new BSlotFuelFifo(this.inventory_, 6, 16, 53));
            this.func_75146_a(new BSlotOutFifo(player_inventory.field_70458_d, this.inventory_, 7, 126, 35));
            this.func_75146_a(new BSlotOutFifo(player_inventory.field_70458_d, this.inventory_, 8, 144, 35));
            this.func_75146_a(new Slot(this.inventory_, 9, 126, 61));
            this.func_75146_a(new Slot(this.inventory_, 10, 144, 61));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 2 || index == 7 || index == 8) {
                if (!this.func_75135_a(slot_stack, 11, 47, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1 || index == 5 || index == 6) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 9 || index == 10) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 11 && index <= 47) {
                if (FurnaceTileEntity.canSmelt(this.world(), slot_stack) ? !this.func_75135_a(slot_stack, 0, 1, false) && !this.func_75135_a(slot_stack, 3, 4, false) && !this.func_75135_a(slot_stack, 4, 5, false) : (FurnaceTileEntity.isFuel(this.player_.field_70170_p, slot_stack) ? !this.func_75135_a(slot_stack, 1, 2, false) && !this.func_75135_a(slot_stack, 5, 6, false) && !this.func_75135_a(slot_stack, 6, 7, false) : (index >= 11 && index < 38 ? !this.func_75135_a(slot_stack, 38, 47, false) : index >= 38 && index < 47 && !this.func_75135_a(slot_stack, 11, 38, false)))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
        }

        public static class BFuelSlot
        extends Slot {
            private final FurnaceContainer container_;

            public BFuelSlot(IInventory inventory, int index, int xpos, int ypos, FurnaceContainer container) {
                super(inventory, index, xpos, ypos);
                this.container_ = container;
            }

            public boolean func_75214_a(ItemStack stack) {
                return BFuelSlot.isBucket(stack) || FurnaceTileEntity.isFuel(this.container_.world(), stack);
            }

            public int func_178170_b(ItemStack stack) {
                return BFuelSlot.isBucket(stack) ? 1 : super.func_178170_b(stack);
            }

            protected static boolean isBucket(ItemStack stack) {
                return stack.func_77973_b() == Items.field_151133_ar;
            }
        }

        public static class BSlotResult
        extends Slot {
            private final IInventory inventory_;
            private final PlayerEntity player_;
            private int removeCount = 0;

            public BSlotResult(PlayerEntity player, IInventory inventory, int index, int xpos, int ypos) {
                super(inventory, index, xpos, ypos);
                this.inventory_ = inventory;
                this.player_ = player;
            }

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public ItemStack func_75209_a(int amount) {
                this.removeCount += this.func_75216_d() ? Math.min(amount, this.func_75211_c().func_190916_E()) : 0;
                return super.func_75209_a(amount);
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                this.func_75208_c(stack);
                super.func_190901_a(thePlayer, stack);
                return stack;
            }

            protected void func_75210_a(ItemStack stack, int amount) {
                this.removeCount += amount;
                this.func_75208_c(stack);
            }

            protected void func_75208_c(ItemStack stack) {
                stack.func_77980_a(this.player_.field_70170_p, this.player_, this.removeCount);
                if (!this.player_.field_70170_p.func_201670_d() && this.inventory_ instanceof Inventories.StorageInventory) {
                    int k;
                    FurnaceTileEntity te = (FurnaceTileEntity)((Inventories.StorageInventory)this.inventory_).getTileEntity();
                    for (int xp = te.consumeSmeltingExperience(stack); xp > 0; xp -= k) {
                        k = ExperienceOrbEntity.func_70527_a((int)xp);
                        this.player_.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.player_.field_70170_p, (double)this.player_.func_233580_cy_().func_177958_n(), (double)this.player_.func_233580_cy_().func_177956_o() + 0.5, (double)this.player_.func_233580_cy_().func_177952_p() + 0.5, k));
                    }
                }
                this.removeCount = 0;
                BasicEventHooks.firePlayerSmeltedEvent((PlayerEntity)this.player_, (ItemStack)stack);
            }
        }

        public static class BSlotOutFifo
        extends BSlotResult {
            public BSlotOutFifo(PlayerEntity player, IInventory inventory, int index, int xpos, int ypos) {
                super(player, inventory, index, xpos, ypos);
            }
        }

        public static class BSlotFuelFifo
        extends Slot {
            public BSlotFuelFifo(IInventory inv, int index, int xpos, int ypos) {
                super(inv, index, xpos, ypos);
            }
        }

        public static class BSlotInpFifo
        extends Slot {
            public BSlotInpFifo(IInventory inv, int index, int xpos, int ypos) {
                super(inv, index, xpos, ypos);
            }
        }
    }

    public static class FurnaceTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    INameable,
    INamedContainerProvider {
        protected static final IRecipeType<FurnaceRecipe> RECIPE_TYPE = IRecipeType.field_222150_b;
        private static final int MAX_BURNTIME = Short.MAX_VALUE;
        private static final int MAX_XP_STORED = 65535;
        private static final int NUM_OF_FIELDS = 5;
        private static final int TICK_INTERVAL = 4;
        private static final int FIFO_INTERVAL = 20;
        private static final int DEFAULT_SMELTING_TIME = 200;
        private static final int DEFAULT_BOOST_ENERGY = 32;
        private static final int NUM_OF_SLOTS = 11;
        private static final int SMELTING_INPUT_SLOT_NO = 0;
        private static final int SMELTING_FUEL_SLOT_NO = 1;
        private static final int SMELTING_OUTPUT_SLOT_NO = 2;
        private static final int FIFO_INPUT_0_SLOT_NO = 3;
        private static final int FIFO_INPUT_1_SLOT_NO = 4;
        private static final int FIFO_FUEL_0_SLOT_NO = 5;
        private static final int FIFO_FUEL_1_SLOT_NO = 6;
        private static final int FIFO_OUTPUT_0_SLOT_NO = 7;
        private static final int FIFO_OUTPUT_1_SLOT_NO = 8;
        private static final int AUX_0_SLOT_NO = 9;
        private static final int AUX_1_SLOT_NO = 10;
        private static double proc_fuel_efficiency_ = 1.0;
        private static double proc_speed_ = 1.2;
        private static int boost_energy_consumption = 128;
        private static final Set<Item> accepted_heaters_ = new HashSet<Item>();
        protected int tick_timer_;
        protected int fifo_timer_;
        protected double proc_time_elapsed_;
        protected int proc_time_needed_;
        protected int burntime_left_;
        protected int field_is_burning_;
        protected float xp_stored_;
        @Nullable
        protected IRecipe<?> current_recipe_ = null;
        private int fuel_burntime_;
        private int field_proc_time_elapsed_;
        private boolean heater_inserted_ = false;
        protected final RfEnergy.Battery battery_;
        protected final Inventories.StorageInventory inventory_;
        protected final LazyOptional<IEnergyStorage> energy_handler_;
        private final LazyOptional<IItemHandler> item_extraction_handler_;
        private final LazyOptional<IItemHandler> item_insertion_handler_;
        private final LazyOptional<IItemHandler> item_fuel_insertion_handler_;
        protected final IIntArray fields = new IntArray(5){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return burntime_left_;
                    }
                    case 1: {
                        return fuel_burntime_;
                    }
                    case 2: {
                        return field_proc_time_elapsed_;
                    }
                    case 3: {
                        return proc_time_needed_;
                    }
                    case 4: {
                        return field_is_burning_;
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        burntime_left_ = value;
                        break;
                    }
                    case 1: {
                        fuel_burntime_ = value;
                        break;
                    }
                    case 2: {
                        field_proc_time_elapsed_ = value;
                        break;
                    }
                    case 3: {
                        proc_time_needed_ = value;
                        break;
                    }
                    case 4: {
                        field_is_burning_ = value;
                    }
                }
            }
        };

        public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick, String accepted_heaters_csv) {
            proc_speed_ = (double)MathHelper.func_76125_a((int)speed_percent, (int)10, (int)500) / 100.0;
            proc_fuel_efficiency_ = (double)MathHelper.func_76125_a((int)fuel_efficiency_percent, (int)10, (int)500) / 100.0;
            boost_energy_consumption = 4 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)4, (int)4096);
            List heater_resource_locations = Arrays.stream(accepted_heaters_csv.toLowerCase().split("[\\s,;]+")).map(s -> s.trim()).collect(Collectors.toList());
            accepted_heaters_.clear();
            for (String rlstr : heater_resource_locations) {
                try {
                    ResourceLocation rl = new ResourceLocation(rlstr);
                    Item heater = (Item)ForgeRegistries.ITEMS.getValue(rl);
                    if (heater == null || heater == Items.field_190931_a) {
                        ModConfig.log("Furnace accepted heater config: Skipped '" + rl + "', item not found/mod not installed.");
                        continue;
                    }
                    accepted_heaters_.add(heater);
                }
                catch (Throwable e) {
                    Auxiliaries.logError("Furnace accepted heater config invalid: '" + rlstr + "', not added.");
                }
            }
            ModConfig.log("Config lab furnace speed:" + proc_speed_ * 100.0 + "%, efficiency:" + proc_fuel_efficiency_ * 100.0 + "%, boost: " + boost_energy_consumption / 4 + "rf/t.");
            ModConfig.log("Config lab furnace accepted heaters: " + accepted_heaters_.stream().map(item -> item.getRegistryName().toString()).collect(Collectors.joining(",")) + ".");
        }

        public FurnaceTileEntity() {
            this(ModContent.TET_SMALL_LAB_FURNACE);
        }

        public FurnaceTileEntity(TileEntityType<?> te_type) {
            this(te_type, 11);
        }

        public FurnaceTileEntity(TileEntityType<?> te_type, int num_slots) {
            super(te_type);
            this.inventory_ = new Inventories.StorageInventory(this, num_slots){

                @Override
                public void func_70299_a(int index, ItemStack stack) {
                    ItemStack slot_stack = (ItemStack)this.stacks_.get(index);
                    boolean already_in_slot = !stack.func_190926_b() && Inventories.areItemStacksIdentical(stack, slot_stack);
                    this.stacks_.set(index, (Object)stack);
                    if (stack.func_190916_E() > this.func_70297_j_()) {
                        stack.func_190920_e(this.func_70297_j_());
                    }
                    if (index == 0 && !already_in_slot) {
                        proc_time_needed_ = this.getSmeltingTimeNeeded(field_145850_b, stack);
                        proc_time_elapsed_ = 0.0;
                        this.func_70296_d();
                    }
                }
            };
            this.inventory_.setValidator((index, stack) -> {
                switch (index) {
                    case 2: 
                    case 7: 
                    case 8: {
                        return false;
                    }
                    case 0: 
                    case 3: 
                    case 4: {
                        return true;
                    }
                    case 9: 
                    case 10: {
                        return true;
                    }
                }
                ItemStack slot_stack = this.inventory_.func_70301_a(6);
                return FurnaceTileEntity.isFuel(this.field_145850_b, stack) || FurnaceFuelSlot.func_178173_c_((ItemStack)stack) && slot_stack.func_77973_b() != Items.field_151133_ar;
            });
            this.item_extraction_handler_ = Inventories.MappedItemHandler.createExtractionHandler((IInventory)this.inventory_, (slot, stack) -> slot != 1 || stack.func_77973_b() == Items.field_151133_ar || !FurnaceTileEntity.isFuel(this.func_145831_w(), stack), Arrays.asList(7, 8, 1));
            this.item_insertion_handler_ = Inventories.MappedItemHandler.createInsertionHandler((IInventory)this.inventory_, 4, 3, 0);
            this.item_fuel_insertion_handler_ = Inventories.MappedItemHandler.createInsertionHandler((IInventory)this.inventory_, 6, 5, 1);
            this.battery_ = new RfEnergy.Battery(boost_energy_consumption * 16, boost_energy_consumption, 0);
            this.energy_handler_ = this.battery_.createEnergyHandler();
        }

        public CompoundNBT reset_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        public void reset() {
            this.inventory_.func_174888_l();
            this.proc_time_elapsed_ = 0.0;
            this.proc_time_needed_ = 0;
            this.burntime_left_ = 0;
            this.fuel_burntime_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.xp_stored_ = 0.0f;
            this.current_recipe_ = null;
        }

        public void readnbt(CompoundNBT nbt) {
            this.burntime_left_ = nbt.func_74762_e("BurnTime");
            this.proc_time_elapsed_ = nbt.func_74762_e("CookTime");
            this.proc_time_needed_ = nbt.func_74762_e("CookTimeTotal");
            this.fuel_burntime_ = nbt.func_74762_e("FuelBurnTime");
            this.xp_stored_ = nbt.func_74760_g("XpStored");
            this.battery_.load(nbt, "Energy");
            this.inventory_.load(nbt);
        }

        protected void writenbt(CompoundNBT nbt) {
            nbt.func_74768_a("BurnTime", MathHelper.func_76125_a((int)this.burntime_left_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTime", MathHelper.func_76125_a((int)((int)this.proc_time_elapsed_), (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTimeTotal", MathHelper.func_76125_a((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("FuelBurnTime", MathHelper.func_76125_a((int)this.fuel_burntime_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74776_a("XpStored", MathHelper.func_76131_a((float)this.xp_stored_, (float)0.0f, (float)65535.0f));
            this.battery_.save(nbt, "Energy");
            this.inventory_.save(nbt);
        }

        public int getComparatorOutput() {
            if (this.inventory_.func_70301_a(5).func_190926_b() && this.inventory_.func_70301_a(6).func_190926_b() && this.inventory_.func_70301_a(1).func_190926_b()) {
                return 0;
            }
            return (this.inventory_.func_70301_a(4).func_190926_b() ? 0 : 5) + (this.inventory_.func_70301_a(3).func_190926_b() ? 0 : 5) + (this.inventory_.func_70301_a(0).func_190926_b() ? 0 : 5);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.item_extraction_handler_.invalidate();
            this.item_insertion_handler_.invalidate();
            this.item_fuel_insertion_handler_.invalidate();
            this.energy_handler_.invalidate();
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Lab furnace");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new FurnaceContainer(id, inventory, this.inventory_, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (facing == Direction.UP) {
                    return this.item_insertion_handler_.cast();
                }
                if (facing == Direction.DOWN) {
                    return this.item_extraction_handler_.cast();
                }
                return this.item_fuel_insertion_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof FurnaceBlock)) {
                return;
            }
            boolean was_burning = this.burning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(7, 8, 1)) {
                    dirty = true;
                }
                if (this.transferItems(2, 7, 1)) {
                    dirty = true;
                }
                if (this.transferItems(5, 1, 1)) {
                    dirty = true;
                }
                if (this.transferItems(6, 5, 1)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 1)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 1)) {
                    dirty = true;
                }
                this.heater_inserted_ = accepted_heaters_.isEmpty() || accepted_heaters_.contains(this.inventory_.func_70301_a(9).func_77973_b()) || accepted_heaters_.contains(this.inventory_.func_70301_a(10).func_77973_b());
            }
            ItemStack fuel = this.inventory_.func_70301_a(1);
            if (this.burning() || !fuel.func_190926_b() && !this.inventory_.func_70301_a(0).func_190926_b()) {
                IRecipe<?> last_recipe = this.currentRecipe();
                this.updateCurrentRecipe();
                if (this.currentRecipe() != last_recipe) {
                    this.proc_time_elapsed_ = 0.0;
                    this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.field_145850_b, this.inventory_.func_70301_a(0));
                }
                if (!this.burning() && this.canSmeltCurrentItem()) {
                    this.burntime_left_ = (int)MathHelper.func_151237_a((double)(proc_fuel_efficiency_ * (double)FurnaceTileEntity.getFuelBurntime(this.field_145850_b, fuel)), (double)0.0, (double)32767.0);
                    this.fuel_burntime_ = (int)MathHelper.func_151237_a((double)((double)this.burntime_left_ / (proc_speed_ > 0.0 ? proc_speed_ : 1.0)), (double)1.0, (double)32767.0);
                    if (this.burning()) {
                        dirty = true;
                        if (!fuel.func_190926_b()) {
                            Item fuel_item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                this.inventory_.func_70299_a(1, fuel_item.getContainerItem(fuel));
                            }
                        }
                    }
                }
                if (this.burning() && this.canSmeltCurrentItem()) {
                    this.proc_time_elapsed_ += 4.0 * proc_speed_;
                    if (this.heater_inserted_ && this.battery_.draw(boost_energy_consumption)) {
                        this.proc_time_elapsed_ += 4.0 * proc_speed_ * 2.0;
                    }
                    if (this.proc_time_elapsed_ >= (double)this.proc_time_needed_) {
                        this.proc_time_elapsed_ = 0.0;
                        this.proc_time_needed_ = this.getSmeltingTimeNeeded(this.field_145850_b, this.inventory_.func_70301_a(0));
                        this.smeltCurrentItem();
                        dirty = true;
                    }
                } else {
                    this.proc_time_elapsed_ = 0.0;
                }
            } else if (!this.burning() && this.proc_time_elapsed_ > 0.0) {
                this.proc_time_elapsed_ = MathHelper.func_151237_a((double)(this.proc_time_elapsed_ - 2.0), (double)0.0, (double)this.proc_time_needed_);
            }
            if (was_burning != this.burning()) {
                dirty = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)FurnaceBlock.LIT, (Comparable)Boolean.valueOf(this.burning())));
            }
            if (dirty) {
                this.func_70296_d();
            }
            this.field_is_burning_ = this.burning() ? 1 : 0;
            this.field_proc_time_elapsed_ = (int)this.proc_time_elapsed_;
        }

        @Nullable
        public static final <T extends AbstractCookingRecipe> T getSmeltingResult(IRecipeType<T> recipe_type, World world, ItemStack stack) {
            if (stack.func_190926_b()) {
                return null;
            }
            Inventory inventory = new Inventory(3);
            inventory.func_70299_a(0, stack);
            return (T)((AbstractCookingRecipe)world.func_199532_z().func_215371_a(recipe_type, (IInventory)inventory, world).orElse(null));
        }

        public boolean burning() {
            return this.burntime_left_ > 0;
        }

        public int getSmeltingTimeNeeded(World world, ItemStack stack) {
            if (stack.func_190926_b()) {
                return 0;
            }
            FurnaceRecipe recipe = FurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, world, stack);
            if (recipe == null) {
                return 0;
            }
            int t = recipe.func_222137_e();
            return t <= 0 ? 200 : t;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = this.inventory_.func_70301_a(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = this.inventory_.func_70301_a(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.inventory_.func_70299_a(index_to, from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.inventory_.func_70299_a(index_from, ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        protected boolean canSmeltCurrentItem() {
            if (this.currentRecipe() == null || this.inventory_.func_70301_a(0).func_190926_b()) {
                return false;
            }
            ItemStack recipe_result_items = this.getSmeltingResult(this.inventory_.func_70301_a(0));
            if (recipe_result_items.func_190926_b()) {
                return false;
            }
            ItemStack result_stack = this.inventory_.func_70301_a(2);
            if (result_stack.func_190926_b()) {
                return true;
            }
            if (!result_stack.func_77969_a(recipe_result_items)) {
                return false;
            }
            if (result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= this.inventory_.func_70297_j_() && result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= result_stack.func_77976_d()) {
                return true;
            }
            return result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= recipe_result_items.func_77976_d();
        }

        protected void smeltCurrentItem() {
            if (!this.canSmeltCurrentItem()) {
                return;
            }
            ItemStack smelting_input_stack = this.inventory_.func_70301_a(0);
            ItemStack recipe_result_items = this.getSmeltingResult(smelting_input_stack);
            ItemStack smelting_output_stack = this.inventory_.func_70301_a(2);
            float xp = this.getCurrentSmeltingXp(smelting_output_stack);
            if (smelting_output_stack.func_190926_b()) {
                this.inventory_.func_70299_a(2, recipe_result_items.func_77946_l());
            } else if (smelting_output_stack.func_77973_b() == recipe_result_items.func_77973_b()) {
                smelting_output_stack.func_190917_f(recipe_result_items.func_190916_E());
            }
            smelting_input_stack.func_190918_g(1);
            this.xp_stored_ += xp;
        }

        public static int getFuelBurntime(World world, ItemStack stack) {
            if (stack.func_190926_b()) {
                return 0;
            }
            int t = ForgeHooks.getBurnTime((ItemStack)stack);
            return Math.max(t, 0);
        }

        public static boolean isFuel(World world, ItemStack stack) {
            return FurnaceTileEntity.getFuelBurntime(world, stack) > 0 || stack.func_77973_b() == Items.field_151129_at;
        }

        public int consumeSmeltingExperience(ItemStack stack) {
            if (this.xp_stored_ < 1.0f) {
                return 0;
            }
            float xp = this.xp_stored_;
            if (xp >= 15.0f) {
                xp /= 2.0f;
            }
            xp = Math.min((float)Math.floor(xp), 150.0f);
            this.xp_stored_ -= xp;
            return (int)xp;
        }

        public ItemStack getSmeltingResult(ItemStack stack) {
            return this.currentRecipe() == null ? ItemStack.field_190927_a : this.currentRecipe().func_77571_b();
        }

        public float getCurrentSmeltingXp(ItemStack stack) {
            float xp = this.currentRecipe() instanceof AbstractCookingRecipe ? ((AbstractCookingRecipe)this.currentRecipe()).func_222138_b() : stack.func_77973_b().getSmeltingExperience(stack);
            return xp <= 0.0f ? 0.7f : xp;
        }

        public static boolean canSmelt(World world, ItemStack stack) {
            return FurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, world, stack) != null;
        }

        @Nullable
        protected IRecipe<?> currentRecipe() {
            return this.current_recipe_;
        }

        protected void updateCurrentRecipe() {
            this.setCurrentRecipe((IRecipe<?>)FurnaceTileEntity.getSmeltingResult(RECIPE_TYPE, this.func_145831_w(), this.inventory_.func_70301_a(0)));
        }

        protected void setCurrentRecipe(IRecipe<?> recipe) {
            this.current_recipe_ = recipe;
        }
    }

    public static class FurnaceBlock
    extends DecorBlock.Horizontal
    implements IDecorBlock {
        public static final BooleanProperty LIT = RedstoneTorchBlock.field_196528_a;

        public FurnaceBlock(long config, AbstractBlock.Properties properties, AxisAlignedBB[] unrotatedAABB) {
            super(config, properties, unrotatedAABB);
            this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }

        @Override
        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{LIT});
        }

        public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)LIT) != false ? super.getLightValue(state, world, pos) : 0;
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof FurnaceTileEntity ? ((FurnaceTileEntity)te).getComparatorOutput() : 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new FurnaceTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
                return;
            }
            CompoundNBT inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
            if (inventory_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FurnaceTileEntity)) {
                return;
            }
            FurnaceTileEntity bte = (FurnaceTileEntity)te;
            bte.readnbt(inventory_nbt);
            bte.func_70296_d();
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(bte.burning())));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof FurnaceTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT inventory_nbt = ((FurnaceTileEntity)te).reset_getnbt();
                if (!inventory_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("inventory", (INBT)inventory_nbt);
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((FurnaceTileEntity)te).inventory_) {
                    stacks.add(stack);
                }
                ((FurnaceTileEntity)te).reset();
            }
            return stacks;
        }

        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.func_201670_d()) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof FurnaceTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            player.func_195066_a(Stats.field_188061_aa);
            return ActionResultType.CONSUME;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
            if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                return;
            }
            double rv = rnd.nextDouble();
            if (rv > 0.5) {
                return;
            }
            double x = 0.5 + (double)pos.func_177958_n();
            double y = 0.5 + (double)pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            double xc = 0.52;
            double xr = rnd.nextDouble() * 0.4 - 0.2;
            double yr = y - 0.3 + rnd.nextDouble() * 0.2;
            if (rv < 0.1) {
                world.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.4f, 0.5f, false);
            }
            switch ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)) {
                case WEST: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case EAST: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                    break;
                }
                case NORTH: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                    break;
                }
                default: {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

