/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.IMessage;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructurizeStylesMessage
implements IMessage {
    private final Map<String, String> md5Map;

    public StructurizeStylesMessage() {
        this.md5Map = Structures.getMD5s();
    }

    public StructurizeStylesMessage(PacketBuffer buf) {
        this.md5Map = new HashMap<String, String>();
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            String filename = buf.func_150789_c(Short.MAX_VALUE);
            String md5 = buf.func_150789_c(Short.MAX_VALUE);
            this.md5Map.put(filename, md5);
        }
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.md5Map.size());
        for (Map.Entry<String, String> entry : this.md5Map.entrySet()) {
            buf.func_180714_a(entry.getKey());
            buf.func_180714_a(entry.getValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Structures.init();
        Structures.setMD5s(this.md5Map);
    }
}

