/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.items;

import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.client.gui.WindowTagTool;
import com.ldtteam.structurize.items.AbstractItemWithPosSelector;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.util.LanguageHandler;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemTagTool
extends AbstractItemWithPosSelector {
    public static final String TAG_ANCHOR_POS = "anchorpostag";
    public static final String TAG_CURRENT_TAG = "currenttag";

    public ItemTagTool(ItemGroup itemGroup) {
        this(new Item.Properties().func_200918_c(0).setNoRepair().func_208103_a(Rarity.UNCOMMON).func_200916_a(itemGroup));
    }

    public ItemTagTool(Item.Properties properties) {
        super(properties);
    }

    @Override
    public AbstractItemWithPosSelector getRegisteredItemInstance() {
        return (AbstractItemWithPosSelector)ModItems.tagTool.get();
    }

    @Override
    public ActionResultType onAirRightClick(BlockPos start, BlockPos end, World worldIn, PlayerEntity playerIn, ItemStack itemStack) {
        if (worldIn.field_72995_K) {
            BlockPos anchorPos = this.getAnchorPos(itemStack);
            if (anchorPos == null) {
                LanguageHandler.sendPlayerMessage(playerIn, "com.ldtteam.structurize.gui.tagtool.noanchor", new Object[0]);
                return ActionResultType.FAIL;
            }
            WindowTagTool window = new WindowTagTool(this.getCurrentTag(itemStack), anchorPos, worldIn, itemStack);
            window.open();
        }
        return ActionResultType.SUCCESS;
    }

    private BlockPos getAnchorPos(ItemStack stack) {
        CompoundNBT itemCompound = stack.func_196082_o();
        if (itemCompound.func_74764_b(TAG_ANCHOR_POS)) {
            return BlockPosUtil.readFromNBT(itemCompound, TAG_ANCHOR_POS);
        }
        return null;
    }

    private String getCurrentTag(ItemStack stack) {
        if (stack.func_196082_o().func_74764_b(TAG_CURRENT_TAG)) {
            return stack.func_196082_o().func_74779_i(TAG_CURRENT_TAG);
        }
        return "";
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return new ActionResult(this.onAirRightClick(null, null, worldIn, playerIn, playerIn.func_184586_b(handIn)), (Object)playerIn.func_184586_b(handIn));
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195999_j() == null) {
            return ActionResultType.SUCCESS;
        }
        if (context.func_195999_j().func_225608_bj_()) {
            TileEntity te = context.func_195991_k().func_175625_s(context.func_195995_a());
            if (te instanceof IBlueprintDataProvider) {
                BlockPosUtil.writeToNBT(context.func_195996_i().func_196082_o(), TAG_ANCHOR_POS, context.func_195995_a());
                if (context.func_195991_k().func_201670_d()) {
                    LanguageHandler.sendPlayerMessage(context.func_195999_j(), "com.ldtteam.structurize.gui.tagtool.anchorsaved", new Object[0]);
                }
                return ActionResultType.SUCCESS;
            }
            if (context.func_195991_k().func_201670_d()) {
                LanguageHandler.sendPlayerMessage(context.func_195999_j(), "com.ldtteam.structurize.gui.tagtool.anchor.notvalid", new Object[0]);
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() != ModItems.tagTool.get() || player == null || worldIn == null) {
            return false;
        }
        BlockPos anchorPos = this.getAnchorPos(stack);
        String currentTag = this.getCurrentTag(stack);
        if (anchorPos == null) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.noanchor", new Object[0]);
            return false;
        }
        if (currentTag.isEmpty()) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.notag", new Object[0]);
            return false;
        }
        BlockPos relativePos = pos.func_177973_b((Vector3i)anchorPos);
        TileEntity te = worldIn.func_175625_s(anchorPos);
        if (!(te instanceof IBlueprintDataProvider)) {
            LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.anchor.notvalid", new Object[0]);
            stack.func_196082_o().func_82580_o(TAG_ANCHOR_POS);
            return false;
        }
        Map<BlockPos, List<String>> tagPosMap = ((IBlueprintDataProvider)te).getPositionedTags();
        if (!tagPosMap.containsKey(relativePos) || !tagPosMap.get(relativePos).contains(currentTag)) {
            ((IBlueprintDataProvider)te).addTag(relativePos, currentTag);
            if (worldIn.func_201670_d()) {
                LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.addtag", currentTag, new TranslationTextComponent(worldIn.func_180495_p(pos).func_177230_c().func_149739_a()));
            }
        } else {
            ((IBlueprintDataProvider)te).removeTag(relativePos, currentTag);
            if (worldIn.func_201670_d()) {
                LanguageHandler.sendPlayerMessage(player, "com.ldtteam.structurize.gui.tagtool.removed", currentTag, new TranslationTextComponent(worldIn.func_180495_p(pos).func_177230_c().func_149739_a()));
            }
        }
        return false;
    }
}

