/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.Log;
import com.ldtteam.structurize.util.LanguageHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.jetbrains.annotations.NotNull;

public final class Parsers {
    public static final Pattern PERCENTAGE_PATTERN = Pattern.compile("([-+]?\\d+)(%|px)?", 2);
    public static final Pattern RGBA_PATTERN = Pattern.compile("rgba?\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*(?:,\\s*([01]\\.\\d+)\\s*)?\\)", 2);
    public static final Pattern HEXADECIMAL_PATTERN = Pattern.compile("#([0-9A-F]{6,8})", 2);
    public static Function<String, Boolean> BOOLEAN = v -> v == null || !v.isEmpty() && !v.equals("disabled") && Boolean.parseBoolean(v);
    public static Function<String, Integer> INT = Integer::parseInt;
    public static Function<String, Float> FLOAT = Float::parseFloat;
    public static Function<String, Double> DOUBLE = Double::parseDouble;
    public static Function<String, ResourceLocation> RESOURCE = ResourceLocation::new;
    private static Function<String, String> RAW_TEXT = v -> {
        String result = v == null ? "" : v;
        Matcher m = Pattern.compile("\\$[({](\\S+)[})]").matcher(result);
        while (m.find()) {
            String translated = LanguageHandler.translateKey(m.group(1));
            if (translated.equals(m.group(1))) {
                translated = "MISSING: " + m.group(1);
            }
            result = result.replace(m.group(0), translated);
        }
        return result;
    };
    @NotNull
    public static Function<String, IFormattableTextComponent> TEXT = v -> {
        String result = RAW_TEXT.apply((String)v);
        return result == null ? null : new StringTextComponent(result);
    };
    public static Function<String, List<IFormattableTextComponent>> MULTILINE = v -> Arrays.stream(RAW_TEXT.apply((String)v).split("(\\\\n|\\n)")).map(StringTextComponent::new).collect(Collectors.toList());
    public static Function<String, Integer> COLOR = v -> {
        Matcher m = HEXADECIMAL_PATTERN.matcher((CharSequence)v);
        if (m.find()) {
            return Integer.parseInt(m.group(), 16);
        }
        m = RGBA_PATTERN.matcher((CharSequence)v);
        if (m.find()) {
            return Color.rgbaToInt(m);
        }
        try {
            return Integer.parseUnsignedInt(v);
        }
        catch (NumberFormatException ex) {
            return Color.getByName(v);
        }
    };

    private Parsers() {
    }

    public static Function<String, Integer> SCALED(int total) {
        return v -> {
            try {
                Matcher m = PERCENTAGE_PATTERN.matcher((CharSequence)v);
                if (!m.find()) {
                    return null;
                }
                int value = Integer.parseInt(m.group(1));
                return m.group(2) != null && m.group(2).equals("%") ? total * MathHelper.func_76125_a((int)value, (int)0, (int)100) / 100 : value;
            }
            catch (IllegalStateException | IndexOutOfBoundsException | NumberFormatException ex) {
                Log.getLogger().warn((Object)ex);
                return null;
            }
        };
    }

    public static Function<String, List<Integer>> SCALED(int ... totals) {
        return v -> {
            ArrayList<Integer> results = new ArrayList<Integer>(totals.length);
            if (v == null) {
                return null;
            }
            String[] values = v.split("\\s*[,\\s]\\s*");
            for (int i = 0; i < totals.length; ++i) {
                int index = values.length > i ? i : Math.min(i % 2, values.length - 1);
                results.add(Parsers.SCALED(totals[i]).apply(values[index]));
            }
            return results;
        };
    }

    public static <T extends Enum<T>> Function<String, T> ENUM(Class<T> clazz) {
        return v -> {
            try {
                return Enum.valueOf(clazz, v);
            }
            catch (IllegalArgumentException | NullPointerException e) {
                Log.getLogger().warn("Attempt to access non-existent enumeration '" + v + "'.");
                return null;
            }
        };
    }

    public static <T> Function<String, List<T>> shorthand(Function<String, T> parser, int parts) {
        return v -> {
            ArrayList<Object> results = new ArrayList<Object>(parts);
            if (v == null) {
                return null;
            }
            for (String segment : v.split("\\s*[,\\s]\\s*")) {
                results.add(parser.apply(segment));
            }
            while (results.size() < parts) {
                results.add(results.get(Math.max(0, results.size() - 2)));
            }
            return results;
        };
    }
}

