/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.items.wand.ItemWand;

public class PacketWandOption {
    public final String key;
    public final String value;
    public final boolean notify;

    public PacketWandOption(IOption<?> option, boolean notify) {
        this(option.getKey(), option.getValueString(), notify);
    }

    private PacketWandOption(String key, String value, boolean notify) {
        this.key = key;
        this.value = value;
        this.notify = notify;
    }

    public static void encode(PacketWandOption msg, PacketBuffer buffer) {
        buffer.func_180714_a(msg.key);
        buffer.func_180714_a(msg.value);
        buffer.writeBoolean(msg.notify);
    }

    public static PacketWandOption decode(PacketBuffer buffer) {
        return new PacketWandOption(buffer.func_150789_c(100), buffer.func_150789_c(100), buffer.readBoolean());
    }

    public static class Handler {
        public static void handle(PacketWandOption msg, Supplier<NetworkEvent.Context> ctx) {
            if (!ctx.get().getDirection().getReceptionSide().isServer()) {
                return;
            }
            ServerPlayerEntity player = ctx.get().getSender();
            if (player == null) {
                return;
            }
            ItemStack wand = WandUtil.holdingWand((PlayerEntity)player);
            if (wand == null) {
                return;
            }
            WandOptions options = new WandOptions(wand);
            IOption<?> option = options.get(msg.key);
            if (option == null) {
                return;
            }
            option.setValueString(msg.value);
            if (msg.notify) {
                ItemWand.optionMessage((PlayerEntity)player, option);
            }
            player.field_71071_by.func_70296_d();
        }
    }
}

