/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.rod;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractGlassBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.PaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.item.IManaProficiencyArmor;
import vazkii.botania.api.item.IWireframeCoordinateListProvider;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.block.BlockPlatform;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.item.ItemTemperanceStone;

public class ItemExchangeRod
extends Item
implements IManaUsingItem,
IWireframeCoordinateListProvider {
    private static final int RANGE = 3;
    private static final int COST = 40;
    private static final String TAG_REPLACEMENT_BLOCK = "blockName";
    private static final String TAG_REPLACEMENT_ITEM = "placedItem";
    private static final String TAG_TARGET_BLOCK_NAME = "targetBlock";
    private static final String TAG_SWAPPING = "swapping";
    private static final String TAG_SELECT_X = "selectX";
    private static final String TAG_SELECT_Y = "selectY";
    private static final String TAG_SELECT_Z = "selectZ";
    private static final String TAG_EXTRA_RANGE = "extraRange";
    private static final String TAG_SWAP_HIT_VEC = "swapHitVec";
    private static final String TAG_SWAP_DIRECTION = "swapDirection";
    private static final String TAG_SWAP_CLICKED_AXIS = "swapClickAxis";
    private static final String TAG_TEMPERANCE_STONE = "temperanceStone";

    public ItemExchangeRod(Item.Properties props) {
        super(props);
        MinecraftForge.EVENT_BUS.addListener(this::onLeftClick);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        Item replacement;
        List<BlockPos> swap;
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        BlockState wstate = world.func_180495_p(pos);
        Block block = wstate.func_177230_c();
        if (player != null && player.func_225608_bj_()) {
            TileEntity tile = world.func_175625_s(pos);
            if (tile == null && block.func_199767_j() != Items.field_190931_a && BlockPlatform.isValidBlock(wstate, world, pos) && (wstate.func_200132_m() || block instanceof AbstractGlassBlock || block instanceof PaneBlock) && block.func_199767_j() instanceof BlockItem) {
                this.setItemToPlace(stack, block.func_199767_j());
                this.setSwapTemplateDirection(stack, ctx.func_196000_l());
                this.setHitPos(stack, ctx.func_221532_j());
                this.displayRemainderCounter(player, stack);
                return ActionResultType.SUCCESS;
            }
        } else if (this.canExchange(stack) && !ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false) && (swap = this.getTargetPositions(world, stack, replacement = this.getItemToPlace(stack), pos, block, ctx.func_196000_l())).size() > 0) {
            ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, true);
            ItemNBTHelper.setInt(stack, TAG_SELECT_X, pos.func_177958_n());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Y, pos.func_177956_o());
            ItemNBTHelper.setInt(stack, TAG_SELECT_Z, pos.func_177952_p());
            this.setSwapClickDirection(stack, ctx.func_196000_l());
            this.setTarget(stack, block);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    private void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        int cost;
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() == this && this.canExchange(stack) && ManaItemHandler.instance().requestManaExactForTool(stack, event.getPlayer(), 40, false) && (cost = this.exchange(event.getWorld(), event.getPlayer(), event.getPos(), stack, this.getItemToPlace(stack))) > 0) {
            ManaItemHandler.instance().requestManaForTool(stack, event.getPlayer(), cost, true);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean equipped) {
        boolean temperanceActive;
        int extraRangeNew;
        if (!this.canExchange(stack) || !(entity instanceof PlayerEntity)) {
            return;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(TAG_REPLACEMENT_BLOCK, 10)) {
            BlockState state = NBTUtil.func_190008_d((CompoundNBT)stack.func_179543_a(TAG_REPLACEMENT_BLOCK));
            this.setItemToPlace(stack, state.func_177230_c().func_199767_j());
            stack.func_196083_e(TAG_REPLACEMENT_BLOCK);
        }
        PlayerEntity player = (PlayerEntity)entity;
        int extraRange = ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1);
        int n = extraRangeNew = IManaProficiencyArmor.hasProficiency(player, stack) ? 3 : 1;
        if (extraRange != extraRangeNew) {
            ItemNBTHelper.setInt(stack, TAG_EXTRA_RANGE, extraRangeNew);
        }
        if ((temperanceActive = ItemTemperanceStone.hasTemperanceActive(player)) != stack.func_196082_o().func_74767_n(TAG_TEMPERANCE_STONE)) {
            stack.func_196082_o().func_74757_a(TAG_TEMPERANCE_STONE, temperanceActive);
        }
        Item replacement = this.getItemToPlace(stack);
        if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
            Block target;
            int z;
            int y;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, 40, false)) {
                ItemExchangeRod.endSwapping(stack);
                return;
            }
            int x = ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0);
            List<BlockPos> swap = this.getTargetPositions(world, stack, replacement, new BlockPos(x, y = ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), z = ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0)), target = ItemExchangeRod.getTargetState(stack), this.getSwapClickDirection(stack));
            if (swap.size() == 0) {
                ItemExchangeRod.endSwapping(stack);
                return;
            }
            BlockPos coords = swap.get(world.field_73012_v.nextInt(swap.size()));
            int exchange = this.exchange(world, player, coords, stack, replacement);
            if (exchange > 0) {
                ManaItemHandler.instance().requestManaForTool(stack, player, exchange, true);
            } else {
                ItemExchangeRod.endSwapping(stack);
            }
        }
    }

    public List<BlockPos> getTargetPositions(World world, ItemStack stack, Item toPlace, BlockPos pos, Block toReplace, Direction clickedSide) {
        ArrayList<BlockPos> coordsList = new ArrayList<BlockPos>();
        Direction.Axis axis = clickedSide.func_176740_k();
        int xRange = this.getRange(stack, axis, Direction.Axis.X);
        int yRange = this.getRange(stack, axis, Direction.Axis.Y);
        int zRange = this.getRange(stack, axis, Direction.Axis.Z);
        for (int offsetX = -xRange; offsetX <= xRange; ++offsetX) {
            for (int offsetY = -yRange; offsetY <= yRange; ++offsetY) {
                block2: for (int offsetZ = -zRange; offsetZ <= zRange; ++offsetZ) {
                    BlockPos pos_ = pos.func_177982_a(offsetX, offsetY, offsetZ);
                    BlockState currentState = world.func_180495_p(pos_);
                    if (currentState.func_177230_c() != toReplace || currentState.func_177230_c().func_199767_j() == toPlace) continue;
                    for (Direction dir : Direction.values()) {
                        BlockPos adjPos = pos_.func_177972_a(dir);
                        BlockState adjState = world.func_180495_p(adjPos);
                        if (Block.func_208061_a((VoxelShape)adjState.func_196951_e((IBlockReader)world, pos), (Direction)dir.func_176734_d())) continue;
                        coordsList.add(pos_);
                        continue block2;
                    }
                }
            }
        }
        return coordsList;
    }

    public int exchange(World world, PlayerEntity player, BlockPos pos, ItemStack rod, Item replacement) {
        BlockState stateAt;
        Block blockAt;
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            return 0;
        }
        ItemStack placeStack = ItemExchangeRod.removeFromInventory(player, rod, replacement, false);
        if (!placeStack.func_190926_b() && !(blockAt = (stateAt = world.func_180495_p(pos)).func_177230_c()).isAir(world.func_180495_p(pos), (IBlockReader)world, pos) && stateAt.func_185903_a(player, (IBlockReader)world, pos) > 0.0f && stateAt.func_177230_c().func_199767_j() != replacement) {
            float hardness = stateAt.func_185887_b((IBlockReader)world, pos);
            if (!world.field_72995_K) {
                world.func_175655_b(pos, !player.field_71075_bZ.field_75098_d);
                BlockRayTraceResult hit = new BlockRayTraceResult(this.getHitPos(rod, pos), this.getSwapTemplateDirection(rod), pos, false);
                ActionResultType result = PlayerHelper.substituteUse(new ItemUseContext(player, Hand.MAIN_HAND, hit), placeStack);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (result.func_226246_a_()) {
                        ItemExchangeRod.removeFromInventory(player, rod, replacement, true);
                        this.displayRemainderCounter(player, rod);
                    } else {
                        ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197594_E, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 2, 0.1, 0.1, 0.1, 0.0);
                    }
                }
            }
            return hardness <= 10.0f ? 40 : (int)(20.0 + (double)(3.0f * hardness));
        }
        return 0;
    }

    public boolean canExchange(ItemStack stack) {
        return this.getItemToPlace(stack) != Items.field_190931_a;
    }

    public static ItemStack removeFromInventory(PlayerEntity player, IInventory inv, ItemStack tool, Item requested, boolean doit) {
        ArrayList<ItemStack> providers = new ArrayList<ItemStack>();
        for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b()) continue;
            Item item = invStack.func_77973_b();
            if (item == requested) {
                ItemStack ret;
                if (doit) {
                    ret = inv.func_70298_a(i, 1);
                } else {
                    ret = invStack.func_77946_l();
                    ret.func_190920_e(1);
                }
                return ret;
            }
            if (!(item instanceof IBlockProvider)) continue;
            providers.add(invStack);
        }
        if (requested instanceof BlockItem) {
            Block block = ((BlockItem)requested).func_179223_d();
            for (ItemStack provStack : providers) {
                IBlockProvider prov = (IBlockProvider)provStack.func_77973_b();
                if (!prov.provideBlock(player, tool, provStack, block, doit)) continue;
                return new ItemStack((IItemProvider)requested);
            }
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack removeFromInventory(PlayerEntity player, ItemStack tool, Item item, boolean doit) {
        if (player.field_71075_bZ.field_75098_d) {
            return new ItemStack((IItemProvider)item);
        }
        ItemStack outStack = ItemExchangeRod.removeFromInventory(player, BotaniaAPI.instance().getAccessoriesInventory(player), tool, item, doit);
        if (outStack.func_190926_b()) {
            outStack = ItemExchangeRod.removeFromInventory(player, (IInventory)player.field_71071_by, tool, item, doit);
        }
        return outStack;
    }

    public static int getInventoryItemCount(PlayerEntity player, ItemStack stack, Item item) {
        if (player.field_71075_bZ.field_75098_d) {
            return -1;
        }
        int baubleCount = ItemExchangeRod.getInventoryItemCount(player, BotaniaAPI.instance().getAccessoriesInventory(player), stack, item);
        if (baubleCount == -1) {
            return -1;
        }
        int count = ItemExchangeRod.getInventoryItemCount(player, (IInventory)player.field_71071_by, stack, item);
        if (count == -1) {
            return -1;
        }
        return count + baubleCount;
    }

    public static int getInventoryItemCount(PlayerEntity player, IInventory inv, ItemStack stack, Item requested) {
        if (player.field_71075_bZ.field_75098_d) {
            return -1;
        }
        int count = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack invStack = inv.func_70301_a(i);
            if (invStack.func_190926_b()) continue;
            Item item = invStack.func_77973_b();
            if (item == requested.func_199767_j()) {
                count += invStack.func_190916_E();
            }
            if (!(item instanceof IBlockProvider) || !(requested instanceof BlockItem)) continue;
            IBlockProvider prov = (IBlockProvider)item;
            int provCount = prov.getBlockCount(player, stack, invStack, ((BlockItem)requested).func_179223_d());
            if (provCount == -1) {
                return -1;
            }
            count += provCount;
        }
        return count;
    }

    public void displayRemainderCounter(PlayerEntity player, ItemStack stack) {
        if (!player.field_70170_p.field_72995_K) {
            Item item = this.getItemToPlace(stack);
            int count = ItemExchangeRod.getInventoryItemCount(player, stack, item);
            ItemsRemainingRenderHandler.send(player, new ItemStack((IItemProvider)item), count);
        }
    }

    @Override
    public boolean usesMana(ItemStack stack) {
        return true;
    }

    private void setItemToPlace(ItemStack stack, Item item) {
        ItemNBTHelper.setString(stack, TAG_REPLACEMENT_ITEM, Registry.field_212630_s.func_177774_c((Object)item).toString());
    }

    private Item getItemToPlace(ItemStack stack) {
        return (Item)Registry.field_212630_s.func_82594_a(new ResourceLocation(ItemNBTHelper.getString(stack, TAG_REPLACEMENT_ITEM, "air")));
    }

    private void setHitPos(ItemStack stack, Vector3d vec) {
        ListNBT list = new ListNBT();
        list.add((Object)DoubleNBT.func_229684_a_((double)MathHelper.func_181162_h((double)vec.func_82615_a())));
        list.add((Object)DoubleNBT.func_229684_a_((double)MathHelper.func_181162_h((double)vec.func_82617_b())));
        list.add((Object)DoubleNBT.func_229684_a_((double)MathHelper.func_181162_h((double)vec.func_82616_c())));
        stack.func_196082_o().func_218657_a(TAG_SWAP_HIT_VEC, (INBT)list);
    }

    private Vector3d getHitPos(ItemStack stack, BlockPos pos) {
        ListNBT list = stack.func_196082_o().func_150295_c(TAG_SWAP_HIT_VEC, 6);
        return new Vector3d((double)pos.func_177958_n() + list.func_150309_d(0), (double)pos.func_177956_o() + list.func_150309_d(1), (double)pos.func_177952_p() + list.func_150309_d(2));
    }

    private void setSwapTemplateDirection(ItemStack stack, Direction direction) {
        stack.func_196082_o().func_74768_a(TAG_SWAP_DIRECTION, direction.func_176745_a());
    }

    private Direction getSwapTemplateDirection(ItemStack stack) {
        return Direction.func_82600_a((int)stack.func_196082_o().func_74762_e(TAG_SWAP_DIRECTION));
    }

    private void setSwapClickDirection(ItemStack stack, Direction direction) {
        stack.func_196082_o().func_74768_a(TAG_SWAP_CLICKED_AXIS, direction.func_176745_a());
    }

    private Direction getSwapClickDirection(ItemStack stack) {
        return Direction.func_82600_a((int)stack.func_196082_o().func_74762_e(TAG_SWAP_CLICKED_AXIS));
    }

    private int getRange(ItemStack stack, Direction.Axis clickAxis, Direction.Axis rangeAxis) {
        if (stack.func_196082_o().func_74767_n(TAG_TEMPERANCE_STONE) && rangeAxis == clickAxis) {
            return 0;
        }
        return 3 + ItemNBTHelper.getInt(stack, TAG_EXTRA_RANGE, 1) - 1;
    }

    private static void endSwapping(ItemStack stack) {
        ItemNBTHelper.setBoolean(stack, TAG_SWAPPING, false);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_X);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Y);
        ItemNBTHelper.removeEntry(stack, TAG_SELECT_Z);
        ItemNBTHelper.removeEntry(stack, TAG_TARGET_BLOCK_NAME);
        ItemNBTHelper.removeEntry(stack, TAG_SWAP_CLICKED_AXIS);
    }

    @Nonnull
    public ITextComponent func_200295_i(@Nonnull ItemStack stack) {
        Item item = this.getItemToPlace(stack);
        IFormattableTextComponent cmp = super.func_200295_i(stack).func_230532_e_();
        if (item != Items.field_190931_a) {
            cmp.func_240702_b_(" (");
            ITextComponent sub = new ItemStack((IItemProvider)item).func_200301_q();
            cmp.func_230529_a_((ITextComponent)sub.func_230532_e_().func_240699_a_(TextFormatting.GREEN));
            cmp.func_240702_b_(")");
        }
        return cmp;
    }

    private void setTarget(ItemStack stack, Block block) {
        ItemNBTHelper.setString(stack, TAG_TARGET_BLOCK_NAME, Registry.field_212618_g.func_177774_c((Object)block).toString());
    }

    public static Block getTargetState(ItemStack stack) {
        ResourceLocation id = new ResourceLocation(ItemNBTHelper.getString(stack, TAG_TARGET_BLOCK_NAME, "minecraft:air"));
        return (Block)Registry.field_212618_g.func_82594_a(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<BlockPos> getWireframesToDraw(PlayerEntity player, ItemStack stack) {
        ItemStack holding = player.func_184614_ca();
        if (holding != stack || !this.canExchange(stack)) {
            return ImmutableList.of();
        }
        RayTraceResult pos = Minecraft.func_71410_x().field_71476_x;
        if (pos != null && pos.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos bPos = ((BlockRayTraceResult)pos).func_216350_a();
            Block target = Minecraft.func_71410_x().field_71441_e.func_180495_p(bPos).func_177230_c();
            if (ItemNBTHelper.getBoolean(stack, TAG_SWAPPING, false)) {
                bPos = new BlockPos(ItemNBTHelper.getInt(stack, TAG_SELECT_X, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Y, 0), ItemNBTHelper.getInt(stack, TAG_SELECT_Z, 0));
                target = ItemExchangeRod.getTargetState(stack);
            }
            if (!player.field_70170_p.func_175623_d(bPos)) {
                Item item = this.getItemToPlace(stack);
                List<BlockPos> coordsList = this.getTargetPositions(player.field_70170_p, stack, item, bPos, target, ((BlockRayTraceResult)pos).func_216354_b());
                coordsList.removeIf(arg_0 -> ((BlockPos)bPos).equals(arg_0));
                return coordsList;
            }
        }
        return ImmutableList.of();
    }
}

