/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import vazkii.botania.api.item.IAncientWillContainer;
import vazkii.botania.api.mana.IManaDiscountArmor;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.PlayerEntityAccess;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.armor.terrasteel.ItemTerrasteelArmor;

public class ItemTerrasteelHelm
extends ItemTerrasteelArmor
implements IManaDiscountArmor,
IAncientWillContainer {
    public static final String TAG_ANCIENT_WILL = "AncientWill";

    public ItemTerrasteelHelm(Item.Properties props) {
        super(EquipmentSlotType.HEAD, props);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onCritEvent);
    }

    @Override
    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        super.onArmorTick(stack, world, player);
        if (!world.field_72995_K && this.hasArmorSet(player)) {
            int food = player.func_71024_bL().func_75116_a();
            if (food > 0 && food < 18 && player.func_70996_bM() && player.field_70173_aa % 80 == 0) {
                player.func_70691_i(1.0f);
            }
            if (player.field_70173_aa % 10 == 0) {
                ManaItemHandler.instance().dispatchManaExact(stack, player, 10, true);
            }
        }
    }

    @Override
    public float getDiscount(ItemStack stack, int slot, PlayerEntity player, @Nullable ItemStack tool) {
        return this.hasArmorSet(player) ? 0.2f : 0.0f;
    }

    @Override
    public void addAncientWill(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        ItemNBTHelper.setBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), true);
    }

    @Override
    public boolean hasAncientWill(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        return ItemTerrasteelHelm.hasAncientWill_(stack, will);
    }

    private static boolean hasAncientWill_(ItemStack stack, IAncientWillContainer.AncientWillType will) {
        return ItemNBTHelper.getBoolean(stack, "AncientWill_" + will.name().toLowerCase(Locale.ROOT), false);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        super.addArmorSetDescription(stack, list);
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!this.hasAncientWill(stack, type)) continue;
            list.add((ITextComponent)new TranslationTextComponent("botania.armorset.will_" + type.name().toLowerCase(Locale.ROOT) + ".desc").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public static boolean hasAnyWill(ItemStack stack) {
        for (IAncientWillContainer.AncientWillType type : IAncientWillContainer.AncientWillType.values()) {
            if (!ItemTerrasteelHelm.hasAncientWill_(stack, type)) continue;
            return true;
        }
        return false;
    }

    public void onCritEvent(CriticalHitEvent event) {
        Event.Result result = event.getResult();
        PlayerEntity player = event.getPlayer();
        if (result == Event.Result.DENY || result == Event.Result.DEFAULT && !event.isVanillaCritical() || !this.hasArmorSet(player)) {
            return;
        }
        Entity target = event.getTarget();
        if (target instanceof LivingEntity) {
            ((PlayerEntityAccess)player).botania$setCritTarget((LivingEntity)target);
            ItemStack stack = player.func_184582_a(EquipmentSlotType.HEAD);
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemTerrasteelHelm && this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.DHAROK)) {
                float amount = event.getDamageModifier();
                event.setDamageModifier(amount * (1.0f + (1.0f - player.func_110143_aJ() / player.func_110138_aP()) * 0.5f));
            }
        }
    }

    public void onEntityAttacked(DamageSource source, float amount, PlayerEntity player, LivingEntity entity) {
        ItemStack stack;
        if (this.hasArmorSet(player) && !(stack = player.func_184582_a(EquipmentSlotType.HEAD)).func_190926_b() && stack.func_77973_b() instanceof ItemTerrasteelHelm) {
            if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.AHRIM)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 20, 1));
            }
            if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.GUTHAN)) {
                player.func_70691_i(amount * 0.25f);
            }
            if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.TORAG)) {
                entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 60, 1));
            }
            if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.VERAC)) {
                source.func_76348_h();
            }
            if (this.hasAncientWill(stack, IAncientWillContainer.AncientWillType.KARIL)) {
                entity.func_195064_c(new EffectInstance(Effects.field_82731_v, 60, 1));
            }
        }
    }
}

