/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaPool;
import vazkii.botania.api.subtile.TileEntityFunctionalFlower;
import vazkii.botania.api.subtile.TileEntityGeneratingFlower;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.item.ItemTwigWand;

public class ItemObedienceStick
extends Item {
    private static final BiFunction<TileEntitySpecialFlower, TileEntity, Boolean> generatingActuator = (flower, tile) -> {
        if (flower instanceof TileEntityGeneratingFlower) {
            ((TileEntityGeneratingFlower)flower).linkToForcefully((TileEntity)tile);
            return true;
        }
        return false;
    };
    private static final BiFunction<TileEntitySpecialFlower, TileEntity, Boolean> functionalActuator = (flower, tile) -> {
        if (flower instanceof TileEntityFunctionalFlower) {
            ((TileEntityFunctionalFlower)flower).linkToForcefully((TileEntity)tile);
            return true;
        }
        return false;
    };

    public ItemObedienceStick(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        World world = ctx.func_195991_k();
        return ItemObedienceStick.applyStick(world, pos = ctx.func_195995_a()) ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    public static boolean applyStick(World world, BlockPos pos) {
        TileEntity tileAt = world.func_175625_s(pos);
        if (tileAt instanceof IManaPool || tileAt instanceof IManaCollector) {
            boolean pool = tileAt instanceof IManaPool;
            BiFunction<TileEntitySpecialFlower, TileEntity, Boolean> act = pool ? functionalActuator : generatingActuator;
            int range = pool ? 10 : 6;
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-range, -range, -range), (BlockPos)pos.func_177982_a(range, range, range))) {
                TileEntitySpecialFlower subtile;
                TileEntity tile;
                if (MathHelper.distSqr(iterPos, pos) > (double)(range * range) || !((tile = world.func_175625_s(iterPos)) instanceof TileEntitySpecialFlower) || !act.apply(subtile = (TileEntitySpecialFlower)tile, tileAt).booleanValue()) continue;
                ItemTwigWand.doParticleBeamWithOffset(world, iterPos, pos);
            }
            return true;
        }
        return false;
    }
}

