/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.api.recipes.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipes.IReplacementRule;
import com.blamejared.crafttweaker.api.recipes.ReplacementHandlerHelper;
import com.blamejared.crafttweaker.api.util.StringUtils;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;
import vazkii.botania.api.recipe.ITerraPlateRecipe;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.RecipeTerraPlate;

@Document(value="mods/Botania/TerraPlate")
@ZenRegister
@IRecipeHandler.For(value=RecipeTerraPlate.class)
@ZenCodeType.Name(value="mods.botania.TerraPlate")
public class TerraPlateRecipeManager
implements IRecipeManager,
IRecipeHandler<RecipeTerraPlate> {
    @ZenCodeType.Method
    public void addRecipe(String name, IItemStack output, int mana, IIngredient ... inputs) {
        name = this.fixRecipeName(name);
        ResourceLocation resourceLocation = new ResourceLocation("crafttweaker", name);
        NonNullList inputList = NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])Arrays.stream(inputs).map(IIngredient::asVanillaIngredient).toArray(Ingredient[]::new));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)this, (IRecipe)new RecipeTerraPlate(resourceLocation, mana, (NonNullList<Ingredient>)inputList, output.getInternal()), ""));
    }

    public IRecipeType<ITerraPlateRecipe> getRecipeType() {
        return ModRecipeTypes.TERRA_PLATE_TYPE;
    }

    public String dumpToCommandString(IRecipeManager manager, RecipeTerraPlate recipe) {
        StringJoiner s = new StringJoiner(", ", manager.getCommandString() + ".addRecipe(", ");");
        s.add(StringUtils.quoteAndEscape((ResourceLocation)recipe.func_199560_c()));
        s.add(new MCItemStackMutable(recipe.func_77571_b()).getCommandString());
        s.add(String.valueOf(recipe.getMana()));
        recipe.func_192400_c().stream().map(IIngredient::fromIngredient).map(IIngredient::getCommandString).forEach(s::add);
        return s.toString();
    }

    public Optional<Function<ResourceLocation, RecipeTerraPlate>> replaceIngredients(IRecipeManager manager, RecipeTerraPlate recipe, List<IReplacementRule> rules) {
        return ReplacementHandlerHelper.replaceNonNullIngredientList(recipe.func_192400_c(), Ingredient.class, (IRecipe)recipe, rules, ingr -> id -> new RecipeTerraPlate((ResourceLocation)id, recipe.getMana(), (NonNullList<Ingredient>)ingr, recipe.func_77571_b()));
    }
}

