/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.core.handler;

import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.event.AddReloadListenerEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.OrechidOutput;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class OrechidResourceListener
extends ReloadListener<Data> {
    private static final Gson GSON = new Gson();

    public static void registerListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new OrechidResourceListener());
    }

    @Nonnull
    protected Data prepare(@Nonnull IResourceManager manager, @Nonnull IProfiler profiler) {
        profiler.func_76320_a("orechidParse");
        Object2IntMap<StateIngredient> weights = OrechidResourceListener.loadWeights(manager, ResourceLocationHelper.prefix("orechid.json"));
        Object2IntMap<StateIngredient> nether = OrechidResourceListener.loadWeights(manager, ResourceLocationHelper.prefix("orechid_ignem.json"));
        profiler.func_76319_b();
        return new Data(weights, nether);
    }

    protected static Object2IntMap<StateIngredient> loadWeights(IResourceManager manager, ResourceLocation filename) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ResourceLocation location = new ResourceLocation(filename.func_110624_b(), "orechid_ore_weights/" + filename.func_110623_a());
        try {
            for (IResource resource : manager.func_199004_b(location)) {
                OrechidResourceListener.readResource((Object2IntMap<StateIngredient>)map, resource, location);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Botania.LOGGER.debug("Read {} data files in {}", (Object)filename, (Object)stopwatch.stop());
        return map;
    }

    protected static void readResource(Object2IntMap<StateIngredient> map, IResource resource, ResourceLocation location) {
        try (IResource r = resource;
             InputStream stream = r.func_199027_b();
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            StateIngredient state;
            JsonObject object;
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (JSONUtils.func_151209_a((JsonObject)json, (String)"replace", (boolean)false)) {
                map.clear();
            }
            if (JSONUtils.func_151202_d((JsonObject)json, (String)"remove")) {
                for (JsonElement value : JSONUtils.func_151214_t((JsonObject)json, (String)"remove")) {
                    object = value.getAsJsonObject();
                    state = StateIngredientHelper.tryDeserialize(object);
                    if (state == null) continue;
                    map.removeInt((Object)state);
                }
            }
            for (JsonElement value : JSONUtils.func_151214_t((JsonObject)json, (String)"values")) {
                object = value.getAsJsonObject();
                state = StateIngredientHelper.tryDeserialize(object);
                if (state == null) continue;
                int weight = JSONUtils.func_151203_m((JsonObject)object, (String)"weight");
                if (weight <= 0) {
                    Botania.LOGGER.error("Invalid weight: {} in file {} / {}, should be positive!", (Object)weight, (Object)resource.func_199026_d(), (Object)location);
                    continue;
                }
                map.put((Object)state, weight);
            }
        }
        catch (JsonParseException | IOException | IllegalArgumentException e) {
            Botania.LOGGER.error("Exception parsing orechid weights from {} / {}", (Object)resource.func_199026_d(), (Object)location, (Object)e);
        }
    }

    protected void apply(@Nonnull Data data, @Nonnull IResourceManager manager, @Nonnull IProfiler profiler) {
        profiler.func_76320_a("orechidApply");
        Map<ResourceLocation, Integer> map = BotaniaAPI.instance().getOreWeights();
        if (!map.isEmpty()) {
            Botania.LOGGER.warn("{} orechid weights using legacy api found", (Object)map.size());
            for (Map.Entry<ResourceLocation, Integer> entry : map.entrySet()) {
                data.normal.put((Object)StateIngredientHelper.of(entry.getKey()), entry.getValue().intValue());
            }
        }
        if (!(map = BotaniaAPI.instance().getNetherOreWeights()).isEmpty()) {
            Botania.LOGGER.warn("{} nether orechid weights using legacy api found", (Object)map.size());
            for (Map.Entry<ResourceLocation, Integer> entry : map.entrySet()) {
                data.nether.put((Object)StateIngredientHelper.of(entry.getKey()), entry.getValue().intValue());
            }
        }
        BotaniaAPIImpl.weights = this.postprocess(data.normal);
        BotaniaAPIImpl.netherWeights = this.postprocess(data.nether);
        profiler.func_76319_b();
    }

    protected List<OrechidOutput> postprocess(Object2IntMap<StateIngredient> map) {
        ArrayList<OrechidOutput> result = new ArrayList<OrechidOutput>();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            StateIngredient process = ((StateIngredient)entry.getKey()).resolveAndFilter(OrechidResourceListener::prioritizeConfig);
            if (process == null) continue;
            result.add(new OrechidOutput(entry.getIntValue(), process));
        }
        result.sort(Comparator.naturalOrder());
        return result;
    }

    protected static List<Block> prioritizeConfig(List<Block> blocks) {
        ArrayList<Block> out = new ArrayList<Block>();
        for (String mod : (List)ConfigHandler.COMMON.orechidPriorityMods.get()) {
            for (Block block : blocks) {
                if (!mod.equals(Registry.field_212618_g.func_177774_c((Object)block).func_110624_b())) continue;
                out.add(block);
            }
            if (out.isEmpty()) continue;
            return out;
        }
        return null;
    }

    protected static class Data {
        protected Object2IntMap<StateIngredient> normal;
        protected Object2IntMap<StateIngredient> nether;

        public Data(Object2IntMap<StateIngredient> normal, Object2IntMap<StateIngredient> nether) {
            this.normal = normal;
            this.nether = nether;
        }
    }
}

