/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.capability;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BLHBlockItemHandlerItemStack
implements IItemHandler {
    public final ItemStack stack;
    public final int slotLimit;

    public BLHBlockItemHandlerItemStack(ItemStack stack, int slotLimit) {
        this.stack = stack;
        this.slotLimit = slotLimit;
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        ItemStack copied = this.getStack();
        copied.func_190920_e(this.getAmount());
        return copied;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.isItemValid(slot, stack)) {
            int amount = this.getSlotLimit(slot);
            int stored = this.getAmount();
            int inserted = Math.min(amount - stored, stack.func_190916_E());
            if (this.getVoid()) {
                inserted = stack.func_190916_E();
            }
            if (!simulate) {
                this.setStack(stack);
                this.setAmount(Math.min(stored + inserted, amount));
            }
            if (inserted == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - inserted));
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack blStack = this.getStack();
        int stored = this.getAmount();
        if (blStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stored <= amount) {
            ItemStack out = blStack.func_77946_l();
            int newAmount = stored;
            if (!simulate) {
                this.setAmount(0);
            }
            out.func_190920_e(newAmount);
            return out;
        }
        if (!simulate) {
            this.setAmount(stored - amount);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)blStack, (int)amount);
    }

    public int getSlotLimit(int slot) {
        return this.slotLimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        ItemStack current = this.getStack();
        return current.func_190926_b() || current.func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)current, (ItemStack)stack);
    }

    public int getAmount() {
        CompoundNBT tag = this.getTag();
        if (tag != null && tag.func_74764_b("stored")) {
            return tag.func_74762_e("stored");
        }
        return 0;
    }

    public ItemStack getStack() {
        CompoundNBT tag = this.getTag();
        if (tag != null && tag.func_74764_b("blStack")) {
            return ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("blStack"));
        }
        return ItemStack.field_190927_a;
    }

    public boolean getVoid() {
        CompoundNBT tag = this.getTag();
        if (tag != null && tag.func_74764_b("voidItems")) {
            return tag.func_74767_n("voidItems");
        }
        return true;
    }

    private void setAmount(int amount) {
        CompoundNBT tag = this.getTag();
        if (tag == null) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("BlockEntityTag", (INBT)new CompoundNBT());
            this.stack.func_77982_d(compoundNBT);
        }
        this.stack.func_77978_p().func_74775_l("BlockEntityTag").func_74768_a("stored", amount);
    }

    private void setStack(ItemStack stack) {
        CompoundNBT tag = this.getTag();
        if (tag == null) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_218657_a("BlockEntityTag", (INBT)new CompoundNBT());
            this.stack.func_77982_d(compoundNBT);
        }
        this.stack.func_77978_p().func_74775_l("BlockEntityTag").func_218657_a("blStack", (INBT)stack.serializeNBT());
    }

    private CompoundNBT getTag() {
        if (this.stack.func_77942_o() && this.stack.func_77978_p().func_74764_b("BlockEntityTag")) {
            return this.stack.func_77978_p().func_74775_l("BlockEntityTag");
        }
        return null;
    }
}

