/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.trees;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.network.NodeInspector;
import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.compat.seasons.SeasonHelper;
import com.ferreusveritas.dynamictrees.event.SpeciesPostGenerationEvent;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKit;
import com.ferreusveritas.dynamictrees.growthlogic.context.PositionalSpeciesContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.nodemappers.FindEndsNode;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import com.ferreusveritas.dynamictreesplus.DynamicTreesPlus;
import com.ferreusveritas.dynamictreesplus.blocks.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.init.DTPConfigs;
import com.ferreusveritas.dynamictreesplus.init.DTPRegistries;
import com.ferreusveritas.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CactusSpecies
extends Species {
    public static final TypedRegistry.EntryType<Species> TYPE = CactusSpecies.createDefaultType(CactusSpecies::new);
    private CactusThicknessLogic thicknessLogic;

    public CactusSpecies(ResourceLocation name, Family family, LeavesProperties leavesProperties) {
        super(name, family, leavesProperties);
    }

    public Species setPreReloadDefaults() {
        this.setTransformable(false);
        return this.setSaplingShape(DTPRegistries.MEDIUM_CACTUS_SAPLING_SHAPE).setSaplingSound(SoundType.field_185854_g).setDefaultGrowingParameters().envFactor(BiomeDictionary.Type.SNOWY, 0.25f).envFactor(BiomeDictionary.Type.COLD, 0.5f).envFactor(BiomeDictionary.Type.SANDY, 1.05f).setGrowthLogicKit((GrowthLogicKit)DTPRegistries.CACTUS_LOGIC);
    }

    public Species setPostReloadDefaults() {
        if (this.thicknessLogic == null) {
            this.thicknessLogic = (CactusThicknessLogic)CactusThicknessLogic.REGISTRY.get(this.getRegistryName());
        }
        return super.setPostReloadDefaults();
    }

    public void setThicknessLogic(CactusThicknessLogic thicknessLogic) {
        this.thicknessLogic = thicknessLogic;
    }

    public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(World world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
        return this.thicknessLogic.thicknessAfterGrowthSignal(world, pos, signal, currentThickness);
    }

    public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(IWorld world, BlockPos pos, boolean isLast) {
        return this.thicknessLogic.thicknessForBranchPlaced(world, pos, isLast);
    }

    protected void setStandardSoils() {
        this.addAcceptableSoils(new String[]{"sand_like"});
    }

    public JoCode getJoCode(String joCodeString) {
        return new JoCodeCactus(joCodeString);
    }

    public boolean isBiomePerfect(Biome biome) {
        return this.perfectBiomes.size() > 0 ? super.isBiomePerfect(biome) : BiomeDictionary.hasType((RegistryKey)CactusSpecies.getBiomeKey((Biome)biome), (BiomeDictionary.Type)BiomeDictionary.Type.DRY) && BiomeDictionary.hasType((RegistryKey)CactusSpecies.getBiomeKey((Biome)biome), (BiomeDictionary.Type)BiomeDictionary.Type.SANDY);
    }

    public boolean handleRot(IWorld world, List<BlockPos> ends, BlockPos rootPos, BlockPos treePos, int soilLife, SafeChunkBounds safeBounds) {
        return false;
    }

    protected boolean transitionToTree(World world, BlockPos pos, Family family) {
        this.placeRootyDirtBlock((IWorld)world, pos.func_177977_b(), 15);
        family.getBranch().ifPresent(branch -> world.func_175656_a(pos, (BlockState)branch.func_176223_P().func_206870_a(CactusBranchBlock.TRUNK_TYPE, (Comparable)((Object)this.thicknessForBranchPlaced((IWorld)world, pos, false)))));
        return true;
    }

    public boolean canBoneMealTree() {
        return (Boolean)DTPConfigs.canBoneMealCactus.get();
    }

    public static float getEnergy(PositionalSpeciesContext context, int mod) {
        long day = context.world().func_82737_E() / 24000L;
        int month = (int)day / 30;
        return context.species().getSignalEnergy() * context.species().biomeSuitability(context.world(), context.pos()) + (float)(CoordUtils.coordHashCode((BlockPos)context.pos().func_177981_b(month), (int)2) % mod);
    }

    public ResourceLocation getSaplingSmartModelLocation() {
        return DynamicTreesPlus.resLoc("block/smart_model/" + this.thicknessLogic.getRegistryName().func_110623_a() + "_cactus");
    }

    public void addSaplingTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation leavesTextureLocation, ResourceLocation barkTextureLocation) {
        ResourceLocation sideTextureLocation = ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_side");
        textureConsumer.accept("particle", sideTextureLocation);
        textureConsumer.accept("side", sideTextureLocation);
        textureConsumer.accept("top", ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_top"));
        textureConsumer.accept("bottom", ResourceLocationUtils.suffix((ResourceLocation)barkTextureLocation, (String)"_bottom"));
    }

    public boolean shouldGenerateVoluntaryDrops() {
        return false;
    }

    private static class JoCodeCactus
    extends JoCode {
        public JoCodeCactus(String code) {
            super(code);
        }

        public void generate(WorldContext worldContext, Species species, BlockPos rootPos, Biome biome, Direction facing, int radius, SafeChunkBounds safeBounds, boolean secondChanceRegen) {
            IWorld world = worldContext.access();
            BlockState initialDirtState = world.func_180495_p(rootPos);
            species.placeRootyDirtBlock(world, rootPos, 0);
            radius = MathHelper.func_76125_a((int)radius, (int)2, (int)8);
            BlockPos treePos = rootPos.func_177984_a();
            this.setFacing(facing);
            this.generateFork(world, species, 0, rootPos, false);
            BranchBlock branch = TreeHelper.getBranch((BlockState)world.func_180495_p(treePos));
            if (branch != null) {
                FindEndsNode endFinder = new FindEndsNode();
                MapSignal signal = new MapSignal(new NodeInspector[]{endFinder});
                branch.analyse(world.func_180495_p(treePos), world, treePos, Direction.DOWN, signal);
                List endPoints = endFinder.getEnds();
                species.postGeneration(new PostGenerationContext(world, rootPos, species, biome, radius, endPoints, safeBounds, initialDirtState, SeasonHelper.getSeasonValue((IWorld)worldContext.level(), (BlockPos)rootPos), Float.valueOf(species.seasonalFruitProductionFactor(worldContext, rootPos))));
                MinecraftForge.EVENT_BUS.post((Event)new SpeciesPostGenerationEvent(world, species, rootPos, endPoints, safeBounds, initialDirtState));
            } else {
                world.func_180501_a(rootPos, initialDirtState, this.careful ? 3 : 2);
            }
        }

        public boolean setBlockForGeneration(IWorld world, Species species, BlockPos pos, Direction dir, boolean careful, boolean isLast) {
            Optional branch = species.getFamily().getBranch();
            if (!(species instanceof CactusSpecies) || !branch.isPresent()) {
                return false;
            }
            BlockState defaultBranchState = ((BranchBlock)branch.get()).func_176223_P();
            if (world.func_180495_p(pos).canBeReplacedByLogs((IWorldReader)world, pos) && (!careful || this.isClearOfNearbyBranches(world, pos, dir.func_176734_d()))) {
                CactusBranchBlock.CactusThickness trunk = ((CactusSpecies)species).thicknessForBranchPlaced(world, pos, isLast);
                return !world.func_180501_a(pos, (BlockState)((BlockState)defaultBranchState.func_206870_a(CactusBranchBlock.TRUNK_TYPE, (Comparable)((Object)trunk))).func_206870_a(CactusBranchBlock.ORIGIN, (Comparable)dir.func_176734_d()), careful ? 3 : 2);
            }
            return true;
        }
    }
}

