/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.trees;

import com.ferreusveritas.dynamictrees.api.registry.TypedRegistry;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.data.provider.BranchLoaderBuilder;
import com.ferreusveritas.dynamictrees.trees.Family;
import com.ferreusveritas.dynamictrees.util.ResourceLocationUtils;
import com.ferreusveritas.dynamictreesplus.blocks.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.event.BakedModelEventHandler;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class CactusFamily
extends Family {
    public static final TypedRegistry.EntryType<Family> TYPE = TypedRegistry.newType(CactusFamily::new);

    public CactusFamily(ResourceLocation registryName) {
        super(registryName);
    }

    public Material getDefaultBranchMaterial() {
        return Material.field_151570_A;
    }

    public SoundType getDefaultBranchSoundType() {
        return SoundType.field_185854_g;
    }

    protected BranchBlock createBranchBlock(ResourceLocation name) {
        return new CactusBranchBlock(name, this.getProperties());
    }

    public int getPrimaryThickness() {
        return 5;
    }

    public int getSecondaryThickness() {
        return 4;
    }

    public BiFunction<BlockModelBuilder, ExistingFileHelper, BranchLoaderBuilder> getBranchLoaderConstructor() {
        return (parent, existingFileHelper) -> new BranchLoaderBuilder(BakedModelEventHandler.CACTUS, parent, existingFileHelper);
    }

    public void addBranchTextures(BiConsumer<String, ResourceLocation> textureConsumer, ResourceLocation primitiveLogLocation) {
        textureConsumer.accept("bark", ResourceLocationUtils.suffix((ResourceLocation)primitiveLogLocation, (String)"_side"));
        textureConsumer.accept("rings", ResourceLocationUtils.suffix((ResourceLocation)primitiveLogLocation, (String)"_top"));
    }
}

