/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.thicknesslogic;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictreesplus.DynamicTreesPlus;
import com.ferreusveritas.dynamictreesplus.blocks.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.systems.thicknesslogic.CactusThicknessLogic;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public final class CactusThicknessLogicKits {
    public static final CactusThicknessLogic PILLAR = new CactusThicknessLogic(DynamicTreesPlus.resLoc("pillar")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(World world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            BlockState upState = world.func_180495_p(pos.func_177984_a());
            BlockState downState = world.func_180495_p(pos.func_177977_b());
            return upState.func_177230_c() instanceof CactusBranchBlock && downState.func_177230_c() instanceof CactusBranchBlock ? CactusBranchBlock.CactusThickness.TRUNK : CactusBranchBlock.CactusThickness.BRANCH;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(IWorld world, BlockPos pos, boolean isLast) {
            BlockState downState = world.func_180495_p(pos.func_177977_b());
            if (TreeHelper.isRooty((BlockState)downState) || isLast) {
                return CactusBranchBlock.CactusThickness.BRANCH;
            }
            return CactusBranchBlock.CactusThickness.TRUNK;
        }
    };
    public static final CactusThicknessLogic PIPE = new CactusThicknessLogic(DynamicTreesPlus.resLoc("pipe")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(World world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            return CactusBranchBlock.CactusThickness.BRANCH;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(IWorld world, BlockPos pos, boolean isLast) {
            return CactusBranchBlock.CactusThickness.BRANCH;
        }
    };
    public static final CactusThicknessLogic SAGUARO = new CactusThicknessLogic(DynamicTreesPlus.resLoc("saguaro")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(World world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            return currentThickness;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(IWorld world, BlockPos pos, boolean isLast) {
            BlockState downState = world.func_180495_p(pos.func_177977_b());
            if (TreeHelper.isRooty((BlockState)downState) || downState.func_177230_c() instanceof CactusBranchBlock && downState.func_177229_b(CactusBranchBlock.TRUNK_TYPE) == CactusBranchBlock.CactusThickness.TRUNK && downState.func_177229_b(CactusBranchBlock.ORIGIN) == Direction.DOWN) {
                return CactusBranchBlock.CactusThickness.TRUNK;
            }
            return CactusBranchBlock.CactusThickness.BRANCH;
        }
    };
    public static final CactusThicknessLogic MEGA = new CactusThicknessLogic(DynamicTreesPlus.resLoc("mega")){

        @Override
        public CactusBranchBlock.CactusThickness thicknessAfterGrowthSignal(World world, BlockPos pos, GrowSignal signal, CactusBranchBlock.CactusThickness currentThickness) {
            Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            Block down2 = world.func_180495_p(pos.func_177979_c(2)).func_177230_c();
            Block down3 = world.func_180495_p(pos.func_177979_c(3)).func_177230_c();
            if (down instanceof RootyBlock || down2 instanceof RootyBlock || down3 instanceof RootyBlock) {
                return CactusBranchBlock.CactusThickness.CORE;
            }
            return CactusBranchBlock.CactusThickness.TRUNK;
        }

        @Override
        public CactusBranchBlock.CactusThickness thicknessForBranchPlaced(IWorld world, BlockPos pos, boolean isLast) {
            Block down = world.func_180495_p(pos.func_177977_b()).func_177230_c();
            Block down2 = world.func_180495_p(pos.func_177979_c(2)).func_177230_c();
            Block down3 = world.func_180495_p(pos.func_177979_c(3)).func_177230_c();
            if (down instanceof RootyBlock || down2 instanceof RootyBlock || down3 instanceof RootyBlock) {
                return CactusBranchBlock.CactusThickness.CORE;
            }
            if (down instanceof CactusBranchBlock) {
                return CactusBranchBlock.CactusThickness.TRUNK;
            }
            return CactusBranchBlock.CactusThickness.BRANCH;
        }
    };
}

