/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.growthlogic;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.growthlogic.GrowthLogicKitConfiguration;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionManipulationContext;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictreesplus.blocks.CactusBranchBlock;
import com.ferreusveritas.dynamictreesplus.systems.growthlogic.CactusLogic;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class MegaCactusLogic
extends CactusLogic {
    private static final ConfigurationProperty<Integer> STOP_BRANCHING_HEIGHT = ConfigurationProperty.integer((String)"stop_branching_height");
    private static final ConfigurationProperty<Integer> MAX_HEIGHT = ConfigurationProperty.integer((String)"max_height");

    public MegaCactusLogic(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    protected void registerProperties() {
        super.registerProperties();
        this.register(new ConfigurationProperty[]{STOP_BRANCHING_HEIGHT, MAX_HEIGHT});
    }

    @Override
    protected GrowthLogicKitConfiguration createDefaultConfiguration() {
        return (GrowthLogicKitConfiguration)((GrowthLogicKitConfiguration)super.createDefaultConfiguration().with(STOP_BRANCHING_HEIGHT, (Object)5)).with(MAX_HEIGHT, (Object)7);
    }

    @Override
    public int[] populateDirectionProbabilityMap(GrowthLogicKitConfiguration configuration, DirectionManipulationContext context) {
        int[] probMap = context.probMap();
        GrowSignal signal = context.signal();
        World world = context.world();
        BlockPos pos = context.pos();
        Direction originDir = signal.dir.func_176734_d();
        int height = pos.func_177956_o() - signal.rootPos.func_177956_o();
        if (height >= (Integer)configuration.get(MAX_HEIGHT) && world.field_73012_v.nextFloat() < 0.8f) {
            signal.energy = 0.0f;
            return new int[]{0, 0, 0, 0, 0, 0};
        }
        if (height > (Integer)configuration.get(STOP_BRANCHING_HEIGHT)) {
            return new int[]{0, 1, 0, 0, 0, 0};
        }
        probMap[0] = 0;
        probMap[1] = (int)((double)context.species().getUpProbability() + signal.rootPos.func_218140_a((double)pos.func_177958_n(), (double)signal.rootPos.func_177956_o(), (double)pos.func_177952_p(), true) * 0.8);
        probMap[5] = world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof CactusBranchBlock && signal.energy > 1.0f ? 3 : 0;
        probMap[4] = probMap[5];
        probMap[3] = probMap[5];
        probMap[2] = probMap[5];
        if (signal.dir != Direction.UP) {
            probMap[signal.dir.ordinal()] = 0;
        }
        probMap[originDir.ordinal()] = 0;
        return probMap;
    }
}

