/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.configurations.ConfigurationProperty;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeature;
import com.ferreusveritas.dynamictrees.systems.genfeatures.GenFeatureConfiguration;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGenerationContext;
import com.ferreusveritas.dynamictrees.systems.genfeatures.context.PostGrowContext;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.util.WorldContext;
import com.ferreusveritas.dynamictreesplus.blocks.CactusBranchBlock;
import java.util.Arrays;
import java.util.LinkedList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.WorldGenRegion;

public class CactusClonesGenFeature
extends GenFeature {
    public static final ConfigurationProperty<Float> CHANCE_ON_GROW = ConfigurationProperty.floatProperty((String)"chance_on_grow");
    public static final ConfigurationProperty<CactusBranchBlock.CactusThickness> TRUNK_TYPE = ConfigurationProperty.property((String)"trunk_type", CactusBranchBlock.CactusThickness.class);

    public CactusClonesGenFeature(ResourceLocation registryName) {
        super(registryName);
    }

    protected void registerProperties() {
        this.register(new ConfigurationProperty[]{CHANCE_ON_GROW, TRUNK_TYPE});
    }

    protected GenFeatureConfiguration createDefaultConfiguration() {
        return (GenFeatureConfiguration)((GenFeatureConfiguration)super.createDefaultConfiguration().with(CHANCE_ON_GROW, (Object)Float.valueOf(0.3f))).with(TRUNK_TYPE, (Object)CactusBranchBlock.CactusThickness.BRANCH);
    }

    protected boolean postGenerate(GenFeatureConfiguration configuration, PostGenerationContext context) {
        return this.tryToPlaceClones(context.world(), context.pos(), context.species(), true, context.bounds());
    }

    protected boolean postGrow(GenFeatureConfiguration configuration, PostGrowContext context) {
        return context.random().nextFloat() < ((Float)configuration.get(CHANCE_ON_GROW)).floatValue() && this.tryToPlaceClones(context.world(), context.pos(), context.species(), false, SafeChunkBounds.ANY);
    }

    private boolean tryToPlaceClones(IWorld world, BlockPos rootPos, Species species, boolean worldgen, SafeChunkBounds safeBounds) {
        if (world == null || this.areCactiAround(world, rootPos.func_177984_a(), safeBounds)) {
            return false;
        }
        int clones = 3 + world.func_201674_k().nextInt(5);
        LinkedList<CoordUtils.Surround> validDirs = new LinkedList<CoordUtils.Surround>(Arrays.asList(CoordUtils.Surround.values()));
        boolean clonePlaced = false;
        for (int i = 0; i < clones; ++i) {
            CoordUtils.Surround selectedDir = (CoordUtils.Surround)validDirs.get(world.func_201674_k().nextInt(validDirs.size()));
            if (this.placeCloneAtLocation(world, rootPos.func_177971_a(selectedDir.getOffset()), species, worldgen, safeBounds)) {
                clonePlaced = true;
            }
            validDirs.remove(selectedDir);
        }
        return clonePlaced;
    }

    private boolean areCactiAround(IWorld world, BlockPos rootPos, SafeChunkBounds safeBounds) {
        for (CoordUtils.Surround dir : CoordUtils.Surround.values()) {
            for (int i = -1; i <= 1; ++i) {
                BlockPos offsetPos = rootPos.func_177971_a(dir.getOffset()).func_177981_b(i);
                if (!safeBounds.inBounds(offsetPos, false) || !(world.func_180495_p(offsetPos).func_177230_c() instanceof BranchBlock)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean placeCloneAtLocation(IWorld world, BlockPos cloneRootPos, Species species, boolean worldgen, SafeChunkBounds safeBounds) {
        for (int i = 1; i >= -1; --i) {
            BlockPos offsetRootPos = cloneRootPos.func_177981_b(i);
            if (!safeBounds.inBounds(offsetRootPos, false) || !species.isAcceptableSoil(world.func_180495_p(offsetRootPos))) continue;
            if (worldgen) {
                if (world instanceof WorldGenRegion) {
                    species.generate(WorldContext.create((IWorld)world), offsetRootPos, world.func_225526_b_(offsetRootPos.func_177958_n(), offsetRootPos.func_177956_o(), offsetRootPos.func_177952_p()), world.func_201674_k(), 2, safeBounds);
                }
            } else if (world instanceof World) {
                species.transitionToTree((World)world, offsetRootPos.func_177984_a());
            }
            return true;
        }
        return false;
    }
}

