/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.models.bakedmodels;

import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.client.ModelUtils;
import com.ferreusveritas.dynamictrees.models.bakedmodels.BranchBlockBakedModel;
import com.ferreusveritas.dynamictrees.models.modeldata.ModelConnections;
import com.ferreusveritas.dynamictreesplus.blocks.CactusBranchBlock;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

@OnlyIn(value=Dist.CLIENT)
public class CactusBranchBlockBakedModel
extends BranchBlockBakedModel {
    private TextureAtlasSprite barkTexture;
    private final IBakedModel[][] sleeves = new IBakedModel[6][3];
    private final IBakedModel[][] cores = new IBakedModel[3][3];
    private final IBakedModel[] rings = new IBakedModel[3];
    private final IBakedModel[] coreSpikes = new IBakedModel[3];
    private IBakedModel sleeveTopSpikes;
    int[] radii = new int[]{4, 5, 7};

    public CactusBranchBlockBakedModel(ResourceLocation modelResLoc, ResourceLocation barkResLoc, ResourceLocation ringsResLoc) {
        super(modelResLoc, barkResLoc, ringsResLoc);
    }

    public void setupModels() {
        this.barkTexture = ModelUtils.getTexture((ResourceLocation)this.barkResLoc);
        TextureAtlasSprite ringsTexture = ModelUtils.getTexture((ResourceLocation)this.ringsResLoc);
        for (int i = 0; i < 3; ++i) {
            int radius = this.radii[i];
            for (Direction dir : Direction.values()) {
                this.sleeves[dir.func_176745_a()][i] = this.bakeSleeve(radius, dir, this.barkTexture, ringsTexture);
            }
            this.cores[0][i] = this.bakeCore(radius, Direction.Axis.Y, this.barkTexture);
            this.cores[1][i] = this.bakeCore(radius, Direction.Axis.Z, this.barkTexture);
            this.cores[2][i] = this.bakeCore(radius, Direction.Axis.X, this.barkTexture);
            this.rings[i] = this.bakeCore(radius, Direction.Axis.Y, ringsTexture);
            this.coreSpikes[i] = this.bakeCoreSpikes(radius, this.barkTexture);
            this.sleeveTopSpikes = this.bakeTopSleeveSpikes(this.barkTexture);
        }
    }

    private void putVertex(BakedQuadBuilder builder, Vector3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite, float r, float g, float b) {
        ImmutableList elements = DefaultVertexFormats.field_176600_a.func_227894_c_().asList();
        block10: for (int j = 0; j < elements.size(); ++j) {
            VertexFormatElement e = (VertexFormatElement)elements.get(j);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(j, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(j, new float[]{r, g, b, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (e.func_177369_e()) {
                        case 0: {
                            float iu = sprite.func_94214_a((double)u);
                            float iv = sprite.func_94207_b((double)v);
                            builder.put(j, new float[]{iu, iv});
                            continue block10;
                        }
                        case 2: {
                            builder.put(j, new float[]{0.0f, 0.0f});
                            continue block10;
                        }
                    }
                    builder.put(j, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(j, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c});
                    continue block10;
                }
                default: {
                    builder.put(j, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vector3d v1, float v1u, float v1v, Vector3d v2, float v2u, float v2v, Vector3d v3, float v3u, float v3v, Vector3d v4, float v4u, float v4v, TextureAtlasSprite sprite) {
        Vector3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(Direction.func_210769_a((double)normal.field_72450_a, (double)normal.field_72448_b, (double)normal.field_72449_c));
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v1u, v1v, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, v2u, v2v, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, v3u, v3v, sprite, 1.0f, 1.0f, 1.0f);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, v4u, v4v, sprite, 1.0f, 1.0f, 1.0f);
        return builder.build();
    }

    public IBakedModel bakeSleeve(int radius, Direction dir, TextureAtlasSprite bark, TextureAtlasSprite top) {
        boolean negative;
        int dradius = radius * 2;
        int halfSize = (16 - dradius) / 2;
        int halfSizeX = dir.func_82601_c() != 0 ? halfSize : dradius;
        int halfSizeY = dir.func_96559_d() != 0 ? halfSize : dradius;
        int halfSizeZ = dir.func_82599_e() != 0 ? halfSize : dradius;
        int move = 16 - halfSize;
        int centerX = 16 + dir.func_82601_c() * move;
        int centerY = 16 + dir.func_96559_d() * move;
        int centerZ = 16 + dir.func_82599_e() * move;
        Vector3f posFrom = new Vector3f((float)(centerX - halfSizeX) / 2.0f, (float)(centerY - halfSizeY) / 2.0f, (float)(centerZ - halfSizeZ) / 2.0f);
        Vector3f posTo = new Vector3f((float)(centerX + halfSizeX) / 2.0f, (float)(centerY + halfSizeY) / 2.0f, (float)(centerZ + halfSizeZ) / 2.0f);
        boolean bl = negative = dir.func_176743_c() == Direction.AxisDirection.NEGATIVE;
        if (dir.func_176740_k() == Direction.Axis.Z) {
            negative = !negative;
        }
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            if (dir.func_176734_d() == face) continue;
            BlockFaceUV uvface = null;
            if (dir == face) {
                if (radius == 4 || radius == 5 && dir == Direction.DOWN) {
                    uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, 0);
                }
            } else {
                uvface = new BlockFaceUV(new float[]{8 - radius, negative ? (float)(16 - halfSize) : 0.0f, 8 + radius, negative ? 16.0f : (float)halfSize}, this.getFaceAngle(dir.func_176740_k(), face));
            }
            if (uvface == null) continue;
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(bark);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)(dir == face ? top : bark), (Direction)face, (ModelRotation)ModelRotation.X0_Y0, (ResourceLocation)this.modelResLoc));
        }
        float minV = negative ? (float)(16 - halfSize) : 0.0f;
        float maxV = negative ? 16.0f : (float)halfSize;
        switch (dir.func_176740_k()) {
            case X: {
                builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 16.0f, maxV, bark));
                builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 2.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 2.0f, maxV, bark));
                builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 16.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 16.0f, minV, bark));
                builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 2.0f, minV, bark));
                builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, bark));
                builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, bark));
                builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, bark));
                builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 2.0f, minV, bark));
                break;
            }
            case Y: {
                builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, bark));
                builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, bark));
                builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, bark));
                builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, bark));
                builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 16.0f, minV, bark));
                builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 2.0f, minV, bark));
                builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 16.0f, maxV, bark));
                builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 2.0f, maxV, bark));
                break;
            }
            case Z: {
                builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, bark));
                builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, bark));
                builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, bark));
                builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, bark));
                builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, bark));
                builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, bark));
                builder.func_177650_a(Direction.UP, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, bark));
                builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, bark));
            }
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCore(int radius, Direction.Axis axis, TextureAtlasSprite icon) {
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction face : Direction.values()) {
            BlockFaceUV uvface = new BlockFaceUV(new float[]{8 - radius, 8 - radius, 8 + radius, 8 + radius}, this.getFaceAngle(axis, face));
            mapFacesIn.put(face, new BlockPartFace(null, -1, null, uvface));
        }
        BlockPart part = new BlockPart(posFrom, posTo, (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(icon);
        for (Map.Entry e : part.field_178240_c.entrySet()) {
            Direction face = (Direction)e.getKey();
            builder.func_177650_a(face, ModelUtils.makeBakedQuad((BlockPart)part, (BlockPartFace)((BlockPartFace)e.getValue()), (TextureAtlasSprite)icon, (Direction)face, (ModelRotation)ModelRotation.X0_Y0, (ResourceLocation)this.modelResLoc));
        }
        return builder.func_177645_b();
    }

    public IBakedModel bakeCoreSpikes(int radius, TextureAtlasSprite bark) {
        float minV = 8 - radius;
        float maxV = 8 + radius;
        Vector3f posFrom = new Vector3f((float)(8 - radius), (float)(8 - radius), (float)(8 - radius));
        Vector3f posTo = new Vector3f((float)(8 + radius), (float)(8 + radius), (float)(8 + radius));
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(bark);
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 2.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f - 0.002f), 2.0f, maxV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 16.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f + 0.002f), 2.0f, minV, bark));
        builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, bark));
        builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posFrom.func_195900_b() / 16.0f - 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, bark));
        builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, bark));
        builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, this.v(posTo.func_195899_a() / 16.0f, posTo.func_195900_b() / 16.0f + 0.002f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, bark));
        builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, bark));
        builder.func_177650_a(Direction.SOUTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f - 0.0625f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.0625f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.NORTH, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.0625f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.001f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f + 0.0625f), 2.0f, minV, bark));
        builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posFrom.func_195902_c() / 16.0f - 0.001f), 2.0f, minV, bark));
        builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f, posTo.func_195902_c() / 16.0f + 0.001f), 2.0f, maxV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.DOWN, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posFrom.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, bark));
        builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posFrom.func_195900_b() / 16.0f - 0.001f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, bark));
        builder.func_177650_a(Direction.EAST, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.WEST, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, bark));
        return builder.func_177645_b();
    }

    public IBakedModel bakeTopSleeveSpikes(TextureAtlasSprite bark) {
        float minV = 4.0f;
        float maxV = 12.0f;
        Vector3f posFrom = new Vector3f(4.0f, 16.0f, 4.0f);
        Vector3f posTo = new Vector3f(12.0f, 16.0f, 12.0f);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder((IModelConfiguration)this.blockModel.customData, ItemOverrideList.field_188022_a).func_177646_a(bark);
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posTo, posTo, posFrom, 0.0f, 0.0625f, -0.002f), 16.0f, minV, this.v(posTo, posTo, posFrom, 0.0f, -0.0625f, -0.002f), 14.0f, minV, this.v(posFrom, posTo, posFrom, 0.0f, -0.0625f, -0.002f), 14.0f, maxV, this.v(posFrom, posTo, posFrom, 0.0f, 0.0625f, -0.002f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom, posTo, posTo, 0.0f, 0.0625f, 0.002f), 16.0f, maxV, this.v(posFrom, posTo, posTo, 0.0f, -0.0625f, 0.002f), 14.0f, maxV, this.v(posTo, posTo, posTo, 0.0f, -0.0625f, 0.002f), 14.0f, minV, this.v(posTo, posTo, posTo, 0.0f, 0.0625f, 0.002f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom, posTo, posTo, 0.0f, 0.002f, -0.0625f), 14.0f, maxV, this.v(posFrom, posTo, posTo, 0.0f, 0.002f, 0.0625f), 16.0f, maxV, this.v(posTo, posTo, posTo, 0.0f, 0.002f, 0.0625f), 16.0f, minV, this.v(posTo, posTo, posTo, 0.0f, 0.002f, -0.0625f), 14.0f, minV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom, posTo, posFrom, 0.0f, 0.002f, -0.0625f), 0.0f, maxV, this.v(posFrom, posTo, posFrom, 0.0f, 0.002f, 0.0625f), 2.0f, maxV, this.v(posTo, posTo, posFrom, 0.0f, 0.002f, 0.0625f), 2.0f, minV, this.v(posTo, posTo, posFrom, 0.0f, 0.002f, -0.0625f), 0.0f, minV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f - 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f - 0.0625f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f + 0.002f, posTo.func_195900_b() / 16.0f + 0.0625f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 16.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 14.0f, minV, this.v(posTo.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 14.0f, maxV, this.v(posTo.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 16.0f, maxV, bark));
        builder.func_177650_a(Direction.UP, this.createQuad(this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 2.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posFrom.func_195902_c() / 16.0f), 0.0f, minV, this.v(posFrom.func_195899_a() / 16.0f - 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 0.0f, maxV, this.v(posFrom.func_195899_a() / 16.0f + 0.0625f, posTo.func_195900_b() / 16.0f + 0.001f, posTo.func_195902_c() / 16.0f), 2.0f, maxV, bark));
        return builder.func_177645_b();
    }

    public int getFaceAngle(Direction.Axis axis, Direction face) {
        if (axis == Direction.Axis.Y) {
            return 0;
        }
        if (axis == Direction.Axis.Z) {
            switch (face) {
                case UP: {
                    return 0;
                }
                case WEST: {
                    return 270;
                }
                case DOWN: {
                    return 180;
                }
            }
            return 90;
        }
        return face == Direction.NORTH ? 270 : 90;
    }

    private Vector3d v(Vector3f xVec, Vector3f yVec, Vector3f zVec, float xOffset, float yOffset, float zOffset) {
        return this.v(xVec.func_195899_a() / 16.0f + xOffset, yVec.func_195900_b() / 16.0f + yOffset, zVec.func_195902_c() / 16.0f + zOffset);
    }

    private Vector3d v(float x, float y, float z) {
        return new Vector3d((double)x, (double)y, (double)z);
    }

    private int getRadiusIndex(int radius) {
        for (int i = 0; i < this.radii.length; ++i) {
            if (radius != this.radii[i]) continue;
            return i;
        }
        return 0;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        if (side == null && state != null) {
            ArrayList<BakedQuad> quadsList = new ArrayList<BakedQuad>(12);
            int coreRadius = this.getRadius(state);
            int[] connections = new int[]{0, 0, 0, 0, 0, 0};
            Direction forceRingDir = null;
            if (extraData instanceof ModelConnections) {
                connections = ((ModelConnections)extraData).getAllRadii();
                forceRingDir = ((ModelConnections)extraData).getRingOnly();
            }
            int numConnections = 0;
            for (int i : connections) {
                numConnections += i != 0 ? 1 : 0;
            }
            if (numConnections == 0 && forceRingDir != null) {
                quadsList.addAll(this.rings[this.getRadiusIndex(coreRadius)].getQuads(state, forceRingDir, rand, extraData));
            } else {
                Direction sourceDir;
                boolean extraUpSleeve = false;
                if (coreRadius == this.radii[0] && numConnections == 1 && ((Direction)state.func_177229_b(CactusBranchBlock.ORIGIN)).func_176740_k().func_176722_c()) {
                    connections[1] = this.radii[0];
                    extraUpSleeve = true;
                }
                if ((sourceDir = this.getSourceDir(coreRadius, connections)) == null) {
                    sourceDir = Direction.DOWN;
                }
                int coreDir = this.resolveCoreDir(sourceDir);
                Direction coreRingDir = numConnections == 1 ? sourceDir.func_176734_d() : null;
                for (Direction face : Direction.values()) {
                    if (coreRadius != connections[face.func_176745_a()]) {
                        if (coreRingDir == null || coreRingDir != face) {
                            quadsList.addAll(this.cores[coreDir][this.getRadiusIndex(coreRadius)].getQuads(state, face, rand, extraData));
                        } else {
                            quadsList.addAll(this.rings[this.getRadiusIndex(coreRadius)].getQuads(state, face, rand, extraData));
                        }
                    }
                    for (Direction dir : Direction.values()) {
                        if (coreRadius <= connections[dir.func_176745_a()]) continue;
                        for (BakedQuad quad : this.coreSpikes[this.getRadiusIndex(coreRadius)].getQuads(state, dir, rand, extraData)) {
                            if (coreRadius <= connections[quad.func_178210_d().func_176745_a()]) continue;
                            quadsList.add(quad);
                        }
                    }
                    for (Direction connDir : Direction.values()) {
                        int idx = connDir.func_176745_a();
                        int connRadius = connections[idx];
                        if (connRadius < this.radii[0] || (connDir != Direction.UP || connRadius != this.radii[0] || !extraUpSleeve) && face == connDir && connDir != Direction.DOWN) continue;
                        quadsList.addAll(this.sleeves[idx][this.getRadiusIndex(connRadius)].getQuads(state, face, rand, extraData));
                    }
                }
                if (extraUpSleeve) {
                    quadsList.addAll(this.sleeveTopSpikes.getQuads(state, Direction.UP, rand, extraData));
                }
            }
            return quadsList;
        }
        return Collections.emptyList();
    }

    public IModelData getModelData(IBlockDisplayReader world, BlockPos pos, BlockState state, IModelData tileData) {
        Block block = state.func_177230_c();
        return block instanceof BranchBlock ? new ModelConnections(((BranchBlock)block).getConnectionData(world, pos, state)) : new ModelConnections();
    }

    @Nullable
    protected Direction getSourceDir(int coreRadius, int[] connections) {
        int largestConnection = 0;
        Direction sourceDir = null;
        for (Direction dir : Direction.values()) {
            int connRadius = connections[dir.func_176745_a()];
            if (connRadius <= largestConnection) continue;
            largestConnection = connRadius;
            sourceDir = dir;
        }
        if (largestConnection < coreRadius) {
            sourceDir = null;
        }
        return sourceDir;
    }

    protected int resolveCoreDir(Direction dir) {
        return dir.func_176745_a() >> 1;
    }

    protected int getRadius(BlockState blockState) {
        return ((CactusBranchBlock)blockState.func_177230_c()).getRadius(blockState);
    }

    public boolean func_177555_b() {
        return true;
    }

    public TextureAtlasSprite getParticleTexture(IModelData data) {
        return this.func_177554_e();
    }

    public TextureAtlasSprite func_177554_e() {
        return this.barkTexture;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean doesHandlePerspectives() {
        return false;
    }

    public boolean func_230044_c_() {
        return false;
    }
}

