/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictreesplus.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.api.cells.Cell;
import com.ferreusveritas.dynamictrees.api.cells.CellNull;
import com.ferreusveritas.dynamictrees.api.network.MapSignal;
import com.ferreusveritas.dynamictrees.api.treedata.TreePart;
import com.ferreusveritas.dynamictrees.blocks.branches.BranchBlock;
import com.ferreusveritas.dynamictrees.blocks.leaves.LeavesProperties;
import com.ferreusveritas.dynamictrees.blocks.rootyblocks.RootyBlock;
import com.ferreusveritas.dynamictrees.growthlogic.context.DirectionSelectionContext;
import com.ferreusveritas.dynamictrees.init.DTConfigs;
import com.ferreusveritas.dynamictrees.loot.DTLootParameterSets;
import com.ferreusveritas.dynamictrees.loot.entry.SeedItemLootEntry;
import com.ferreusveritas.dynamictrees.loot.function.MultiplyLogsCount;
import com.ferreusveritas.dynamictrees.loot.function.MultiplySticksCount;
import com.ferreusveritas.dynamictrees.systems.GrowSignal;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.Connections;
import com.ferreusveritas.dynamictrees.util.CoordUtils;
import com.ferreusveritas.dynamictreesplus.init.DTPConfigs;
import com.ferreusveritas.dynamictreesplus.trees.CactusSpecies;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.functions.ExplosionDecay;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CactusBranchBlock
extends BranchBlock {
    public static final EnumProperty<Direction> ORIGIN = EnumProperty.func_177708_a((String)"origin", Direction.class, (Predicate)((com.google.common.base.Predicate)dir -> dir != Direction.UP));
    public static final EnumProperty<CactusThickness> TRUNK_TYPE = EnumProperty.func_177709_a((String)"type", CactusThickness.class);
    private static final double hurtMovementDelta = 0.003;

    public CactusBranchBlock(ResourceLocation name, AbstractBlock.Properties properties) {
        super(name, properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TRUNK_TYPE, (Comparable)((Object)CactusThickness.TRUNK))).func_206870_a(ORIGIN, (Comparable)Direction.DOWN));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ORIGIN, TRUNK_TYPE});
    }

    public int branchSupport(BlockState blockState, IBlockReader blockAccess, BranchBlock branch, BlockPos pos, Direction dir, int radius) {
        return 0;
    }

    public float getHardness(BlockState state, IBlockReader world, BlockPos pos) {
        int radius = this.getRadius(state);
        float hardness = this.getFamily().getPrimitiveLog().orElse(Blocks.field_150350_a).func_176223_P().func_185887_b(world, pos) * (float)(radius * radius) / 64.0f * 8.0f;
        return (float)Math.min((double)hardness, (Double)DTConfigs.MAX_TREE_HARDNESS.get());
    }

    public boolean checkForRot(IWorld world, BlockPos pos, Species species, int radius, int fertility, Random rand, float chance, boolean rapid) {
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        boolean damage = false;
        if (((Boolean)DTPConfigs.cactusPrickleOnMoveOnly.get()).booleanValue() && entity instanceof LivingEntity) {
            boolean falling = entity.func_213322_ci().field_72448_b < 0.0;
            entity.func_213293_j(entity.func_213322_ci().field_72450_a * 0.25, entity.func_213322_ci().field_72448_b * (falling ? 0.5 : 1.0), entity.func_213322_ci().field_72449_c * 0.25);
            if (!(worldIn.field_72995_K || entity.field_70142_S == entity.func_226277_ct_() && entity.field_70137_T == entity.func_226278_cu_() && entity.field_70136_U == entity.func_226281_cx_())) {
                double xMovement = Math.abs(entity.func_226277_ct_() - entity.field_70142_S);
                double yMovement = Math.abs(entity.func_226278_cu_() - entity.field_70137_T);
                double zMovement = Math.abs(entity.func_226281_cx_() - entity.field_70136_U);
                if (xMovement >= 0.003 || yMovement >= 0.003 || zMovement >= 0.003) {
                    damage = true;
                }
            }
        } else if (!(entity instanceof ItemEntity) || ((Boolean)DTPConfigs.cactusKillItems.get()).booleanValue()) {
            damage = true;
        }
        if (damage) {
            entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState returnState = this.func_176223_P();
        BlockState adjState = context.func_195991_k().func_180495_p(context.func_195995_a().func_177972_a(context.func_196000_l().func_176734_d()));
        boolean trunk = context.func_196000_l() == Direction.UP && (adjState.func_177230_c() != this || adjState.func_177229_b(TRUNK_TYPE) != CactusThickness.BRANCH);
        return (BlockState)((BlockState)returnState.func_206870_a(TRUNK_TYPE, (Comparable)((Object)(trunk ? CactusThickness.TRUNK : CactusThickness.BRANCH)))).func_206870_a(ORIGIN, (Comparable)(context.func_196000_l() != Direction.DOWN ? context.func_196000_l().func_176734_d() : Direction.DOWN));
    }

    public Cell getHydrationCell(IBlockReader blockAccess, BlockPos pos, BlockState blockState, Direction dir, LeavesProperties leavesProperties) {
        return CellNull.NULL_CELL;
    }

    protected int getCactusRadius(CactusThickness trunk) {
        switch (trunk) {
            default: {
                return this.getFamily().getSecondaryThickness();
            }
            case TRUNK: {
                return this.getFamily().getPrimaryThickness();
            }
            case CORE: 
        }
        return 7;
    }

    public int getRadius(BlockState blockState) {
        return blockState.func_177230_c() == this ? this.getCactusRadius((CactusThickness)((Object)blockState.func_177229_b(TRUNK_TYPE))) : 0;
    }

    public int setRadius(IWorld world, BlockPos pos, int radius, Direction originDir, int flags) {
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        world.func_180501_a(pos, (BlockState)this.getStateForRadius(radius).func_206870_a(ORIGIN, (Comparable)originDir), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    public int probabilityForBlock(BlockState blockState, IBlockReader blockAccess, BlockPos pos, BranchBlock from) {
        return this.isSameTree(from) ? this.getRadius(blockState) + 2 : 0;
    }

    public GrowSignal growIntoAir(World world, BlockPos pos, GrowSignal signal) {
        Direction originDir = signal.dir.func_176734_d();
        CactusThickness trunk = signal.getSpecies() instanceof CactusSpecies ? ((CactusSpecies)signal.getSpecies()).thicknessForBranchPlaced((IWorld)world, pos, true) : CactusThickness.BRANCH;
        if (originDir.func_176740_k() != Direction.Axis.Y && (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this || world.func_180495_p(pos.func_177977_b()).func_177230_c() == this)) {
            signal.success = false;
            return signal;
        }
        signal.success = world.func_180501_a(pos, (BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TRUNK_TYPE, (Comparable)((Object)trunk))).func_206870_a(ORIGIN, (Comparable)originDir), 2);
        signal.radius = this.getCactusRadius(trunk);
        return signal;
    }

    public GrowSignal growSignal(World world, BlockPos pos, GrowSignal signal) {
        if (signal.step()) {
            CactusThickness newIsTrunk;
            CactusThickness isTrunk;
            Species species = signal.getSpecies();
            Direction targetDir = species.getGrowthLogicKit().selectNewDirection(new DirectionSelectionContext(world, pos, signal.getSpecies(), (BranchBlock)this, signal));
            signal.doTurn(targetDir);
            BlockPos deltaPos = pos.func_177972_a(targetDir);
            BlockState deltaState = world.func_180495_p(deltaPos);
            TreePart treepart = TreeHelper.getTreePart((BlockState)deltaState);
            if (treepart == this) {
                signal = treepart.growSignal(world, deltaPos, signal);
            } else if (world.func_175623_d(deltaPos)) {
                signal = this.growIntoAir(world, deltaPos, signal);
            }
            BlockState thisState = world.func_180495_p(pos);
            if (thisState.func_177230_c() == this && species instanceof CactusSpecies && (isTrunk = (CactusThickness)((Object)thisState.func_177229_b(TRUNK_TYPE))) != (newIsTrunk = ((CactusSpecies)species).thicknessAfterGrowthSignal(world, pos, signal, isTrunk))) {
                this.setRadius((IWorld)world, pos, this.getCactusRadius(newIsTrunk), (Direction)thisState.func_177229_b(ORIGIN));
            }
        }
        return signal;
    }

    public BlockState getStateForRadius(int radius) {
        CactusThickness thickness = CactusThickness.BRANCH;
        if (radius >= this.getCactusRadius(CactusThickness.CORE)) {
            thickness = CactusThickness.CORE;
        } else if (radius >= this.getCactusRadius(CactusThickness.TRUNK)) {
            thickness = CactusThickness.TRUNK;
        }
        return (BlockState)this.func_176223_P().func_206870_a(TRUNK_TYPE, (Comparable)((Object)thickness));
    }

    public Connections getConnectionData(@Nonnull IBlockDisplayReader world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Connections connections = new Connections();
        for (Direction dir : Direction.values()) {
            connections.setRadius(dir, this.getSideConnectionRadius((IBlockReader)world, pos, dir));
        }
        return connections;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        int thisRadius = this.getRadius(state);
        VoxelShape shape = VoxelShapes.func_197880_a();
        int numConnections = 0;
        for (Direction dir : Direction.values()) {
            int connRadius = this.getSideConnectionRadius(worldIn, pos, dir);
            if (connRadius <= 0) continue;
            ++numConnections;
            double radius = (double)MathHelper.func_76125_a((int)connRadius, (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
            aabb = aabb.func_72317_d((double)dir.func_82601_c() * gap, (double)dir.func_96559_d() * gap, (double)dir.func_82599_e() * gap).func_72317_d(0.5, 0.5, 0.5);
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        if (state.func_177229_b(TRUNK_TYPE) == CactusThickness.BRANCH && numConnections == 1 && ((Direction)state.func_177229_b(ORIGIN)).func_176740_k().func_176722_c()) {
            double radius = (double)MathHelper.func_76125_a((int)this.getCactusRadius(CactusThickness.BRANCH), (int)1, (int)thisRadius) / 16.0;
            double gap = 0.5 - radius;
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g(radius);
            aabb = aabb.func_72317_d((double)Direction.UP.func_82601_c() * gap, (double)Direction.UP.func_96559_d() * gap, (double)Direction.UP.func_82599_e() * gap).func_72317_d(0.5, 0.5, 0.5);
            shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        }
        double min = 0.5 - (double)thisRadius / 16.0;
        double max = 0.5 + (double)thisRadius / 16.0;
        shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(min, min, min, max, max, max)), (IBooleanFunction)IBooleanFunction.field_223244_o_);
        return shape;
    }

    public int getRadiusForConnection(BlockState blockState, IBlockReader blockAccess, BlockPos pos, BranchBlock from, Direction side, int fromRadius) {
        return this.getRadius(blockState);
    }

    protected int getSideConnectionRadius(IBlockReader blockAccess, BlockPos pos, Direction side) {
        BlockPos deltaPos = pos.func_177972_a(side);
        BlockState otherState = CoordUtils.getStateSafe((IBlockReader)blockAccess, (BlockPos)deltaPos);
        BlockState state = CoordUtils.getStateSafe((IBlockReader)blockAccess, (BlockPos)pos);
        if (otherState == null || state == null) {
            return 0;
        }
        if (otherState.func_177230_c() == this && state.func_177230_c() == this && (otherState.func_177229_b(ORIGIN) == side.func_176734_d() || state.func_177229_b(ORIGIN) == side)) {
            return Math.min(this.getCactusRadius((CactusThickness)((Object)state.func_177229_b(TRUNK_TYPE))), this.getCactusRadius((CactusThickness)((Object)otherState.func_177229_b(TRUNK_TYPE))));
        }
        if (side == Direction.DOWN && state.func_177230_c() == this && state.func_177229_b(ORIGIN) == side && (otherState.func_177230_c() == this || otherState.func_177230_c() instanceof RootyBlock)) {
            return this.getCactusRadius((CactusThickness)((Object)state.func_177229_b(TRUNK_TYPE)));
        }
        return 0;
    }

    public MapSignal analyse(BlockState blockState, IWorld world, BlockPos pos, Direction fromDir, MapSignal signal) {
        if (signal.depth++ < 32) {
            BlockState state = world.func_180495_p(pos);
            signal.run(blockState, world, pos, fromDir);
            for (Direction dir : Direction.values()) {
                if (dir == fromDir) continue;
                BlockPos deltaPos = pos.func_177972_a(dir);
                BlockState deltaState = world.func_180495_p(deltaPos);
                if (deltaState.func_177230_c() == this && deltaState.func_177229_b(ORIGIN) == dir.func_176734_d()) {
                    signal = ((TreePart)deltaState.func_177230_c()).analyse(deltaState, world, deltaPos, dir.func_176734_d(), signal);
                } else if (state.func_177230_c() == this && state.func_177229_b(ORIGIN) == dir) {
                    signal = TreeHelper.getTreePart((BlockState)deltaState).analyse(deltaState, world, deltaPos, dir.func_176734_d(), signal);
                }
                if (!signal.foundRoot || signal.localRootDir != null || fromDir != null) continue;
                signal.localRootDir = dir;
            }
            signal.returnRun(blockState, world, pos, fromDir);
        } else {
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() instanceof BranchBlock) {
                BranchBlock branch = (BranchBlock)state.func_177230_c();
                branch.breakDeliberate(world, pos, DynamicTrees.DestroyMode.OVERFLOW);
            }
            signal.overflow = true;
        }
        --signal.depth;
        return signal;
    }

    public LootTable.Builder createBranchDrops() {
        return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)((IItemProvider)this.getPrimitiveLog().get())).func_212841_b_(MultiplyLogsCount.multiplyLogsCount()).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)SeedItemLootEntry.lootTableSeedItem().func_212841_b_(MultiplySticksCount.multiplySticksCount()).func_212841_b_((ILootFunction.IBuilder)ExplosionDecay.func_215863_b()))).func_216039_a(DTLootParameterSets.BRANCHES);
    }

    public static enum CactusThickness implements IStringSerializable
    {
        BRANCH("branch", 4),
        TRUNK("trunk", 5),
        CORE("core", 7);

        final String name;
        final int radius;

        private CactusThickness(String name, int radius) {
            this.name = name;
            this.radius = radius;
        }

        public int getRadius() {
            return this.radius;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

