/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.entity;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.mehvahdjukaar.dummmmmmy.common.Configs;
import net.mehvahdjukaar.dummmmmmy.common.NetworkHandler;
import net.mehvahdjukaar.dummmmmmy.entity.DummyNumberEntity;
import net.mehvahdjukaar.dummmmmmy.setup.Registry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BannerItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeEntity;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;

public class TargetDummyEntity
extends MobEntity
implements IEntityAdditionalSpawnData,
IForgeEntity {
    public float prevLimbSwing = 0.0f;
    public float prevShakeAmount = 0.0f;
    public float shakeAmount = 0.0f;
    public float lastDamage;
    public int lastDamageTick;
    public int firstDamageTick;
    public float damageTaken;
    public boolean critical = false;
    public MobAttribute mobType = MobAttribute.UNDEFINED;
    private final List<ServerPlayerEntity> currentlyAttacking = new ArrayList<ServerPlayerEntity>();
    private int damageNumberPos = 0;
    public boolean sheared = false;
    private final NonNullList<ItemStack> lastArmorItem = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);

    public TargetDummyEntity(FMLPlayMessages.SpawnEntity packet, World world) {
        this((EntityType<TargetDummyEntity>)((EntityType)Registry.TARGET_DUMMY.get()), world);
    }

    public TargetDummyEntity(EntityType<TargetDummyEntity> type, World world) {
        super(type, world);
    }

    public TargetDummyEntity(World world) {
        this((EntityType<TargetDummyEntity>)((EntityType)Registry.TARGET_DUMMY.get()), world);
        this.field_70728_aV = 0;
        Arrays.fill(this.field_184655_bs, 1.1f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeBoolean(this.sheared);
        this.updateOnLoadServer();
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.sheared = additionalData.readBoolean();
        this.updateOnLoadClient();
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74768_a("Type", this.mobType.ordinal());
        tag.func_74768_a("NumberPos", this.damageNumberPos);
        tag.func_74757_a("Sheared", this.sheared);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.mobType = MobAttribute.values()[tag.func_74762_e("Type")];
        this.damageNumberPos = tag.func_74762_e("NumberPos");
        this.sheared = tag.func_74767_n("Sheared");
    }

    public void updateOnLoadClient() {
        float r;
        this.field_70758_at = this.field_70759_as = (r = this.field_70177_z);
        this.field_70126_B = r;
        this.field_70760_ar = this.field_70761_aq = r;
    }

    public void updateOnLoadServer() {
        this.applyEquipmentModifiers();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        boolean invchanged = false;
        if (!player.func_175149_v() && player.field_71075_bZ.field_75099_e) {
            ItemStack itemstack = player.func_184586_b(hand);
            EquipmentSlotType equipmentslottype = TargetDummyEntity.func_184640_d((ItemStack)itemstack);
            Item item = itemstack.func_77973_b();
            if (item instanceof BannerItem || this.isPumpkin(item) || item.canEquip(itemstack, EquipmentSlotType.HEAD, (Entity)this)) {
                equipmentslottype = EquipmentSlotType.HEAD;
            }
            if (itemstack.func_190926_b() && hand == Hand.MAIN_HAND) {
                equipmentslottype = this.getClickedSlot(vec);
                if (this.func_190630_a(equipmentslottype)) {
                    if (player.field_70170_p.field_72995_K) {
                        return ActionResultType.CONSUME;
                    }
                    this.unequipArmor(player, equipmentslottype, itemstack, hand);
                    invchanged = true;
                }
            } else if (equipmentslottype.func_188453_a() == EquipmentSlotType.Group.ARMOR) {
                if (player.field_70170_p.field_72995_K) {
                    return ActionResultType.CONSUME;
                }
                this.equipArmor(player, equipmentslottype, itemstack, hand);
                invchanged = true;
            } else if (item instanceof ShearsItem && !this.sheared) {
                if (player.field_70170_p.field_72995_K) {
                    return ActionResultType.CONSUME;
                }
                this.sheared = true;
                if (!this.field_70170_p.field_72995_K) {
                    NetworkHandler.sendToAllTracking((Entity)this, (ServerWorld)this.field_70170_p, new NetworkHandler.PacketChangeSkin(this.func_145782_y(), true));
                }
                return ActionResultType.SUCCESS;
            }
            if (invchanged) {
                this.setLastArmorItem(equipmentslottype, itemstack);
                if (!this.field_70170_p.field_72995_K) {
                    NetworkHandler.sendToAllTracking((Entity)this, (ServerWorld)this.field_70170_p, new NetworkHandler.PacketSyncEquip(this.func_145782_y(), equipmentslottype.func_188454_b(), this.func_184582_a(equipmentslottype)));
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void unequipArmor(PlayerEntity player, EquipmentSlotType slot, ItemStack stack, Hand hand) {
        ItemStack itemstack = this.func_184582_a(slot);
        ItemStack itemstack2 = itemstack.func_77946_l();
        player.func_184611_a(hand, itemstack2);
        this.func_184201_a(slot, stack);
        this.func_233645_dx_().func_233785_a_(itemstack2.func_111283_C(slot));
        if (slot == EquipmentSlotType.HEAD) {
            this.mobType = MobAttribute.UNDEFINED;
        }
    }

    private void equipArmor(PlayerEntity player, EquipmentSlotType slot, ItemStack stack, Hand hand) {
        ItemStack currentItem = this.func_184582_a(slot);
        ItemStack newItem = stack.func_77946_l();
        newItem.func_190920_e(1);
        player.func_184611_a(hand, DrinkHelper.func_241445_a_((ItemStack)stack.func_77946_l(), (PlayerEntity)player, (ItemStack)currentItem, (boolean)player.func_184812_l_()));
        this.func_184606_a_(newItem);
        this.func_184201_a(slot, newItem);
        this.func_233645_dx_().func_233793_b_(newItem.func_111283_C(slot));
        if (slot == EquipmentSlotType.HEAD) {
            this.mobType = this.isUndeadSkull(newItem) ? MobAttribute.UNDEAD : (newItem.func_77973_b() == Items.field_203179_ao ? MobAttribute.WATER : (newItem.func_77973_b() == Items.field_196151_dA ? MobAttribute.ARTHROPOD : (ItemStack.func_77989_b((ItemStack)newItem, (ItemStack)Raid.func_221312_H()) ? MobAttribute.ILLAGER : (this.isPumpkin(newItem.func_77973_b()) ? MobAttribute.SCARECROW : MobAttribute.UNDEFINED))));
        }
    }

    private boolean isPumpkin(Item item) {
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).func_179223_d();
            String name = item.getRegistryName().func_110623_a();
            return block instanceof CarvedPumpkinBlock || name.contains("pumpkin") || name.contains("jack_o");
        }
        return false;
    }

    private boolean isUndeadSkull(ItemStack itemstack) {
        Item i = itemstack.func_77973_b();
        return i == Items.field_196183_dw || i == Items.field_196182_dv || i == Items.field_196186_dz;
    }

    public boolean isScarecrow() {
        return this.mobType == MobAttribute.SCARECROW;
    }

    private EquipmentSlotType getClickedSlot(Vector3d p_190772_1_) {
        EquipmentSlotType equipmentslottype = EquipmentSlotType.MAINHAND;
        double d0 = p_190772_1_.field_72448_b;
        EquipmentSlotType equipmentslottype1 = EquipmentSlotType.FEET;
        if (d0 >= 0.1 && d0 < 0.55 && this.func_190630_a(equipmentslottype1)) {
            equipmentslottype = EquipmentSlotType.FEET;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.func_190630_a(EquipmentSlotType.CHEST)) {
            equipmentslottype = EquipmentSlotType.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2000000000000002 && this.func_190630_a(EquipmentSlotType.LEGS)) {
            equipmentslottype = EquipmentSlotType.LEGS;
        } else if (d0 >= 1.6 && this.func_190630_a(EquipmentSlotType.HEAD)) {
            equipmentslottype = EquipmentSlotType.HEAD;
        }
        return equipmentslottype;
    }

    private void setLastArmorItem(EquipmentSlotType type, ItemStack stack) {
        this.lastArmorItem.set(type.func_188454_b(), (Object)stack);
    }

    public void applyEquipmentModifiers() {
        if (!this.field_70170_p.field_72995_K) {
            for (EquipmentSlotType equipmentslottype : EquipmentSlotType.values()) {
                if (equipmentslottype.func_188453_a() != EquipmentSlotType.Group.ARMOR) continue;
                ItemStack itemstack = (ItemStack)this.lastArmorItem.get(equipmentslottype.func_188454_b());
                ItemStack itemstack1 = this.func_184582_a(equipmentslottype);
                if (ItemStack.func_77989_b((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                if (!itemstack1.equals(itemstack, true)) {
                    MinecraftForge.EVENT_BUS.post((Event)new LivingEquipmentChangeEvent((LivingEntity)this, equipmentslottype, itemstack, itemstack1));
                }
                if (!itemstack.func_190926_b()) {
                    this.func_233645_dx_().func_233785_a_(itemstack.func_111283_C(equipmentslottype));
                }
                if (itemstack1.func_190926_b()) continue;
                this.func_233645_dx_().func_233793_b_(itemstack1.func_111283_C(equipmentslottype));
            }
        }
    }

    public void func_213337_cE() {
        for (EquipmentSlotType slot : EquipmentSlotType.values()) {
            ItemStack armor;
            if (slot.func_188453_a() != EquipmentSlotType.Group.ARMOR || (armor = this.func_184582_a(slot)).func_190926_b()) continue;
            this.func_70099_a(armor, 1.0f);
        }
    }

    public void dismantle(boolean drops) {
        if (!this.field_70170_p.field_72995_K) {
            if (drops) {
                this.func_213337_cE();
                this.func_199702_a((IItemProvider)Registry.DUMMY_ITEM.get(), 1);
            }
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184615_bR(), this.func_184176_by(), 1.0f, 1.0f);
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
            this.func_70106_y();
        }
    }

    public void func_174812_G() {
        this.dismantle(true);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Registry.DUMMY_ITEM.get());
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (!ForgeHooks.onLivingAttack((LivingEntity)this, (DamageSource)source, (float)damage)) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source == DamageSource.field_76380_i) {
            this.func_70106_y();
            return true;
        }
        if (source == DamageSource.field_76369_e || source == DamageSource.field_76368_d) {
            return false;
        }
        if (source.func_76364_f() instanceof WitherEntity || source.func_76346_g() instanceof WitherEntity) {
            this.dismantle(true);
            return true;
        }
        if (source.func_76347_k() && this.func_70644_a(Effects.field_76426_n)) {
            return false;
        }
        if (!(source != DamageSource.field_82728_o && source != DamageSource.field_82729_p || this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b())) {
            damage *= 0.75f;
        }
        if (source.field_76373_n.equals("player") || source.func_76346_g() instanceof PlayerEntity) {
            ServerPlayerEntity sp;
            PlayerEntity player = (PlayerEntity)source.func_76346_g();
            if (!this.field_70170_p.field_72995_K && !this.currentlyAttacking.contains(sp = (ServerPlayerEntity)player)) {
                this.currentlyAttacking.add(sp);
            }
            if (player.func_225608_bj_() && player.func_184614_ca().func_190926_b()) {
                this.dismantle(!player.func_184812_l_());
                return false;
            }
        }
        if ((float)this.field_70172_ad > 10.0f) {
            if (damage <= this.lastDamage) {
                return false;
            }
            float ld = this.lastDamage;
            this.lastDamage = damage;
            damage -= ld;
        } else {
            this.func_184581_c(source);
            this.lastDamage = damage;
            this.field_70172_ad = 20;
            this.field_70738_aO = 10;
        }
        this.field_70737_aN = 0;
        if (!this.field_70170_p.field_72995_K && (damage = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)damage)) > 0.0f) {
            damage = this.func_70655_b(source, damage);
            float f1 = damage = this.func_70672_c(source, damage);
            damage = Math.max(damage - this.func_110139_bj(), 0.0f);
            this.func_110149_m(this.func_110139_bj() - (f1 - damage));
        }
        if (this.lastDamageTick == this.field_70173_aa) {
            this.lastDamage += damage;
            this.field_184619_aG += damage;
            this.field_184619_aG = Math.min(this.field_184619_aG, 60.0f);
        } else {
            this.field_184619_aG = Math.min(damage, 60.0f);
            this.lastDamage = damage;
            this.lastDamageTick = this.field_70173_aa;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.showDamageDealt(damage, this.getDamageType(source));
            this.critical = false;
        }
        return true;
    }

    private void showDamageDealt(float damage, DamageType type) {
        NetworkHandler.sendToAllTracking((Entity)this, (ServerWorld)this.field_70170_p, new NetworkHandler.PacketDamageNumber(this.func_145782_y(), damage, this.field_184619_aG));
        DummyNumberEntity number = new DummyNumberEntity(damage, type, this.damageNumberPos++, this.field_70170_p);
        number.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_(), 0.0f, 0.0f);
        this.field_70170_p.func_217376_c((Entity)number);
        this.damageTaken += damage;
        if (this.firstDamageTick == 0) {
            this.firstDamageTick = this.field_70173_aa;
        }
    }

    public void func_70071_h_() {
        float trueDamage;
        if (this.lastDamageTick + 1 == this.field_70173_aa && !this.field_70170_p.field_72995_K && (trueDamage = this.func_110138_aP() - this.func_110143_aJ()) > 0.0f) {
            this.func_70691_i(trueDamage);
            this.showDamageDealt(trueDamage, DamageType.TRUE);
        }
        BlockPos onPos = this.func_226268_ag_();
        if (this.field_70170_p != null && this.field_70170_p.func_82737_E() % 20L == 0L && !this.field_70170_p.field_72995_K && this.field_70170_p.func_175623_d(onPos)) {
            this.dismantle(true);
            return;
        }
        this.func_189654_d(true);
        this.field_70170_p.func_180495_p(onPos).func_177230_c().func_176199_a(this.field_70170_p, onPos, (Entity)this);
        this.func_70030_z();
        this.field_70170_p.func_217381_Z().func_76320_a("travel");
        this.func_213352_e(new Vector3d((double)this.field_70702_br, (double)this.field_70701_bs, (double)this.field_191988_bg));
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("push");
        this.func_85033_bc();
        this.field_70170_p.func_217381_Z().func_76319_b();
        this.field_70170_p.func_217381_Z().func_76320_a("rest");
        try {
            this.func_145775_I();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
        if (this.field_70170_p.field_72995_K) {
            this.field_70737_aN = 0;
            this.prevShakeAmount = this.shakeAmount;
            this.prevLimbSwing = this.field_184619_aG;
            if (this.field_184619_aG > 0.0f) {
                this.shakeAmount += 1.0f;
                this.field_184619_aG -= 0.8f;
                if (this.field_184619_aG <= 0.0f) {
                    this.shakeAmount = 0.0f;
                    this.field_184619_aG = 0.0f;
                }
            }
        } else {
            this.func_70052_a(6, this.func_225510_bt_());
            if (!this.field_184238_ar) {
                boolean flag = this.func_70644_a(Effects.field_188423_x);
                if (this.func_70083_f(6) != flag) {
                    this.func_70052_a(6, flag);
                }
            }
            if (this.damageTaken > 0.0f) {
                boolean flag;
                boolean isdynamic = Configs.cached.DYNAMIC_DPS;
                boolean bl = isdynamic ? this.field_70173_aa == this.lastDamageTick + 1 : (flag = this.field_70173_aa - this.lastDamageTick > 60);
                if (flag && this.firstDamageTick < this.lastDamageTick) {
                    float seconds = (float)(this.lastDamageTick - this.firstDamageTick) / 20.0f + 1.0f;
                    float dps = this.damageTaken / seconds;
                    for (ServerPlayerEntity p : this.currentlyAttacking) {
                        if (!(p.func_70032_d((Entity)this) < 64.0f)) continue;
                        p.func_146105_b((ITextComponent)new TranslationTextComponent("message.dummmmmmy.dps", new Object[]{new DecimalFormat("#.##").format(dps)}), true);
                    }
                }
                if (this.field_70173_aa - this.lastDamageTick > 60) {
                    this.currentlyAttacking.clear();
                    this.damageTaken = 0.0f;
                    this.firstDamageTick = 0;
                }
            }
        }
    }

    public void func_213317_d(Vector3d motionIn) {
    }

    public void func_233627_a_(float strength, double ratioX, double ratioZ) {
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return super.func_70067_L();
    }

    public boolean func_225503_b_(float l, float d) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void func_189654_d(boolean ignored) {
        super.func_189654_d(true);
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public SoundEvent func_184601_bQ(DamageSource ds) {
        return SoundEvents.field_187707_l;
    }

    public SoundEvent func_184615_bR() {
        return SoundEvents.field_187701_j;
    }

    public CreatureAttribute func_70668_bt() {
        return this.mobType.get();
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233819_b_, 16.0).func_233815_a_(Attributes.field_233821_d_, 0.0).func_233815_a_(Attributes.field_233818_a_, 40.0).func_233815_a_(Attributes.field_233826_i_, 0.0).func_233815_a_(Attributes.field_233823_f_, 0.0).func_233815_a_(Attributes.field_233822_e_, 0.0);
    }

    public DamageType getDamageType(DamageSource source) {
        if (this.critical) {
            return DamageType.CRIT;
        }
        if (source == DamageSource.field_188407_q) {
            return DamageType.DRAGON;
        }
        if (source == DamageSource.field_82727_n) {
            return DamageType.WITHER;
        }
        if (source.field_76373_n.equals("explosion") || source.field_76373_n.equals("explosion.player") || source.func_94541_c()) {
            return DamageType.EXPLOSION;
        }
        if (source.field_76373_n.equals("indirectMagic")) {
            return DamageType.IND_MAGIC;
        }
        if (source.field_76373_n.equals("trident")) {
            return DamageType.TRIDENT;
        }
        if (source == DamageSource.field_190095_e || source == DamageSource.field_76371_c || source == DamageSource.field_76370_b || source == DamageSource.field_76372_a || source.func_76347_k()) {
            return DamageType.FIRE;
        }
        if (source == DamageSource.field_76376_m || source.func_82725_o()) {
            return DamageType.MAGIC;
        }
        if (source == DamageSource.field_180137_b) {
            return DamageType.LIGHTNING;
        }
        if (source == DamageSource.field_76367_g || source == DamageSource.field_220302_v) {
            return DamageType.CACTUS;
        }
        return DamageType.GENERIC;
    }

    public static enum DamageType {
        GENERIC,
        CRIT,
        DRAGON,
        WITHER,
        EXPLOSION,
        MAGIC,
        IND_MAGIC,
        TRIDENT,
        FIRE,
        LIGHTNING,
        CACTUS,
        TRUE;


        public int getColor() {
            switch (this) {
                case CRIT: {
                    return Configs.cached.DAMAGE_CRIT;
                }
                case FIRE: {
                    return Configs.cached.DAMAGE_FIRE;
                }
                case MAGIC: {
                    return Configs.cached.DAMAGE_MAGIC;
                }
                case CACTUS: {
                    return Configs.cached.DAMAGE_CACTUS;
                }
                case DRAGON: {
                    return Configs.cached.DAMAGE_DRAGON;
                }
                case WITHER: {
                    return Configs.cached.DAMAGE_WITHER;
                }
                default: {
                    return Configs.cached.DAMAGE_GENERIC;
                }
                case TRIDENT: {
                    return Configs.cached.DAMAGE_TRIDENT;
                }
                case EXPLOSION: {
                    return Configs.cached.DAMAGE_EXPLOSION;
                }
                case IND_MAGIC: {
                    return Configs.cached.DAMAGE_IND_MAGIC;
                }
                case LIGHTNING: {
                    return Configs.cached.DAMAGE_LIGHTNING;
                }
                case TRUE: 
            }
            return Configs.cached.DAMAGE_TRUE;
        }
    }

    private static enum MobAttribute {
        UNDEFINED,
        UNDEAD,
        WATER,
        ILLAGER,
        ARTHROPOD,
        SCARECROW;


        public CreatureAttribute get() {
            switch (this) {
                default: {
                    return CreatureAttribute.field_223222_a_;
                }
                case UNDEAD: {
                    return CreatureAttribute.field_223223_b_;
                }
                case WATER: {
                    return CreatureAttribute.field_203100_e;
                }
                case ILLAGER: {
                    return CreatureAttribute.field_223225_d_;
                }
                case ARTHROPOD: 
            }
            return CreatureAttribute.field_223224_c_;
        }
    }
}

