/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.dummmmmmy.entity.TargetDummyEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    public static SimpleChannel INSTANCE;
    private static int ID;
    private static final String PROTOCOL_VERSION = "1";

    public static int nextID() {
        return ID++;
    }

    public static void registerMessages() {
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("dummmmmmy", "dummychannel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        INSTANCE.registerMessage(NetworkHandler.nextID(), PacketDamageNumber.class, PacketDamageNumber::toBytes, PacketDamageNumber::new, PacketDamageNumber::handle);
        INSTANCE.registerMessage(NetworkHandler.nextID(), PacketSyncEquip.class, PacketSyncEquip::toBytes, PacketSyncEquip::new, PacketSyncEquip::handle);
        INSTANCE.registerMessage(NetworkHandler.nextID(), PacketChangeSkin.class, PacketChangeSkin::toBytes, PacketChangeSkin::new, PacketChangeSkin::handle);
    }

    public static void sendToAllTracking(Entity entity, ServerWorld world, Message message) {
        world.func_72863_F().func_217218_b(entity, INSTANCE.toVanillaPacket((Object)message, NetworkDirection.PLAY_TO_CLIENT));
    }

    static {
        ID = 0;
    }

    public static class PacketChangeSkin
    implements Message {
        private final int entityID;
        private final boolean skin;

        public PacketChangeSkin(PacketBuffer buf) {
            this.entityID = buf.readInt();
            this.skin = buf.readBoolean();
        }

        public PacketChangeSkin(int entityId, boolean skin) {
            this.entityID = entityId;
            this.skin = skin;
        }

        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.entityID);
            buf.writeBoolean(this.skin);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
                if (entity instanceof TargetDummyEntity) {
                    TargetDummyEntity dummy = (TargetDummyEntity)entity;
                    dummy.sheared = this.skin;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PacketSyncEquip
    implements Message {
        private final int entityID;
        private final int slotId;
        private final ItemStack itemstack;

        public PacketSyncEquip(PacketBuffer buf) {
            this.entityID = buf.readInt();
            this.slotId = buf.readInt();
            this.itemstack = buf.func_150791_c();
        }

        public PacketSyncEquip(int entityId, int slotId, @Nonnull ItemStack itemstack) {
            this.entityID = entityId;
            this.slotId = slotId;
            this.itemstack = itemstack.func_77946_l();
        }

        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.entityID);
            buf.writeInt(this.slotId);
            buf.func_150788_a(this.itemstack);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
                if (entity instanceof TargetDummyEntity) {
                    TargetDummyEntity dummy = (TargetDummyEntity)entity;
                    dummy.func_184201_a(EquipmentSlotType.func_220318_a((EquipmentSlotType.Group)EquipmentSlotType.Group.ARMOR, (int)this.slotId), this.itemstack);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    public static class PacketDamageNumber
    implements Message {
        private final int entityID;
        private final float damage;
        private final float shake;

        public PacketDamageNumber(PacketBuffer buf) {
            this.entityID = buf.readInt();
            this.damage = buf.readFloat();
            this.shake = buf.readFloat();
        }

        public PacketDamageNumber(int id, float damage, float shakeAmount) {
            this.entityID = id;
            this.damage = damage;
            this.shake = shakeAmount;
        }

        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.entityID);
            buf.writeFloat(this.damage);
            buf.writeFloat(this.shake);
        }

        public void handle(Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(this.entityID);
                if (entity instanceof TargetDummyEntity) {
                    TargetDummyEntity dummy = (TargetDummyEntity)entity;
                    dummy.field_184619_aG = this.shake;
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }

    private static interface Message {
    }
}

