/*
 * Decompiled with CFR 0.152.
 */
package kdp.instantunify;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="instantunify")
public class InstantUnify {
    public static final String MOD_ID = "instantunify";
    public static final Logger LOG = LogManager.getLogger(InstantUnify.class);
    private ForgeConfigSpec.ConfigValue<List<? extends String>> blacklist;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> whitelist;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> preferredMods;
    private ForgeConfigSpec.ConfigValue<List<? extends String>> blacklistedMods;
    private ForgeConfigSpec.BooleanValue drop;
    private ForgeConfigSpec.BooleanValue harvest;
    private ForgeConfigSpec.BooleanValue gui;
    private ForgeConfigSpec.BooleanValue second;
    private ForgeConfigSpec.BooleanValue death;
    private ForgeConfigSpec.BooleanValue change;
    private ForgeConfigSpec.EnumValue<ListMode> listMode;
    private ForgeConfigSpec.ConfigValue<List<? extends List<? extends String>>> alts;
    private Map<String, List<String>> alternatives;
    private Cache<Item, ResourceLocation[]> tagNameCache = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();

    public InstantUnify() {
        Pair pair = new ForgeConfigSpec.Builder().configure(b -> {
            this.blacklist = b.comment("Tag names that shouldn't be unified (supports regex)").defineList("blacklist", Arrays.asList("minecraft:.+", "forge:glass.+"), s -> s instanceof String);
            this.whitelist = b.comment("Tag names that should be unified (supports regex)").defineList("whitelist", Arrays.asList("forge:ores\\/.+", "forge:ingots\\/.+", "forge:nuggets\\/.+", "forge:storage_blocks\\/.+", "forge:gems\\/.+", "forge:dusts\\/.+", "forge:gears\\/.+", "forge:plates\\/.+", "forge:rods\\/.+"), s -> s instanceof String);
            this.listMode = b.defineEnum("listMode", (Enum)ListMode.USE_BOTH_LISTS);
            this.preferredMods = b.comment("Preferred Mods").defineList("preferredMods", Arrays.asList("minecraft", "immersiveengineering"), s -> s instanceof String);
            this.blacklistedMods = b.comment("Blacklisted Mods").defineList("blacklistMods", Arrays.asList("astralsorcery"), s -> s instanceof String);
            this.alts = b.comment("Tag names that should be unified even if they are different").defineList("alternatives", Arrays.asList(Arrays.asList("aluminum", "aluminium", "bauxite")), o -> o instanceof List && (((List)o).isEmpty() || ((List)o).get(0) instanceof String));
            b.push("Unify event");
            this.drop = b.comment("Unify when items drop").define("drop", true);
            this.harvest = b.comment("Unify when blocks are harvested").define("harvest", true);
            this.death = b.comment("Unify drops when entities die").define("death", true);
            this.second = b.comment("Unify every second items in player's inventory").define("second", false);
            this.change = b.comment("Unify items in player's inventory when they change").define("change", true);
            b.pop();
            return null;
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (ForgeConfigSpec)pair.getValue());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void spawn(EntityJoinWorldEvent event) {
        if (((Boolean)this.drop.get()).booleanValue() && event.getEntity() instanceof ItemEntity && !event.getWorld().field_72995_K) {
            this.replace(((ItemEntity)event.getEntity()).func_92059_d()).ifPresent(s -> ((ItemEntity)event.getEntity()).func_92058_a(s));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void death(LivingDropsEvent event) {
        if (((Boolean)this.death.get()).booleanValue()) {
            event.getDrops().forEach(e -> this.replace(e.func_92059_d()).ifPresent(arg_0 -> ((ItemEntity)e).func_92058_a(arg_0)));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player;
        if (((Boolean)this.second.get()).booleanValue() && event.phase == TickEvent.Phase.END && !event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 20L == 18L && this.replaceInventory(player = event.player) && player.field_71070_bA != null) {
            player.field_71070_bA.func_75142_b();
        }
    }

    private boolean replaceInventory(PlayerEntity player) {
        boolean changed = false;
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack slot = player.field_71071_by.func_70301_a(i);
            Optional<ItemStack> op = this.replace(slot);
            if (!op.isPresent()) continue;
            player.field_71071_by.func_70299_a(i, op.get());
            changed = true;
        }
        return changed;
    }

    public void open(PlayerContainerEvent event) {
        PlayerEntity player;
        if (((Boolean)this.gui.get()).booleanValue() && !event.getPlayer().field_70170_p.field_72995_K && this.replaceInventory(player = event.getPlayer()) && player.field_71070_bA != null) {
            player.field_71070_bA.func_75142_b();
        }
    }

    @SubscribeEvent
    public void login(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity && event.getPlayer().field_71070_bA instanceof PlayerContainer) {
            event.getPlayer().field_71070_bA.func_75132_a(new IContainerListener(){

                public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
                }

                public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
                    if (((Boolean)InstantUnify.this.change.get()).booleanValue()) {
                        InstantUnify.this.replace(((Slot)containerToSend.field_75151_b.get(slotInd)).func_75211_c()).ifPresent(s -> ((Slot)containerToSend.field_75151_b.get(slotInd)).func_75215_d(s));
                    }
                }

                public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
                }
            });
        }
    }

    private Optional<ItemStack> replace(ItemStack orig) {
        if (orig.func_190926_b() || orig.func_77978_p() != null && !orig.func_77978_p().isEmpty() || ((List)this.blacklistedMods.get()).contains(orig.func_77973_b().getRegistryName().func_110624_b())) {
            return Optional.empty();
        }
        Object[] tagNames = this.tagNames(orig);
        if (tagNames.length == 0) {
            return Optional.empty();
        }
        List itemLists = Arrays.stream(tagNames).map(rl -> ItemTags.func_199903_a().func_199910_a(rl)).filter(Objects::nonNull).map(tag -> tag.func_230236_b_().stream().sorted((i1, i2) -> {
            int index1 = ((List)this.preferredMods.get()).indexOf(i1.getRegistryName().func_110624_b());
            int index2 = ((List)this.preferredMods.get()).indexOf(i2.getRegistryName().func_110624_b());
            return Integer.compare(index1 == -1 ? 999 : index1, index2 == -1 ? 999 : index2);
        }).map(i -> new ItemStack((IItemProvider)i, orig.func_190916_E())).collect(Collectors.toList())).filter(l -> !l.isEmpty()).collect(Collectors.toList());
        for (List items : itemLists) {
            for (ItemStack item : items) {
                if (!Arrays.equals(tagNames, this.tagNames(item))) continue;
                return Optional.of(item);
            }
        }
        return Optional.empty();
    }

    private ResourceLocation[] tagNames(ItemStack s) {
        try {
            return (ResourceLocation[])this.tagNameCache.get((Object)s.func_77973_b(), () -> {
                Set unmodifiableNames = s.func_77973_b().getTags();
                HashSet<ResourceLocation> names = new HashSet<ResourceLocation>(unmodifiableNames);
                if (this.alternatives == null) {
                    this.alternatives = new HashMap<String, List<String>>();
                    for (List lis : (List)this.alts.get()) {
                        for (String n : lis) {
                            ArrayList copy = new ArrayList(lis);
                            Validate.isTrue((!n.contains(":") ? 1 : 0) != 0, (String)": is not allowed in alternative tag", (Object[])new Object[0]);
                            copy.remove(n);
                            if (copy.isEmpty()) continue;
                            this.alternatives.put(n, copy);
                        }
                    }
                }
                for (ResourceLocation name : unmodifiableNames) {
                    for (Map.Entry<String, List<String>> e : this.alternatives.entrySet()) {
                        String key = e.getKey();
                        if (!name.func_110623_a().contains(key)) continue;
                        List<String> val = e.getValue();
                        for (String alt : val) {
                            names.add(new ResourceLocation(name.func_110624_b(), name.func_110623_a().replace(key, alt)));
                        }
                    }
                }
                return (ResourceLocation[])names.stream().filter(r -> (this.listMode.get() != ListMode.USE_WHITELIST && this.listMode.get() != ListMode.USE_BOTH_LISTS || ((List)this.whitelist.get()).stream().anyMatch(ss -> Pattern.matches(ss, r.toString()))) && (this.listMode.get() != ListMode.USE_BLACKLIST && this.listMode.get() != ListMode.USE_BOTH_LISTS || ((List)this.blacklist.get()).stream().noneMatch(ss -> Pattern.matches(ss, r.toString())))).sorted().toArray(ResourceLocation[]::new);
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private static enum ListMode {
        USE_WHITELIST,
        USE_BLACKLIST,
        USE_BOTH_LISTS,
        USE_NO_LIST;

    }
}

