/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.modules;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerSelfLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private LightConfig config;
    private final HashMap<PlayerEntity, PlayerLightSourceContainer> playerLightsMap = new HashMap();

    public PlayerSelfLightSource() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverStartEvent(FMLServerAboutToStartEvent event) {
        LightConfig defaultConfig = new LightConfig();
        String torchString = ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Blocks.field_150478_aa));
        defaultConfig.getItemsList().add(torchString);
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Blocks.field_150426_aN)));
        defaultConfig.getNotWaterProofList().add(torchString);
        MinecraftServer server = event.getServer();
        File configFile = new File(server.func_71209_f(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights_selflight.cfg");
        try {
            this.config = GsonConfig.loadConfigWithDefault(LightConfig.class, configFile, defaultConfig);
            if (this.config == null) {
                throw new UnsupportedOperationException("PlayerSelfLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(this.config.getItemsList(), LOGGER);
            notWaterProofItems = new ItemConfigHelper(this.config.getNotWaterProofList(), LOGGER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        if (event.player.func_70089_S()) {
            PlayerLightSourceContainer playerLightSourceContainer = this.playerLightsMap.get(event.player);
            if (playerLightSourceContainer == null) {
                LOGGER.trace("built new PlayerLightSourceContainer for player {}", (Object)event.player);
                playerLightSourceContainer = new PlayerLightSourceContainer(event.player);
                this.playerLightsMap.put(event.player, playerLightSourceContainer);
            }
            int prevLight = playerLightSourceContainer.lightLevel;
            ItemStack item = ItemStack.field_190927_a;
            LOGGER.trace("checking for light from main hand item {}", (Object)event.player.func_184586_b(Hand.MAIN_HAND));
            int main = this.getLightFromItemStack(event.player.func_184586_b(Hand.MAIN_HAND));
            int off = this.getLightFromItemStack(event.player.func_184586_b(Hand.OFF_HAND));
            if (main >= off && main > 0) {
                item = event.player.func_184586_b(Hand.MAIN_HAND);
                playerLightSourceContainer.lightLevel = main;
            } else if (off >= main && off > 0) {
                item = event.player.func_184586_b(Hand.OFF_HAND);
                playerLightSourceContainer.lightLevel = off;
            } else {
                playerLightSourceContainer.lightLevel = 0;
            }
            LOGGER.trace("Self light tick, main:{}, off:{}, light:{}, chosen itemstack:{}", (Object)main, (Object)off, (Object)playerLightSourceContainer.lightLevel, (Object)item);
            for (ItemStack armor : event.player.field_71071_by.field_70460_b) {
                playerLightSourceContainer.lightLevel = Math.max(playerLightSourceContainer.lightLevel, this.getLightFromItemStack(armor));
            }
            if (prevLight != 0 && playerLightSourceContainer.lightLevel != prevLight) {
                playerLightSourceContainer.lightLevel = 0;
            } else if (event.player.func_70027_ad()) {
                playerLightSourceContainer.lightLevel = 15;
            } else if (this.checkPlayerWater(event.player) && notWaterProofItems.contains(item)) {
                playerLightSourceContainer.lightLevel = 0;
                LOGGER.trace("Self light tick, water blocked light!");
                for (ItemStack armor : event.player.field_71071_by.field_70460_b) {
                    if (notWaterProofItems.contains(armor)) continue;
                    playerLightSourceContainer.lightLevel = Math.max(playerLightSourceContainer.lightLevel, this.getLightFromItemStack(armor));
                }
            }
            if (!playerLightSourceContainer.enabled && playerLightSourceContainer.lightLevel > 0) {
                this.enableLight(playerLightSourceContainer);
            } else if (playerLightSourceContainer.enabled && playerLightSourceContainer.lightLevel < 1) {
                this.disableLight(playerLightSourceContainer);
            }
        } else {
            PlayerLightSourceContainer playerLightSourceContainer = this.playerLightsMap.get(event.player);
            if (playerLightSourceContainer != null) {
                this.disableLight(playerLightSourceContainer);
                this.playerLightsMap.remove(playerLightSourceContainer.thePlayer);
            }
        }
    }

    private boolean checkPlayerWater(PlayerEntity thePlayer) {
        if (thePlayer.func_70090_H()) {
            int x = MathHelper.func_76128_c((double)(thePlayer.func_226277_ct_() + 0.5));
            int y = MathHelper.func_76128_c((double)(thePlayer.func_226278_cu_() + (double)thePlayer.func_70047_e()));
            int z = MathHelper.func_76128_c((double)(thePlayer.func_226281_cx_() + 0.5));
            BlockState is = thePlayer.field_70170_p.func_180495_p(new BlockPos(x, y, z));
            return is.func_185904_a().func_76224_d();
        }
        return false;
    }

    private int getLightFromItemStack(ItemStack stack) {
        if (itemsMap.contains(stack)) {
            return 15;
        }
        return 0;
    }

    private void enableLight(PlayerLightSourceContainer container) {
        DynamicLights.addLightSource(container);
        container.enabled = true;
    }

    private void disableLight(PlayerLightSourceContainer container) {
        DynamicLights.removeLightSource(container);
        container.enabled = false;
    }

    class PlayerLightSourceContainer
    implements IDynamicLightSource {
        int lightLevel;
        boolean enabled;
        PlayerEntity thePlayer;

        PlayerLightSourceContainer(PlayerEntity player) {
            this.thePlayer = player;
            this.lightLevel = 0;
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.thePlayer;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }
}

