/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.modules;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DroppedItemsLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private static final HashMap<ItemEntity, EntityItemAdapter> trackedItemMap;
    private LightConfig config;

    public DroppedItemsLightSource() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverStartEvent(FMLServerAboutToStartEvent event) {
        LightConfig defaultConfig = new LightConfig();
        String torchString = ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Blocks.field_150478_aa));
        defaultConfig.getItemsList().add(torchString);
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((IItemProvider)Blocks.field_150426_aN)));
        defaultConfig.getNotWaterProofList().add(torchString);
        MinecraftServer server = event.getServer();
        File configFile = new File(server.func_71209_f(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights_droppeditems.cfg");
        try {
            this.config = GsonConfig.loadConfigWithDefault(LightConfig.class, configFile, defaultConfig);
            if (this.config == null) {
                throw new UnsupportedOperationException("DroppedItemsLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(this.config.getItemsList(), LOGGER);
            notWaterProofItems = new ItemConfigHelper(this.config.getNotWaterProofList(), LOGGER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void entityJoinsWorld(EntityJoinWorldEvent event) {
        ItemEntity itemEntity;
        int lightLevel;
        if (event.getWorld().func_201670_d()) {
            return;
        }
        if (event.getEntity() instanceof ItemEntity && (lightLevel = this.getLightFromItemStack((itemEntity = (ItemEntity)event.getEntity()).func_92059_d())) > 0) {
            EntityItemAdapter entityItemAdapter = new EntityItemAdapter(itemEntity);
            trackedItemMap.put(itemEntity, entityItemAdapter);
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        Iterator<Map.Entry<ItemEntity, EntityItemAdapter>> iterator = trackedItemMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ItemEntity, EntityItemAdapter> mapEntry = iterator.next();
            if (mapEntry.getKey().func_70089_S()) {
                mapEntry.getValue().onTick();
                continue;
            }
            iterator.remove();
        }
    }

    private int getLightFromItemStack(ItemStack stack) {
        return itemsMap.contains(stack) ? 15 : 0;
    }

    static {
        trackedItemMap = new HashMap();
    }

    private class EntityItemAdapter
    implements IDynamicLightSource {
        private ItemEntity entity;
        private int lightLevel = 0;
        private boolean enabled = false;
        private boolean notWaterProof;

        public EntityItemAdapter(ItemEntity eI) {
            this.entity = eI;
            this.notWaterProof = notWaterProofItems.contains(eI.func_92059_d());
        }

        public void onTick() {
            if (this.entity.func_70027_ad()) {
                this.lightLevel = 15;
            } else {
                this.lightLevel = DroppedItemsLightSource.this.getLightFromItemStack(this.entity.func_92059_d());
                BlockPos pos = this.entity.func_233580_cy_();
                BlockState is = this.entity.field_70170_p.func_180495_p(pos);
                if (this.notWaterProof && is.func_185904_a().func_76224_d()) {
                    this.lightLevel = 0;
                }
            }
            if (!this.enabled && this.lightLevel > 0) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 1) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.notWaterProof && this.entity.func_70090_H() ? 0 : this.lightLevel;
        }
    }
}

