/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import atomicstryker.dynamiclights.server.DynamicLightSourceContainer;
import atomicstryker.dynamiclights.server.DynamicLightsConfig;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.blocks.BlockLitAir;
import atomicstryker.dynamiclights.server.blocks.BlockLitCaveAir;
import atomicstryker.dynamiclights.server.blocks.BlockLitWater;
import atomicstryker.dynamiclights.server.modules.DroppedItemsLightSource;
import atomicstryker.dynamiclights.server.modules.PlayerSelfLightSource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.Fluids;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dynamiclights")
public class DynamicLights {
    public static final String MOD_ID = "dynamiclights";
    private static final Logger LOGGER = LogManager.getLogger();
    private static DynamicLights instance;
    DynamicLightsConfig config = null;
    private ConcurrentHashMap<World, ConcurrentLinkedQueue<DynamicLightSourceContainer>> worldLightsMap;
    private PlayerSelfLightSource playerSelfLightSource;
    private DroppedItemsLightSource droppedItemsLightSource;
    public static final HashMap<Block, Block> vanillaBlocksToLitBlocksMap;

    public DynamicLights() {
        instance = this;
        this.worldLightsMap = new ConcurrentHashMap();
        this.playerSelfLightSource = new PlayerSelfLightSource();
        this.droppedItemsLightSource = new DroppedItemsLightSource();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(DynamicLights.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onBlocksRegistration(RegistryEvent.Register<Block> event) {
        Block litAirBlock = (Block)new BlockLitAir(AbstractBlock.Properties.func_200945_a((Material)Material.field_151579_a).func_200942_a().func_200944_c().func_235838_a_(x -> 15).func_222380_e().func_235859_g_()).setRegistryName(MOD_ID, "lit_air");
        event.getRegistry().register((IForgeRegistryEntry)litAirBlock);
        Block litWaterBlock = (Block)new BlockLitWater(Fluids.field_204546_a, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_235838_a_(x -> 15).func_222380_e()).setRegistryName(MOD_ID, "lit_water");
        event.getRegistry().register((IForgeRegistryEntry)litWaterBlock);
        Block litCaveAirBlock = (Block)new BlockLitCaveAir(AbstractBlock.Properties.func_200945_a((Material)Material.field_151579_a).func_200942_a().func_235838_a_(x -> 15).func_222380_e().func_235859_g_()).setRegistryName(MOD_ID, "lit_cave_air");
        vanillaBlocksToLitBlocksMap.put(Blocks.field_150350_a, litAirBlock);
        vanillaBlocksToLitBlocksMap.put(Blocks.field_150355_j, litWaterBlock);
        vanillaBlocksToLitBlocksMap.put(Blocks.field_201941_jj, litCaveAirBlock);
    }

    @SubscribeEvent
    public void serverStarted(FMLServerStartedEvent evt) {
        if (this.config == null) {
            this.initConfig();
        }
    }

    private void initConfig() {
        try {
            MinecraftServer server = (MinecraftServer)LogicalSidedProvider.INSTANCE.get(LogicalSide.SERVER);
            File configFile = new File(server.func_71209_f(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights.cfg");
            this.config = GsonConfig.loadConfigWithDefault(DynamicLightsConfig.class, configFile, new DynamicLightsConfig());
        }
        catch (IOException e) {
            LOGGER.error("IOException parsing config", (Throwable)e);
        }
    }

    public static void addLightSource(IDynamicLightSource lightToAdd) {
        if (lightToAdd.getAttachmentEntity() != null) {
            String dimensionLocationPath = lightToAdd.getAttachmentEntity().field_70170_p.func_234923_W_().func_240901_a_().func_110623_a();
            LOGGER.info("Calling addLightSource on entity {}, dimensionLocationPath {}", (Object)lightToAdd.getAttachmentEntity(), (Object)dimensionLocationPath);
            if (lightToAdd.getAttachmentEntity().func_70089_S() && !instance.isBannedDimension(dimensionLocationPath)) {
                DynamicLightSourceContainer newLightContainer = new DynamicLightSourceContainer(lightToAdd);
                ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = DynamicLights.instance.worldLightsMap.get(lightToAdd.getAttachmentEntity().field_70170_p);
                if (lightList != null) {
                    if (!lightList.contains(newLightContainer)) {
                        LOGGER.info("Successfully registered DynamicLight on Entity: {} in list {}", (Object)newLightContainer.getLightSource().getAttachmentEntity(), lightList);
                        lightList.add(newLightContainer);
                    } else {
                        LOGGER.info("Cannot add Dynamic Light: Attachment Entity is already registered!");
                    }
                } else {
                    lightList = new ConcurrentLinkedQueue();
                    lightList.add(newLightContainer);
                    DynamicLights.instance.worldLightsMap.put(lightToAdd.getAttachmentEntity().field_70170_p, lightList);
                }
            } else {
                LOGGER.error("Cannot add Dynamic Light: Attachment Entity {} is dead or in a banned dimension {}", (Object)lightToAdd.getAttachmentEntity(), (Object)lightToAdd.getAttachmentEntity().field_70170_p.func_234923_W_().func_240901_a_().func_110623_a());
            }
        } else {
            LOGGER.error("Cannot add Dynamic Light: Attachment Entity is null!");
        }
    }

    public static void removeLightSource(IDynamicLightSource lightToRemove) {
        World world;
        if (lightToRemove != null && lightToRemove.getAttachmentEntity() != null && (world = lightToRemove.getAttachmentEntity().field_70170_p) != null) {
            DynamicLightSourceContainer iterContainer = null;
            ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = DynamicLights.instance.worldLightsMap.get(world);
            if (lightList != null) {
                Iterator<DynamicLightSourceContainer> iter = lightList.iterator();
                while (iter.hasNext()) {
                    iterContainer = iter.next();
                    if (!iterContainer.getLightSource().equals(lightToRemove)) continue;
                    iter.remove();
                    break;
                }
                if (iterContainer != null) {
                    LOGGER.info("Removing Dynamic Light attached to {}", (Object)lightToRemove.getAttachmentEntity());
                    iterContainer.removeLight(world);
                }
            }
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        ConcurrentLinkedQueue<DynamicLightSourceContainer> worldLights = this.worldLightsMap.get(event.world);
        if (worldLights != null) {
            Iterator<DynamicLightSourceContainer> iter = worldLights.iterator();
            while (iter.hasNext()) {
                DynamicLightSourceContainer tickedLightContainer = iter.next();
                if (!tickedLightContainer.onUpdate()) continue;
                iter.remove();
                tickedLightContainer.removeLight(event.world);
                LOGGER.debug("Dynamic Lights killing off LightSource on dead Entity: " + tickedLightContainer.getLightSource().getAttachmentEntity());
            }
        }
    }

    public boolean isBannedDimension(String dimensionID) {
        return this.config.getBannedDimensions().contains(dimensionID);
    }

    public static boolean isKnownLitPosition(World world, BlockPos blockPos) {
        ConcurrentLinkedQueue<DynamicLightSourceContainer> worldLights = DynamicLights.instance.worldLightsMap.get(world);
        if (worldLights != null) {
            for (DynamicLightSourceContainer light : worldLights) {
                if (!blockPos.equals((Object)light.getPos())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        vanillaBlocksToLitBlocksMap = new HashMap();
    }
}

