/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class DynamicLightSourceContainer {
    private final IDynamicLightSource lightSource;
    private final BlockPos.Mutable prevPos = new BlockPos.Mutable();
    private final BlockPos.Mutable curPos = new BlockPos.Mutable();
    private final int yOffset;

    public DynamicLightSourceContainer(IDynamicLightSource light) {
        this.lightSource = light;
        this.yOffset = (int)Math.floor(light.getAttachmentEntity().func_70047_e());
    }

    public boolean onUpdate() {
        Entity ent = this.lightSource.getAttachmentEntity();
        if (!ent.func_70089_S()) {
            return true;
        }
        if (this.hasEntityMoved(ent)) {
            this.removePreviousLight(ent.field_70170_p);
            this.addLight(ent.field_70170_p);
        }
        return false;
    }

    public BlockPos getPos() {
        return this.curPos;
    }

    public IDynamicLightSource getLightSource() {
        return this.lightSource;
    }

    private boolean hasEntityMoved(Entity ent) {
        BlockPos newPos = ent.func_233580_cy_().func_177982_a(0, this.yOffset, 0);
        if (!newPos.equals((Object)this.curPos)) {
            this.prevPos.func_189533_g((Vector3i)this.curPos);
            this.curPos.func_189533_g((Vector3i)newPos);
            return true;
        }
        return false;
    }

    private void removePreviousLight(World world) {
        Block previousBlock = world.func_180495_p((BlockPos)this.prevPos).func_177230_c();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!vanillaBlockToLitBlockEntry.getValue().equals(previousBlock)) continue;
            world.func_180501_a((BlockPos)this.prevPos, vanillaBlockToLitBlockEntry.getKey().func_176223_P(), 3);
        }
    }

    public void removeLight(World world) {
        this.removePreviousLight(world);
        Block currentBlock = world.func_180495_p((BlockPos)this.curPos).func_177230_c();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!vanillaBlockToLitBlockEntry.getValue().equals(currentBlock)) continue;
            world.func_180501_a((BlockPos)this.curPos, vanillaBlockToLitBlockEntry.getKey().func_176223_P(), 3);
        }
    }

    private void addLight(World world) {
        BlockState blockState = world.func_180495_p((BlockPos)this.curPos);
        Block currentBlock = blockState.func_177230_c();
        for (Map.Entry<Block, Block> vanillaBlockToLitBlockEntry : DynamicLights.vanillaBlocksToLitBlocksMap.entrySet()) {
            if (!currentBlock.equals(vanillaBlockToLitBlockEntry.getKey())) continue;
            if (currentBlock instanceof FlowingFluidBlock && (Integer)blockState.func_177229_b((Property)FlowingFluidBlock.field_176367_b) != 0) {
                return;
            }
            world.func_180501_a((BlockPos)this.curPos, vanillaBlockToLitBlockEntry.getValue().func_176223_P(), 3);
            break;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof DynamicLightSourceContainer) {
            DynamicLightSourceContainer other = (DynamicLightSourceContainer)o;
            if (other.lightSource == this.lightSource) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.lightSource.getAttachmentEntity().hashCode();
    }
}

