/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.valhelsia.valhelsia_core.init.ValhelsiaLootConditions;

public class EntityTagCondition
implements ILootCondition {
    private final ITag<EntityType<?>> tag;

    public EntityTagCondition(ITag<EntityType<?>> tag) {
        this.tag = tag;
    }

    public static ILootCondition.IBuilder builder(ITag<EntityType<?>> tag) {
        return () -> new EntityTagCondition(tag);
    }

    @Nonnull
    public LootConditionType func_230419_b_() {
        return ValhelsiaLootConditions.ENTITY_TAG;
    }

    @Nonnull
    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216281_a);
    }

    public boolean test(LootContext lootContext) {
        if (!lootContext.func_216033_a(LootParameters.field_216281_a)) {
            return false;
        }
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        return this.tag.func_230235_a_((Object)Objects.requireNonNull(entity).func_200600_R());
    }

    public static class Serializer
    implements ILootSerializer<EntityTagCondition> {
        public void serialize(@Nonnull JsonObject jsonObject, EntityTagCondition instance, @Nonnull JsonSerializationContext context) {
            jsonObject.addProperty("tag", Objects.requireNonNull(TagCollectionManager.func_242178_a().func_241838_d().func_232973_a_(instance.tag)).toString());
        }

        @Nonnull
        public EntityTagCondition deserialize(@Nonnull JsonObject jsonObject, @Nonnull JsonDeserializationContext context) {
            ResourceLocation resourceLocation = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"tag"));
            ITag tag = TagCollectionManager.func_242178_a().func_241838_d().func_241834_b(resourceLocation);
            return new EntityTagCondition(tag);
        }
    }
}

