/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.valhelsia.valhelsia_core.gui.element.GuiElement;

public class ValhelsiaScreenManager {
    private final List<GuiElement> elements = new ArrayList<GuiElement>();

    protected List<GuiElement> getElements() {
        return this.elements;
    }

    protected boolean addElement(GuiElement element) {
        if (this.elements.contains(element)) {
            return false;
        }
        this.elements.add(element);
        this.initElement(element);
        return true;
    }

    protected boolean removeElement(GuiElement element) {
        if (!this.elements.contains(element)) {
            return false;
        }
        return this.elements.remove(element);
    }

    protected void removeAllElements() {
        this.elements.clear();
    }

    protected void initElement(GuiElement element) {
        this.getElements().get(this.getElements().indexOf(element)).init();
    }

    protected void renderAllElements(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.elements.forEach(element -> element.render(stack, mouseX, mouseY, partialTicks));
        this.elements.forEach(element -> {
            if (element.isMouseOver(mouseX, mouseY)) {
                element.renderHoverEffect(stack, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected boolean onClicked(double posX, double posY, int button) {
        for (GuiElement element : this.elements) {
            if (!element.isMouseOver(posX, posY) || !element.onClicked(posX, posY, button)) continue;
            return true;
        }
        return false;
    }
}

