/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.valhelsia.valhelsia_core.client.Cosmetic;
import net.valhelsia.valhelsia_core.client.CosmeticsCategory;
import net.valhelsia.valhelsia_core.client.screen.CosmeticsWardrobeScreen;
import net.valhelsia.valhelsia_core.client.screen.SelectableComponent;
import net.valhelsia.valhelsia_core.util.TextureDownloader;

public class CosmeticsEntry
extends Button
implements SelectableComponent {
    public static final int BG_COLOR = ColorHelper.PackedColor.func_233006_a_((int)255, (int)5, (int)17, (int)31);
    private final CosmeticsCategory category;
    private final Cosmetic cosmetic;
    private ResourceLocation previewTexture = null;
    private boolean selected;

    public CosmeticsEntry(CosmeticsCategory category, Cosmetic cosmetic, int x, int y, int width, int height, Button.IPressable onPress, boolean selected) {
        super(x, y, width, height, (ITextComponent)new TranslationTextComponent("cosmetic.valhelsia_core." + cosmetic.getName()), onPress);
        this.category = category;
        this.cosmetic = cosmetic;
        this.selected = selected;
        try {
            TextureDownloader.downloadTexture(new URL("https://static.valhelsia.net/cosmetics/preview/" + cosmetic.getName() + ".png"), "cosmetics/preview/", texture -> {
                this.previewTexture = texture;
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void func_230431_b_(@Nonnull MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)BG_COLOR);
        if (this.isSelected()) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(CosmeticsWardrobeScreen.TEXTURE);
            AbstractGui.func_238463_a_((MatrixStack)poseStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)92.0f, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)256, (int)256);
        }
        if (this.previewTexture != null) {
            DynamicTexture texture = (DynamicTexture)Minecraft.func_71410_x().func_110434_K().func_229267_b_(this.previewTexture);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(this.previewTexture);
            if (texture != null) {
                AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)this.field_230688_j_, (int)this.field_230689_k_, (float)0.0f, (float)0.0f, (int)texture.func_195414_e().func_195702_a(), (int)texture.func_195414_e().func_195714_b(), (int)texture.func_195414_e().func_195702_a(), (int)texture.func_195414_e().func_195714_b());
            }
        }
    }

    public CosmeticsCategory getCategory() {
        return this.category;
    }

    public Cosmetic getCosmetic() {
        return this.cosmetic;
    }
}

