/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.util.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BlockRitualStone;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.tile.TileMasterRitualStone;

public class RitualHelper {
    @CapabilityInject(value=IRitualStone.Tile.class)
    static Capability<IRitualStone.Tile> RUNE_CAPABILITY = null;

    public static boolean canCrystalActivate(Ritual ritual, int crystalLevel) {
        return ritual.getCrystalLevel() <= crystalLevel && BloodMagic.RITUAL_MANAGER.enabled(BloodMagic.RITUAL_MANAGER.getId(ritual), false);
    }

    public static String getValidRitual(World world, BlockPos pos) {
        for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
            for (int i = 0; i < 4; ++i) {
                Direction direction = Direction.func_176731_b((int)i);
                if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
                return BloodMagic.RITUAL_MANAGER.getId(ritual);
            }
        }
        return "";
    }

    public static Direction getDirectionOfRitual(World world, BlockPos pos, Ritual ritual) {
        for (int i = 0; i < 4; ++i) {
            Direction direction = Direction.func_176731_b((int)i);
            if (!RitualHelper.checkValidRitual(world, pos, ritual, direction)) continue;
            return direction;
        }
        return null;
    }

    public static boolean checkValidRitual(World world, BlockPos pos, Ritual ritual, Direction direction) {
        if (ritual == null) {
            return false;
        }
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        for (RitualComponent component : components) {
            BlockPos newPos = pos.func_177971_a((Vector3i)component.getOffset(direction));
            if (RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
            return false;
        }
        return true;
    }

    public static boolean isRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return ((IRitualStone)block).isRuneType(world, pos, type);
        }
        if (tile instanceof IRitualStone.Tile) {
            return ((IRitualStone.Tile)tile).isRuneType(type);
        }
        if (tile != null && tile.getCapability(RUNE_CAPABILITY, null).isPresent()) {
            return ((IRitualStone.Tile)tile.getCapability(RUNE_CAPABILITY, null).resolve().get()).isRuneType(type);
        }
        return false;
    }

    public static boolean isRune(World world, BlockPos pos) {
        if (world == null) {
            return false;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntity tile = world.func_175625_s(pos);
        if (block instanceof IRitualStone) {
            return true;
        }
        if (tile instanceof IRitualStone.Tile) {
            return true;
        }
        return tile != null && tile.getCapability(RUNE_CAPABILITY, null).isPresent();
    }

    public static void setRuneType(World world, BlockPos pos, EnumRuneType type) {
        if (world == null) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof IRitualStone) {
            ((IRitualStone)state.func_177230_c()).setRuneType(world, pos, type);
        } else if (tile instanceof IRitualStone.Tile) {
            ((IRitualStone.Tile)tile).setRuneType(type);
        } else {
            LazyOptional cap = tile.getCapability(RUNE_CAPABILITY, null);
            if (cap.isPresent()) {
                ((IRitualStone.Tile)cap.resolve().get()).setRuneType(type);
                world.func_184138_a(pos, state, state, 3);
            }
        }
    }

    public static boolean createRitual(World world, BlockPos pos, Direction direction, Ritual ritual, boolean safe) {
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        if (RitualHelper.abortConstruction(world, pos, direction, safe, components)) {
            return false;
        }
        BlockState mrs = ((Block)BloodMagicBlocks.MASTER_RITUAL_STONE.get()).func_176223_P();
        world.func_175656_a(pos, mrs);
        RitualHelper.setRitualStones(direction, world, pos, components);
        return true;
    }

    public static boolean abortConstruction(World world, BlockPos pos, Direction direction, boolean safe, List<RitualComponent> components) {
        for (RitualComponent component : components) {
            BlockPos offset = component.getOffset(direction);
            BlockPos newPos = pos.func_177971_a((Vector3i)offset);
            if (!World.func_189509_E((BlockPos)newPos) && (!safe || world.func_175623_d(newPos))) continue;
            return true;
        }
        return false;
    }

    public static boolean repairRitualFromRuins(TileMasterRitualStone tile, boolean safe) {
        Direction direction;
        Ritual ritual = tile.getCurrentRitual();
        if (ritual == null) {
            Pair<Ritual, Direction> pair = RitualHelper.getRitualFromRuins(tile);
            ritual = (Ritual)pair.getKey();
            direction = (Direction)pair.getValue();
        } else {
            direction = tile.getDirection();
        }
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        if (RitualHelper.abortConstruction(world, pos, direction, safe, components)) {
            return false;
        }
        RitualHelper.setRitualStones(direction, world, pos, components);
        return true;
    }

    public static void setRitualStones(Direction direction, World world, BlockPos pos, List<RitualComponent> gatheredComponents) {
        for (RitualComponent component : gatheredComponents) {
            BlockPos offset = component.getOffset(direction);
            BlockPos newPos = pos.func_177971_a((Vector3i)offset);
            ((BlockRitualStone)BloodMagicBlocks.BLANK_RITUAL_STONE.get()).setRuneType(world, newPos, component.getRuneType());
        }
    }

    public static Pair<Ritual, Direction> getRitualFromRuins(TileMasterRitualStone tile) {
        BlockPos pos = tile.func_174877_v();
        World world = tile.func_145831_w();
        Ritual possibleRitual = tile.getCurrentRitual();
        Direction possibleDirection = tile.getDirection();
        int highestCount = 0;
        if (possibleRitual == null || possibleDirection == null) {
            for (Ritual ritual : BloodMagic.RITUAL_MANAGER.getRituals()) {
                for (int i = 0; i < 4; ++i) {
                    Direction direction = Direction.func_176731_b((int)i);
                    ArrayList components = Lists.newArrayList();
                    ritual.gatherComponents(components::add);
                    int currentCount = 0;
                    for (RitualComponent component : components) {
                        BlockPos newPos = pos.func_177971_a((Vector3i)component.getOffset(direction));
                        if (!RitualHelper.isRuneType(world, newPos, component.getRuneType())) continue;
                        ++currentCount;
                    }
                    if (currentCount <= highestCount) continue;
                    highestCount = currentCount;
                    possibleRitual = ritual;
                    possibleDirection = direction;
                }
            }
        }
        return Pair.of((Object)possibleRitual, (Object)possibleDirection);
    }

    public static Tuple<Integer, Map<EnumRuneType, Integer>> countRunes(Ritual ritual) {
        EnumMap<EnumRuneType, Integer> runeMap = new EnumMap<EnumRuneType, Integer>(EnumRuneType.class);
        ArrayList components = Lists.newArrayList();
        ritual.gatherComponents(components::add);
        int totalRunes = components.size();
        for (RitualComponent component : components) {
            runeMap.compute(component.getRuneType(), (k, v) -> v == null ? 1 : v + 1);
        }
        return new Tuple((Object)totalRunes, runeMap);
    }
}

