/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.tile;

import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.registries.ObjectHolder;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.api.compat.IDemonWill;
import wayoftime.bloodmagic.api.compat.IDemonWillConduit;
import wayoftime.bloodmagic.api.compat.IDemonWillGem;
import wayoftime.bloodmagic.api.event.BloodMagicCraftedEvent;
import wayoftime.bloodmagic.demonaura.WorldDemonWillHandler;
import wayoftime.bloodmagic.impl.BloodMagicAPI;
import wayoftime.bloodmagic.recipe.RecipeTartaricForge;
import wayoftime.bloodmagic.tile.TileInventory;
import wayoftime.bloodmagic.tile.container.ContainerSoulForge;

public class TileSoulForge
extends TileInventory
implements ITickableTileEntity,
INamedContainerProvider,
IDemonWillConduit {
    @ObjectHolder(value="bloodmagic:soulforge")
    public static TileEntityType<TileSoulForge> TYPE;
    public static final int ticksRequired = 100;
    public static final double worldWillTransferRate = 1.0;
    public static final int soulSlot = 4;
    public static final int outputSlot = 5;
    public int burnTime = 0;
    public final IIntArray TileData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return TileSoulForge.this.burnTime;
                }
                case 1: {
                    return 100;
                }
                case 2: {
                    return 0;
                }
            }
            throw new IllegalArgumentException("Invalid index: " + index);
        }

        public void func_221477_a(int index, int value) {
            throw new IllegalStateException("Cannot set values through IIntArray");
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public TileSoulForge(TileEntityType<?> type) {
        super(type, 6, "soulforge");
    }

    public TileSoulForge() {
        this(TYPE);
    }

    @Override
    public void deserialize(CompoundNBT tag) {
        super.deserialize(tag);
        this.burnTime = tag.func_74762_e("burnTime");
    }

    @Override
    public CompoundNBT serialize(CompoundNBT tag) {
        super.serialize(tag);
        tag.func_74768_a("burnTime", this.burnTime);
        return tag;
    }

    public void func_73660_a() {
        if (!this.hasSoulGemOrSoul()) {
            this.burnTime = 0;
            return;
        }
        if (!this.func_145831_w().field_72995_K) {
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                double willInWorld = WorldDemonWillHandler.getCurrentWill(this.func_145831_w(), this.field_174879_c, type);
                double filled = Math.min(willInWorld, 1.0);
                if (!(filled > 0.0)) continue;
                filled = this.fillDemonWill(type, filled, false);
                filled = WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, type, filled, false);
                if (!(filled > 0.0)) continue;
                this.fillDemonWill(type, filled, true);
                WorldDemonWillHandler.drainWill(this.func_145831_w(), this.field_174879_c, type, filled, true);
            }
        }
        ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
        for (int i = 0; i < 4; ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            inputList.add(this.func_70301_a(i));
        }
        RecipeTartaricForge recipe = BloodMagicAPI.INSTANCE.getRecipeRegistrar().getTartaricForge(this.field_145850_b, inputList);
        if (recipe != null) {
            double soulsInGem = 0.0;
            EnumDemonWillType typeInGem = EnumDemonWillType.DEFAULT;
            for (EnumDemonWillType type : EnumDemonWillType.values()) {
                double quantityOfType = this.getWill(type);
                if (!(quantityOfType > soulsInGem)) continue;
                soulsInGem = quantityOfType;
                typeInGem = type;
            }
            if (soulsInGem >= recipe.getMinimumSouls() || this.burnTime > 0) {
                if (this.canCraft(recipe)) {
                    ++this.burnTime;
                    if (this.burnTime == 100) {
                        if (!this.func_145831_w().field_72995_K) {
                            double requiredSouls = recipe.getSoulDrain();
                            if (requiredSouls > 0.0 && !this.func_145831_w().field_72995_K && soulsInGem >= recipe.getMinimumSouls()) {
                                this.consumeSouls(typeInGem, requiredSouls);
                            }
                            if (!this.func_145831_w().field_72995_K && soulsInGem >= recipe.getMinimumSouls()) {
                                this.craftItem(recipe);
                            }
                        }
                        this.burnTime = 0;
                    } else if (this.burnTime > 110) {
                        this.burnTime = 0;
                    }
                } else {
                    this.burnTime = 0;
                }
            } else {
                this.burnTime = 0;
            }
        } else {
            this.burnTime = 0;
        }
    }

    private boolean canCraft(RecipeTartaricForge recipe) {
        if (recipe == null) {
            return false;
        }
        ItemStack currentOutputStack = this.func_70301_a(5);
        if (recipe.getOutput().func_190926_b()) {
            return false;
        }
        if (currentOutputStack.func_190926_b()) {
            return true;
        }
        if (!currentOutputStack.func_77969_a(recipe.getOutput())) {
            return false;
        }
        int result = currentOutputStack.func_190916_E() + recipe.getOutput().func_190916_E();
        return result <= this.func_70297_j_() && result <= currentOutputStack.func_77976_d();
    }

    public void craftItem(RecipeTartaricForge recipe) {
        if (this.canCraft(recipe)) {
            ItemStack currentOutputStack = this.func_70301_a(5);
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
            for (int i = 0; i < 4; ++i) {
                if (this.func_70301_a(i).func_190926_b()) continue;
                inputList.add(this.func_70301_a(i).func_77946_l());
            }
            BloodMagicCraftedEvent.SoulForge event = new BloodMagicCraftedEvent.SoulForge(recipe.getOutput().func_77946_l(), inputList.toArray(new ItemStack[0]));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (currentOutputStack.func_190926_b()) {
                this.func_70299_a(5, event.getOutput());
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)currentOutputStack, (ItemStack)event.getOutput())) {
                currentOutputStack.func_190917_f(event.getOutput().func_190916_E());
            }
            this.moveRemainingWillInConsumedInv();
            this.consumeInventory();
        }
    }

    public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
        assert (this.field_145850_b != null);
        return new ContainerSoulForge(this, this.TileData, p_createMenu_1_, p_createMenu_2_);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Hellfire Forge");
    }

    public boolean hasSoulGemOrSoul() {
        for (int i = 0; i <= 4; ++i) {
            ItemStack soulStack = this.func_70301_a(i);
            if (soulStack.func_190926_b() || !(soulStack.func_77973_b() instanceof IDemonWill) && !(soulStack.func_77973_b() instanceof IDemonWillGem)) continue;
            return true;
        }
        return false;
    }

    public double getProgressForGui() {
        return (double)this.burnTime / 100.0;
    }

    public double getWill(EnumDemonWillType type) {
        double will = 0.0;
        for (int i = 0; i <= 4; ++i) {
            Object soul;
            ItemStack soulStack = this.func_70301_a(i);
            if (soulStack == null) continue;
            if (soulStack.func_77973_b() instanceof IDemonWill && ((IDemonWill)soulStack.func_77973_b()).getType(soulStack) == type) {
                soul = (IDemonWill)soulStack.func_77973_b();
                will += soul.getWill(type, soulStack);
            }
            if (!(soulStack.func_77973_b() instanceof IDemonWillGem)) continue;
            soul = (IDemonWillGem)soulStack.func_77973_b();
            will += soul.getWill(type, soulStack);
        }
        return will;
    }

    public void moveRemainingWillInConsumedInv() {
        ItemStack outputStack = this.func_70301_a(5);
        if (outputStack != null && outputStack.func_77973_b() instanceof IDemonWillGem) {
            IDemonWillGem filledGem = (IDemonWillGem)outputStack.func_77973_b();
            for (int i = 0; i < 4; ++i) {
                ItemStack soulStack = this.func_70301_a(i);
                if (soulStack == null || !(soulStack.func_77973_b() instanceof IDemonWillGem)) continue;
                IDemonWillGem syphonedGem = (IDemonWillGem)soulStack.func_77973_b();
                for (EnumDemonWillType type : EnumDemonWillType.values()) {
                    double willInGem = syphonedGem.getWill(type, soulStack);
                    if (!(willInGem > 0.0)) continue;
                    filledGem.fillWill(type, outputStack, willInGem, true);
                }
            }
        }
    }

    public double consumeSouls(EnumDemonWillType type, double requested) {
        double consumed = 0.0;
        for (int i = 0; i <= 4; ++i) {
            ItemStack soulStack = this.func_70301_a(i);
            if (soulStack != null) {
                double souls;
                Object soul;
                if (soulStack.func_77973_b() instanceof IDemonWill && ((IDemonWill)soulStack.func_77973_b()).getType(soulStack) == type) {
                    soul = (IDemonWill)soulStack.func_77973_b();
                    souls = soul.drainWill(type, soulStack, requested - consumed);
                    if (soul.getWill(type, soulStack) <= 0.0) {
                        this.func_70299_a(i, ItemStack.field_190927_a);
                    }
                    consumed += souls;
                }
                if (soulStack.func_77973_b() instanceof IDemonWillGem) {
                    soul = (IDemonWillGem)soulStack.func_77973_b();
                    souls = soul.drainWill(type, soulStack, requested - consumed, true);
                    consumed += souls;
                }
            }
            if (!(consumed >= requested)) continue;
            return consumed;
        }
        return consumed;
    }

    public void consumeInventory() {
        for (int i = 0; i < 4; ++i) {
            ItemStack inputStack = this.func_70301_a(i);
            if (inputStack.func_190926_b()) continue;
            if (inputStack.func_77973_b().hasContainerItem(inputStack)) {
                this.func_70299_a(i, inputStack.func_77973_b().getContainerItem(inputStack));
                continue;
            }
            inputStack.func_190918_g(1);
            if (!inputStack.func_190926_b()) continue;
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    @Override
    public int getWeight() {
        return 50;
    }

    @Override
    public double fillDemonWill(EnumDemonWillType type, double amount, boolean doFill) {
        if (amount <= 0.0) {
            return 0.0;
        }
        if (!this.canFill(type)) {
            return 0.0;
        }
        ItemStack stack = this.func_70301_a(4);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.func_77973_b();
        return willGem.fillWill(type, stack, amount, doFill);
    }

    @Override
    public double drainDemonWill(EnumDemonWillType type, double amount, boolean doDrain) {
        ItemStack stack = this.func_70301_a(4);
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IDemonWillGem)) {
            return 0.0;
        }
        IDemonWillGem willGem = (IDemonWillGem)stack.func_77973_b();
        double drained = amount;
        double current = willGem.getWill(type, stack);
        if (current < drained) {
            drained = current;
        }
        if (doDrain) {
            drained = willGem.drainWill(type, stack, drained, true);
        }
        return drained;
    }

    @Override
    public boolean canFill(EnumDemonWillType type) {
        return true;
    }

    @Override
    public boolean canDrain(EnumDemonWillType type) {
        return true;
    }

    @Override
    public double getCurrentWill(EnumDemonWillType type) {
        return 0.0;
    }
}

