/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.network.SetClientVelocityPacket;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="jumping")
public class RitualJumping
extends Ritual {
    public static final String JUMP_RANGE = "jumpRange";
    public static final String JUMP_POWER = "jumpPower";

    public RitualJumping() {
        super("ritualJump", 0, 5000, "ritual.bloodmagic.jumpRitual");
        this.addBlockRange(JUMP_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-1, 1, -1), 3, 1, 3));
        this.setMaximumVolumeAndDistanceOfRange(JUMP_RANGE, 0, 5, 5);
        this.addBlockRange(JUMP_POWER, new AreaDescriptor.Rectangle(new BlockPos(0, 0, 0), 1, 5, 1));
        this.setMaximumVolumeAndDistanceOfRange(JUMP_POWER, 0, 1, 100);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        int maxEffects = currentEssence / this.getRefreshCost();
        int totalEffects = 0;
        AreaDescriptor jumpRange = masterRitualStone.getBlockRange(JUMP_RANGE);
        List entities = world.func_217357_a(LivingEntity.class, jumpRange.getAABB(masterRitualStone.getMasterBlockPos()));
        for (LivingEntity entity : entities) {
            if (totalEffects >= maxEffects) break;
            double motionY = (double)masterRitualStone.getBlockRange(JUMP_POWER).getHeight() * 0.3;
            entity.field_70143_R = 0.0f;
            if (entity.func_225608_bj_()) continue;
            Vector3d motion = entity.func_213322_ci();
            double motionX = motion.func_82615_a();
            double motionZ = motion.func_82616_c();
            ++totalEffects;
            entity.func_213293_j(motionX, motionY, motionZ);
            if (!(entity instanceof ServerPlayerEntity)) continue;
            BloodMagic.packetHandler.sendTo(new SetClientVelocityPacket(motionX, motionY, motionZ), (ServerPlayerEntity)entity);
        }
        masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost() * totalEffects));
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return this.getBlockRange(JUMP_POWER).getHeight();
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        for (int i = -1; i <= 1; ++i) {
            this.addCornerRunes(components, 1, i, EnumRuneType.AIR);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualJumping();
    }
}

