/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;
import wayoftime.bloodmagic.util.Utils;

@RitualRegister(value="felling")
public class RitualFelling
extends Ritual {
    public static final String FELLING_RANGE = "fellingRange";
    public static final String CHEST_RANGE = "chest";
    private ArrayList<BlockPos> treePartsCache;
    private Iterator<BlockPos> blockPosIterator;
    private boolean cached = false;
    private BlockPos currentPos;
    private static final ItemStack mockAxe = new ItemStack((IItemProvider)Items.field_151056_x, 1);

    public RitualFelling() {
        super("ritualFelling", 0, 20000, "ritual.bloodmagic.fellingRitual");
        this.addBlockRange(FELLING_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-10, -3, -10), new BlockPos(11, 27, 11)));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(FELLING_RANGE, 14000, 15, 30);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
        this.treePartsCache = new ArrayList();
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        BlockPos masterPos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor chestRange = masterRitualStone.getBlockRange(CHEST_RANGE);
        TileEntity tileInventory = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        if (world.field_72995_K) {
            return;
        }
        if (tileInventory != null && Utils.getNumberOfFreeSlots(tileInventory, Direction.DOWN) < 1) {
            return;
        }
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        if (!this.cached || this.treePartsCache.isEmpty()) {
            for (BlockPos blockPos : masterRitualStone.getBlockRange(FELLING_RANGE).getContainedPositions(masterRitualStone.getMasterBlockPos())) {
                if (this.treePartsCache.contains(blockPos) || world.func_175623_d(blockPos) || !BlockTags.field_200031_h.func_230235_a_((Object)world.func_180495_p(blockPos).func_177230_c()) && !BlockTags.field_206952_E.func_230235_a_((Object)world.func_180495_p(blockPos).func_177230_c())) continue;
                this.treePartsCache.add(blockPos);
            }
            this.cached = true;
            this.blockPosIterator = this.treePartsCache.iterator();
        }
        if (this.blockPosIterator.hasNext() && tileInventory != null) {
            masterRitualStone.getOwnerNetwork().syphon(masterRitualStone.ticket(this.getRefreshCost()));
            this.currentPos = this.blockPosIterator.next();
            IItemHandler inventory = Utils.getInventory(tileInventory, Direction.DOWN);
            BlockState state = world.func_180495_p(this.currentPos);
            this.placeInInventory(state, world, this.currentPos, inventory);
            BlockItemUseContext ctx = new BlockItemUseContext(world, null, Hand.MAIN_HAND, ItemStack.field_190927_a, BlockRayTraceResult.func_216352_a((Vector3d)new Vector3d(0.0, 0.0, 0.0), (Direction)Direction.UP, (BlockPos)this.currentPos));
            this.spawnParticlesAndSound((ServerWorld)world, this.currentPos, state, ctx);
            world.func_175656_a(this.currentPos, Blocks.field_150350_a.func_176223_P());
            this.blockPosIterator.remove();
        }
    }

    public void spawnParticlesAndSound(ServerWorld world, BlockPos pos, BlockState state, BlockItemUseContext context) {
        SoundType soundtype = state.getSoundType((IWorldReader)world, pos, (Entity)context.func_195999_j());
        world.func_184133_a(context.func_195999_j(), pos, state.getSoundType((IWorldReader)world, pos, (Entity)context.func_195999_j()).func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        BlockParticleData particleData = new BlockParticleData(ParticleTypes.field_197611_d, state);
        world.func_195598_a((IParticleData)particleData, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 8, 0.2, 0.2, 0.2, 0.03);
    }

    @Override
    public int getRefreshCost() {
        return 10;
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 1, EnumRuneType.EARTH);
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualFelling();
    }

    private void placeInInventory(BlockState choppedState, World world, BlockPos choppedPos, @Nullable IItemHandler inventory) {
        if (inventory == null) {
            return;
        }
        LootContext.Builder lootBuilder = new LootContext.Builder((ServerWorld)world);
        Vector3d blockCenter = new Vector3d((double)choppedPos.func_177958_n() + 0.5, (double)choppedPos.func_177956_o() + 0.5, (double)choppedPos.func_177952_p() + 0.5);
        List silkDrops = choppedState.func_215693_a(lootBuilder.func_216015_a(LootParameters.field_237457_g_, (Object)blockCenter).func_216015_a(LootParameters.field_216289_i, (Object)mockAxe));
        for (ItemStack stack : silkDrops) {
            ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)false);
            if (remainder.func_190926_b()) continue;
            world.func_217376_c((Entity)new ItemEntity(world, (double)choppedPos.func_177958_n() + 0.4, (double)(choppedPos.func_177956_o() + 2), (double)choppedPos.func_177952_p() + 0.4, remainder));
        }
    }
}

