/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionFill
extends RecipePotionFlaskBase {
    public int maxEffects;

    public RecipePotionFill(ResourceLocation id, List<Ingredient> input, int maxEffects, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.maxEffects = maxEffects;
    }

    public IRecipeSerializer<? extends RecipePotionFill> func_199559_b() {
        return BloodMagicRecipeSerializers.POTIONFILL.getRecipeSerializer();
    }

    @Override
    public IRecipeType<RecipePotionFlaskBase> func_222127_g() {
        return BloodMagicRecipeType.POTIONFLASK;
    }

    @Override
    public boolean canModifyFlask(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        return flaskEffectList.size() > 0;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeInt(this.maxEffects);
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        ItemStack copyStack = flaskStack.func_77946_l();
        ArrayList<EffectHolder> flaskEffectCopyList = new ArrayList<EffectHolder>();
        for (int i = 0; i < Math.min(flaskEffectList.size(), this.maxEffects); ++i) {
            flaskEffectCopyList.add(flaskEffectList.get(i));
        }
        ((ItemAlchemyFlask)copyStack.func_77973_b()).setEffectHoldersOfFlask(copyStack, flaskEffectCopyList);
        copyStack.func_196085_b(0);
        return copyStack;
    }

    @Override
    public ItemStack getExamplePotionFlask() {
        ItemStack flaskStack = new ItemStack((IItemProvider)BloodMagicItems.ALCHEMY_FLASK.get());
        flaskStack.func_196085_b(8);
        ((ItemAlchemyFlask)flaskStack.func_77973_b()).setEffectHoldersOfFlask(flaskStack, this.getExampleEffectList());
        ((ItemAlchemyFlask)flaskStack.func_77973_b()).resyncEffectInstances(flaskStack);
        return flaskStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        return 1;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        holderList.add(new EffectHolder(Effects.field_76424_c, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(Effects.field_76426_n, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(Effects.field_76422_e, 3600, 0, 1.0, 1.0));
        return holderList;
    }
}

