/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.recipe.flask;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import wayoftime.bloodmagic.common.item.potion.ItemAlchemyFlask;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.common.registries.BloodMagicRecipeSerializers;
import wayoftime.bloodmagic.recipe.EffectHolder;
import wayoftime.bloodmagic.recipe.flask.RecipePotionFlaskBase;

public class RecipePotionCycle
extends RecipePotionFlaskBase {
    public int numCycles;

    public RecipePotionCycle(ResourceLocation id, List<Ingredient> input, int numCycles, int syphon, int ticks, int minimumTier) {
        super(id, input, syphon, ticks, minimumTier);
        this.numCycles = numCycles;
    }

    public IRecipeSerializer<? extends RecipePotionCycle> func_199559_b() {
        return BloodMagicRecipeSerializers.POTIONCYCLE.getRecipeSerializer();
    }

    @Override
    public IRecipeType<RecipePotionFlaskBase> func_222127_g() {
        return BloodMagicRecipeType.POTIONFLASK;
    }

    @Override
    public boolean canModifyFlask(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        return flaskEffectList.size() >= 2;
    }

    @Override
    public void write(PacketBuffer buffer) {
        super.write(buffer);
        buffer.writeInt(this.numCycles);
    }

    @Override
    public ItemStack getOutput(ItemStack flaskStack, List<EffectHolder> flaskEffectList) {
        ItemStack copyStack = flaskStack.func_77946_l();
        ArrayList<EffectHolder> flaskEffectCopyList = new ArrayList<EffectHolder>(flaskEffectList);
        for (int i = 0; i < this.numCycles; ++i) {
            EffectHolder holder = (EffectHolder)flaskEffectCopyList.remove(0);
            flaskEffectCopyList.add(holder);
        }
        ((ItemAlchemyFlask)copyStack.func_77973_b()).setEffectHoldersOfFlask(copyStack, flaskEffectCopyList);
        return copyStack;
    }

    @Override
    public int getPriority(List<EffectHolder> flaskEffectList) {
        return 1;
    }

    @Override
    public List<EffectHolder> getExampleEffectList() {
        ArrayList<EffectHolder> holderList = new ArrayList<EffectHolder>();
        holderList.add(new EffectHolder(Effects.field_76424_c, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(Effects.field_76426_n, 3600, 0, 1.0, 1.0));
        holderList.add(new EffectHolder(Effects.field_76422_e, 3600, 0, 1.0, 1.0));
        return holderList;
    }
}

