/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetClientVelocityPacket {
    public double motionX;
    public double motionY;
    public double motionZ;

    public SetClientVelocityPacket() {
    }

    public SetClientVelocityPacket(double motionX, double motionY, double motionZ) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
    }

    public static void encode(SetClientVelocityPacket pkt, PacketBuffer buf) {
        buf.writeDouble(pkt.motionX);
        buf.writeDouble(pkt.motionY);
        buf.writeDouble(pkt.motionZ);
    }

    public static SetClientVelocityPacket decode(PacketBuffer buf) {
        SetClientVelocityPacket pkt = new SetClientVelocityPacket(buf.readDouble(), buf.readDouble(), buf.readDouble());
        return pkt;
    }

    public static void handle(SetClientVelocityPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> SetClientVelocityPacket.updateClientVelocity(message.motionX, message.motionY, message.motionZ));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateClientVelocity(double motionX, double motionY, double motionZ) {
        Minecraft.func_71410_x().field_71439_g.func_213293_j(motionX, motionY, motionZ);
    }
}

