/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.patchouli.components;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;
import wayoftime.bloodmagic.common.meteor.MeteorLayer;
import wayoftime.bloodmagic.common.meteor.RandomBlockContainer;
import wayoftime.bloodmagic.common.recipe.BloodMagicRecipeType;
import wayoftime.bloodmagic.recipe.RecipeMeteor;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class Meteor
implements ICustomComponent {
    private final transient int ITEMSPERROW = 6;
    private final transient int ROWHEIGHT = 31;
    private final transient ResourceLocation METEORBOXESTEXTURE = new ResourceLocation("bloodmagic", "textures/gui/patchouli_book/meteor_grids.png");
    private final transient Minecraft mc = Minecraft.func_71410_x();
    private transient World world;
    private transient RecipeMeteor recipeMeteor;
    private transient int syphon;
    private transient int totalLayerCount;
    private transient Ingredient input;
    private transient List<Integer> layerRadius;
    private transient List<List<Pair<List<ItemStack>, String>>> outputList;
    private transient List<List<Integer>> layerRowSizes;

    public Meteor() {
        this.world = this.mc.field_71441_e;
        this.layerRadius = new ArrayList<Integer>();
        this.outputList = new ArrayList<List<Pair<List<ItemStack>, String>>>();
        this.layerRowSizes = new ArrayList<List<Integer>>();
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        IRecipe recipe;
        Optional recipeHandler = this.world.func_199532_z().func_215367_a(new ResourceLocation(((IVariable)lookup.apply(IVariable.wrap((String)"#recipe"))).asString()));
        if (recipeHandler.isPresent() && (recipe = (IRecipe)recipeHandler.get()).func_222127_g().equals(BloodMagicRecipeType.METEOR)) {
            this.recipeMeteor = (RecipeMeteor)recipe;
        }
        if (this.recipeMeteor == null) {
            LogManager.getLogger().warn("Buidebook missing Meteor recipe {}:, id");
        }
    }

    public void build(int componentX, int componentY, int pageNum) {
        if (this.recipeMeteor != null) {
            this.input = this.recipeMeteor.getInput();
            this.syphon = this.recipeMeteor.getSyphon();
            for (MeteorLayer layer : this.recipeMeteor.getLayerList()) {
                int i;
                int weight;
                List<Block> shellBlocks;
                ++this.totalLayerCount;
                this.layerRadius.add(layer.layerRadius);
                ArrayList<Pair> layerWeightList = new ArrayList<Pair>();
                ArrayList<Pair> layerOutputList = new ArrayList<Pair>();
                int cellsNeeded = 0;
                int sumEntryWeights = 0;
                int fillWeight = 0;
                List<Block> list = shellBlocks = layer.shellBlock != null ? layer.shellBlock.getAllBlocks() : null;
                if (shellBlocks != null) {
                    ++cellsNeeded;
                    layerWeightList.add(Pair.of(this.itemStacksFromBlocks(shellBlocks), (Object)-1));
                }
                for (Pair<RandomBlockContainer, Integer> pair : layer.weightList) {
                    List<Block> blockList = ((RandomBlockContainer)pair.getLeft()).getAllBlocks();
                    if (blockList == null) continue;
                    ++cellsNeeded;
                    weight = (Integer)pair.getRight();
                    sumEntryWeights += weight;
                    layerWeightList.add(Pair.of(this.itemStacksFromBlocks(blockList), (Object)weight));
                }
                int totalWeight = Math.max(sumEntryWeights + layer.additionalTotalWeight, layer.minWeight);
                for (i = 0; i < layerWeightList.size(); ++i) {
                    int weight2 = (Integer)((Pair)layerWeightList.get(i)).getRight();
                    if (weight2 < 0) continue;
                    weight2 = weight2 * 10000 / totalWeight;
                    layerWeightList.set(i, Pair.of((Object)((List)((Pair)layerWeightList.get(i)).getLeft()), (Object)weight2));
                }
                fillWeight = totalWeight != 0 ? 10000 - sumEntryWeights * 10000 / totalWeight : 10000;
                if (fillWeight > 0) {
                    layerWeightList.add(Pair.of(this.itemStacksFromBlocks(layer.fillBlock.getAllBlocks()), (Object)fillWeight));
                    ++cellsNeeded;
                }
                for (i = 0; i < layerWeightList.size(); ++i) {
                    String outputWeight = "";
                    weight = (Integer)((Pair)layerWeightList.get(i)).getRight();
                    outputWeight = weight == -1 ? TextHelper.localize("guide.patchouli.bloodmagic.meteor.shell", new Object[0]) : (weight == 10000 ? "100%" : String.format("%4.1f%%", Float.valueOf((float)weight / 100.0f)));
                    layerOutputList.add(Pair.of((Object)((List)((Pair)layerWeightList.get(i)).getLeft()), (Object)outputWeight));
                }
                this.outputList.add(layerOutputList);
                ArrayList<Integer> rowSizes = new ArrayList<Integer>();
                while (cellsNeeded / 6 > 0) {
                    rowSizes.add(6);
                    cellsNeeded -= 6;
                }
                if (cellsNeeded > 0) {
                    rowSizes.add(cellsNeeded);
                }
                this.layerRowSizes.add(rowSizes);
            }
        }
    }

    public void render(MatrixStack ms, IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        if (this.recipeMeteor != null) {
            int y = -10;
            int x = 2;
            FontRenderer font = this.mc.field_71466_p;
            context.renderIngredient(ms, 2, -3, mouseX, mouseY, this.input);
            RenderSystem.enableBlend();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(new ResourceLocation("bloodmagic", "textures/gui/patchouli_book/crafting.png"));
            AbstractGui.func_238463_a_((MatrixStack)ms, (int)-1, (int)-6, (float)71.0f, (float)15.0f, (int)22, (int)22, (int)128, (int)256);
            IFormattableTextComponent textRender = new StringTextComponent(TextHelper.localize("guide.patchouli.bloodmagic.meteor.syphon", this.syphon)).func_240703_c_(context.getFont());
            font.func_238422_b_(ms, textRender.func_241878_f(), 23.0f, 7.0f, 0);
            y = -14;
            for (int i = 0; i < this.layerRowSizes.size(); ++i) {
                textRender = new StringTextComponent(TextHelper.localize("guide.patchouli.bloodmagic.meteor.radius", this.layerRadius.get(i))).func_240703_c_(context.getFont());
                font.func_238422_b_(ms, textRender.func_241878_f(), 0.0f, (float)(y + 31), 0);
                y += 7;
                for (int j : this.layerRowSizes.get(i)) {
                    this.rowBlit(ms, y += 31, j);
                }
            }
            y = -11;
            for (List<Pair<List<ItemStack>, String>> outputPair : this.outputList) {
                y += 7;
                for (int i = 0; i < outputPair.size(); ++i) {
                    if (i % 6 == 0) {
                        x = -17;
                        y += 31;
                    }
                    Pair<List<ItemStack>, String> output = outputPair.get(i);
                    context.renderItemStack(ms, x += 19, y + 1, mouseX, mouseY, (ItemStack)((List)output.getLeft()).get(context.getTicksInBook() / 20 % ((List)output.getLeft()).size()));
                    String text = (String)output.getRight();
                    textRender = new StringTextComponent(text).func_240703_c_(context.getFont());
                    if (text.equals("100%")) {
                        font.func_238422_b_(ms, textRender.func_241878_f(), (float)((double)x + 1.5), (float)(y + 18), 0);
                        continue;
                    }
                    font.func_238422_b_(ms, textRender.func_241878_f(), (float)((double)x - 0.5), (float)(y + 18), 0);
                }
            }
        }
    }

    private List<ItemStack> itemStacksFromBlocks(List<Block> blocks) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Block block : blocks) {
            items.add(new ItemStack((IItemProvider)block));
        }
        return items;
    }

    private void rowBlit(MatrixStack ms, int x, int y, int blocks) {
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.field_71446_o.func_110577_a(this.METEORBOXESTEXTURE);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)x, (int)y, (float)0.0f, (float)(blocks * 32), (int)128, (int)32, (int)128, (int)256);
    }

    private void rowBlit(MatrixStack ms, int y, int blocks) {
        this.rowBlit(ms, -2, y, blocks);
    }
}

