/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.event.ItemBindEvent;
import wayoftime.bloodmagic.tile.TileTeleposer;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ItemSigilTeleposition
extends ItemSigilBase {
    public ItemSigilTeleposition() {
        super("teleposition", 1000);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.func_77973_b()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return new ActionResult(ActionResultType.FAIL, (Object)stack);
        }
        if (world.field_72995_K || this.isUnusable(stack)) {
            return new ActionResult(ActionResultType.CONSUME, (Object)stack);
        }
        World storedWorld = this.getStoredWorld(stack, world);
        if (storedWorld != null && storedWorld instanceof ServerWorld) {
            RegistryKey<World> key = this.getStoredKey(stack, world);
            BlockPos telePos = this.getStoredPos(stack);
            TileEntity tile = storedWorld.func_175625_s(telePos);
            if (tile instanceof TileTeleposer) {
                ((TileTeleposer)tile).teleportPlayerToLocation((ServerWorld)storedWorld, player, key, (double)telePos.func_177958_n() + 0.5, telePos.func_177956_o() + 1, (double)telePos.func_177952_p() + 0.5);
                if (!player.func_184812_l_()) {
                    this.setUnusable(stack, !NetworkHelper.getSoulNetwork(this.getBinding(stack)).syphonAndDamage(player, SoulTicket.item(stack, world, (Entity)player, this.getLpUsed())).isSuccess());
                }
                storedWorld.func_184148_a(null, (double)telePos.func_177958_n(), (double)telePos.func_177956_o(), (double)telePos.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileTeleposer) {
            ItemBindEvent toPost;
            this.setStoredPos(stack, pos);
            this.setWorld(stack, world);
            Binding binding = this.getBinding(stack);
            if (binding == null && this.onBind(player, stack) && !MinecraftForge.EVENT_BUS.post((Event)(toPost = new ItemBindEvent(player, stack)))) {
                BindableHelper.applyBinding(stack, player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void setStoredPos(ItemStack stack, BlockPos pos) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74768_a("xCoord", pos.func_177958_n());
        tag.func_74768_a("yCoord", pos.func_177956_o());
        tag.func_74768_a("zCoord", pos.func_177952_p());
    }

    public BlockPos getStoredPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        return new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    public void setWorld(ItemStack stack, World world) {
        String worldKey = world.func_234923_W_().func_240901_a_().toString();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74778_a("world", worldKey);
    }

    public RegistryKey<World> getStoredKey(ItemStack stack, World world) {
        if (!stack.func_77942_o()) {
            return null;
        }
        String worldKey = stack.func_77978_p().func_74779_i("world");
        RegistryKey registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(worldKey));
        return registryKey;
    }

    public World getStoredWorld(ItemStack stack, World world) {
        RegistryKey<World> registryKey = this.getStoredKey(stack, world);
        if (registryKey == null || world.func_73046_m() == null) {
            return null;
        }
        return world.func_73046_m().func_71218_a(registryKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        RegistryKey<World> storedKey = this.getStoredKey(stack, world);
        if (storedKey != null) {
            BlockPos storedPos = this.getStoredPos(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionfocus.coords", storedPos.func_177958_n(), storedPos.func_177956_o(), storedPos.func_177952_p())).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.telepositionfocus.world", new Object[]{new TranslationTextComponent(storedKey.func_240901_a_().toString())}).func_240699_a_(TextFormatting.GRAY));
        }
    }
}

