/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import wayoftime.bloodmagic.common.item.ITeleposerFocus;
import wayoftime.bloodmagic.common.item.ItemBindableBase;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.event.ItemBindEvent;
import wayoftime.bloodmagic.tile.TileTeleposer;
import wayoftime.bloodmagic.util.helper.BindableHelper;
import wayoftime.bloodmagic.util.helper.TextHelper;

public class ItemTeleposerFocus
extends ItemBindableBase
implements ITeleposerFocus {
    public final int range;

    public ItemTeleposerFocus(int range) {
        this.range = range;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileTeleposer) {
            ItemBindEvent toPost;
            this.setStoredPos(stack, pos);
            this.setWorld(stack, world);
            Binding binding = this.getBinding(stack);
            if (binding == null && this.onBind(player, stack) && !MinecraftForge.EVENT_BUS.post((Event)(toPost = new ItemBindEvent(player, stack)))) {
                BindableHelper.applyBinding(stack, player);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void setStoredPos(ItemStack stack, BlockPos pos) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        tag.func_74768_a("xCoord", pos.func_177958_n());
        tag.func_74768_a("yCoord", pos.func_177956_o());
        tag.func_74768_a("zCoord", pos.func_177952_p());
    }

    @Override
    public BlockPos getStoredPos(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        CompoundNBT tag = stack.func_77978_p();
        return new BlockPos(tag.func_74762_e("xCoord"), tag.func_74762_e("yCoord"), tag.func_74762_e("zCoord"));
    }

    public void setWorld(ItemStack stack, World world) {
        String worldKey = world.func_234923_W_().func_240901_a_().toString();
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74778_a("world", worldKey);
    }

    public RegistryKey<World> getStoredKey(ItemStack stack, World world) {
        if (!stack.func_77942_o()) {
            return null;
        }
        String worldKey = stack.func_77978_p().func_74779_i("world");
        RegistryKey registryKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(worldKey));
        return registryKey;
    }

    @Override
    public World getStoredWorld(ItemStack stack, World world) {
        RegistryKey<World> registryKey = this.getStoredKey(stack, world);
        if (registryKey == null || world.func_73046_m() == null) {
            return null;
        }
        return world.func_73046_m().func_71218_a(registryKey);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        RegistryKey<World> storedKey = this.getStoredKey(stack, world);
        if (storedKey != null) {
            BlockPos storedPos = this.getStoredPos(stack);
            tooltip.add((ITextComponent)new TranslationTextComponent(TextHelper.localizeEffect("tooltip.bloodmagic.telepositionfocus.coords", storedPos.func_177958_n(), storedPos.func_177956_o(), storedPos.func_177952_p())).func_240699_a_(TextFormatting.GRAY));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.bloodmagic.telepositionfocus.world", new Object[]{new TranslationTextComponent(storedKey.func_240901_a_().toString())}).func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public AxisAlignedBB getEntityRangeOffset(World world, BlockPos teleposerPos) {
        return new AxisAlignedBB((double)(-this.range), 1.0, (double)(-this.range), (double)(this.range + 1), (double)(2 * this.range + 2), (double)(this.range + 1));
    }

    @Override
    public List<BlockPos> getBlockListOffset(World world) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = -this.range; i <= this.range; ++i) {
            for (int j = 1; j <= 2 * this.range + 1; ++j) {
                for (int k = -this.range; k <= this.range; ++k) {
                    posList.add(new BlockPos(i, j, k));
                }
            }
        }
        return posList;
    }
}

