/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3dc;
import org.joml.Matrix3fc;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class Matrix3d
implements Externalizable,
Matrix3dc {
    private static final long serialVersionUID = 1L;
    public double m00;
    public double m01;
    public double m02;
    public double m10;
    public double m11;
    public double m12;
    public double m20;
    public double m21;
    public double m22;

    public Matrix3d() {
        this.m00 = 1.0;
        this.m11 = 1.0;
        this.m22 = 1.0;
    }

    public Matrix3d(Matrix3dc mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
    }

    public Matrix3d(Matrix3fc mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
    }

    public Matrix3d(Matrix4fc mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
    }

    public Matrix3d(Matrix4dc mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
    }

    public Matrix3d(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
    }

    public Matrix3d(DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
    }

    public Matrix3d(Vector3dc col0, Vector3dc col1, Vector3dc col2) {
        this.m00 = col0.x();
        this.m01 = col0.y();
        this.m02 = col0.z();
        this.m10 = col1.x();
        this.m11 = col1.y();
        this.m12 = col1.z();
        this.m20 = col2.x();
        this.m21 = col2.y();
        this.m22 = col2.z();
    }

    public double m00() {
        return this.m00;
    }

    public double m01() {
        return this.m01;
    }

    public double m02() {
        return this.m02;
    }

    public double m10() {
        return this.m10;
    }

    public double m11() {
        return this.m11;
    }

    public double m12() {
        return this.m12;
    }

    public double m20() {
        return this.m20;
    }

    public double m21() {
        return this.m21;
    }

    public double m22() {
        return this.m22;
    }

    public Matrix3d m00(double m00) {
        this.m00 = m00;
        return this;
    }

    public Matrix3d m01(double m01) {
        this.m01 = m01;
        return this;
    }

    public Matrix3d m02(double m02) {
        this.m02 = m02;
        return this;
    }

    public Matrix3d m10(double m10) {
        this.m10 = m10;
        return this;
    }

    public Matrix3d m11(double m11) {
        this.m11 = m11;
        return this;
    }

    public Matrix3d m12(double m12) {
        this.m12 = m12;
        return this;
    }

    public Matrix3d m20(double m20) {
        this.m20 = m20;
        return this;
    }

    public Matrix3d m21(double m21) {
        this.m21 = m21;
        return this;
    }

    public Matrix3d m22(double m22) {
        this.m22 = m22;
        return this;
    }

    public Matrix3d set(Matrix3dc m) {
        this.m00 = m.m00();
        this.m01 = m.m01();
        this.m02 = m.m02();
        this.m10 = m.m10();
        this.m11 = m.m11();
        this.m12 = m.m12();
        this.m20 = m.m20();
        this.m21 = m.m21();
        this.m22 = m.m22();
        return this;
    }

    public Matrix3d set(Matrix3fc m) {
        this.m00 = m.m00();
        this.m01 = m.m01();
        this.m02 = m.m02();
        this.m10 = m.m10();
        this.m11 = m.m11();
        this.m12 = m.m12();
        this.m20 = m.m20();
        this.m21 = m.m21();
        this.m22 = m.m22();
        return this;
    }

    public Matrix3d set(Matrix4fc mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
        return this;
    }

    public Matrix3d set(Matrix4dc mat) {
        this.m00 = mat.m00();
        this.m01 = mat.m01();
        this.m02 = mat.m02();
        this.m10 = mat.m10();
        this.m11 = mat.m11();
        this.m12 = mat.m12();
        this.m20 = mat.m20();
        this.m21 = mat.m21();
        this.m22 = mat.m22();
        return this;
    }

    public Matrix3d set(AxisAngle4f axisAngle) {
        double x = axisAngle.x;
        double y = axisAngle.y;
        double z = axisAngle.z;
        double angle = axisAngle.angle;
        double invLength = 1.0 / Math.sqrt(x * x + y * y + z * z);
        x *= invLength;
        y *= invLength;
        z *= invLength;
        double s = Math.sin(angle);
        double c = Math.cosFromSin(s, angle);
        double omc = 1.0 - c;
        this.m00 = c + x * x * omc;
        this.m11 = c + y * y * omc;
        this.m22 = c + z * z * omc;
        double tmp1 = x * y * omc;
        double tmp2 = z * s;
        this.m10 = tmp1 - tmp2;
        this.m01 = tmp1 + tmp2;
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m20 = tmp1 + tmp2;
        this.m02 = tmp1 - tmp2;
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m21 = tmp1 - tmp2;
        this.m12 = tmp1 + tmp2;
        return this;
    }

    public Matrix3d set(AxisAngle4d axisAngle) {
        double x = axisAngle.x;
        double y = axisAngle.y;
        double z = axisAngle.z;
        double angle = axisAngle.angle;
        double invLength = 1.0 / Math.sqrt(x * x + y * y + z * z);
        x *= invLength;
        y *= invLength;
        z *= invLength;
        double s = Math.sin(angle);
        double c = Math.cosFromSin(s, angle);
        double omc = 1.0 - c;
        this.m00 = c + x * x * omc;
        this.m11 = c + y * y * omc;
        this.m22 = c + z * z * omc;
        double tmp1 = x * y * omc;
        double tmp2 = z * s;
        this.m10 = tmp1 - tmp2;
        this.m01 = tmp1 + tmp2;
        tmp1 = x * z * omc;
        tmp2 = y * s;
        this.m20 = tmp1 + tmp2;
        this.m02 = tmp1 - tmp2;
        tmp1 = y * z * omc;
        tmp2 = x * s;
        this.m21 = tmp1 - tmp2;
        this.m12 = tmp1 + tmp2;
        return this;
    }

    public Matrix3d set(Quaternionfc q) {
        return this.rotation(q);
    }

    public Matrix3d set(Quaterniondc q) {
        return this.rotation(q);
    }

    public Matrix3d mul(Matrix3dc right) {
        return this.mul(right, this);
    }

    public Matrix3d mul(Matrix3dc right, Matrix3d dest) {
        double nm00 = this.m00 * right.m00() + this.m10 * right.m01() + this.m20 * right.m02();
        double nm01 = this.m01 * right.m00() + this.m11 * right.m01() + this.m21 * right.m02();
        double nm02 = this.m02 * right.m00() + this.m12 * right.m01() + this.m22 * right.m02();
        double nm10 = this.m00 * right.m10() + this.m10 * right.m11() + this.m20 * right.m12();
        double nm11 = this.m01 * right.m10() + this.m11 * right.m11() + this.m21 * right.m12();
        double nm12 = this.m02 * right.m10() + this.m12 * right.m11() + this.m22 * right.m12();
        double nm20 = this.m00 * right.m20() + this.m10 * right.m21() + this.m20 * right.m22();
        double nm21 = this.m01 * right.m20() + this.m11 * right.m21() + this.m21 * right.m22();
        double nm22 = this.m02 * right.m20() + this.m12 * right.m21() + this.m22 * right.m22();
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d mul(Matrix3fc right) {
        return this.mul(right, this);
    }

    public Matrix3d mul(Matrix3fc right, Matrix3d dest) {
        double nm00 = this.m00 * (double)right.m00() + this.m10 * (double)right.m01() + this.m20 * (double)right.m02();
        double nm01 = this.m01 * (double)right.m00() + this.m11 * (double)right.m01() + this.m21 * (double)right.m02();
        double nm02 = this.m02 * (double)right.m00() + this.m12 * (double)right.m01() + this.m22 * (double)right.m02();
        double nm10 = this.m00 * (double)right.m10() + this.m10 * (double)right.m11() + this.m20 * (double)right.m12();
        double nm11 = this.m01 * (double)right.m10() + this.m11 * (double)right.m11() + this.m21 * (double)right.m12();
        double nm12 = this.m02 * (double)right.m10() + this.m12 * (double)right.m11() + this.m22 * (double)right.m12();
        double nm20 = this.m00 * (double)right.m20() + this.m10 * (double)right.m21() + this.m20 * (double)right.m22();
        double nm21 = this.m01 * (double)right.m20() + this.m11 * (double)right.m21() + this.m21 * (double)right.m22();
        double nm22 = this.m02 * (double)right.m20() + this.m12 * (double)right.m21() + this.m22 * (double)right.m22();
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d set(double m00, double m01, double m02, double m10, double m11, double m12, double m20, double m21, double m22) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        return this;
    }

    public Matrix3d set(double[] m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m10 = m[3];
        this.m11 = m[4];
        this.m12 = m[5];
        this.m20 = m[6];
        this.m21 = m[7];
        this.m22 = m[8];
        return this;
    }

    public Matrix3d set(float[] m) {
        this.m00 = m[0];
        this.m01 = m[1];
        this.m02 = m[2];
        this.m10 = m[3];
        this.m11 = m[4];
        this.m12 = m[5];
        this.m20 = m[6];
        this.m21 = m[7];
        this.m22 = m[8];
        return this;
    }

    public double determinant() {
        return (this.m00 * this.m11 - this.m01 * this.m10) * this.m22 + (this.m02 * this.m10 - this.m00 * this.m12) * this.m21 + (this.m01 * this.m12 - this.m02 * this.m11) * this.m20;
    }

    public Matrix3d invert() {
        return this.invert(this);
    }

    public Matrix3d invert(Matrix3d dest) {
        double s = this.determinant();
        s = 1.0 / s;
        double nm00 = (this.m11 * this.m22 - this.m21 * this.m12) * s;
        double nm01 = (this.m21 * this.m02 - this.m01 * this.m22) * s;
        double nm02 = (this.m01 * this.m12 - this.m11 * this.m02) * s;
        double nm10 = (this.m20 * this.m12 - this.m10 * this.m22) * s;
        double nm11 = (this.m00 * this.m22 - this.m20 * this.m02) * s;
        double nm12 = (this.m10 * this.m02 - this.m00 * this.m12) * s;
        double nm20 = (this.m10 * this.m21 - this.m20 * this.m11) * s;
        double nm21 = (this.m20 * this.m01 - this.m00 * this.m21) * s;
        double nm22 = (this.m00 * this.m11 - this.m10 * this.m01) * s;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d transpose() {
        return this.transpose(this);
    }

    public Matrix3d transpose(Matrix3d dest) {
        dest.set(this.m00, this.m10, this.m20, this.m01, this.m11, this.m21, this.m02, this.m12, this.m22);
        return dest;
    }

    public String toString() {
        DecimalFormat formatter = new DecimalFormat(" 0.000E0;-");
        String str = this.toString(formatter);
        StringBuffer res = new StringBuffer();
        int eIndex = Integer.MIN_VALUE;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'E') {
                eIndex = i;
            } else {
                if (c == ' ' && eIndex == i - 1) {
                    res.append('+');
                    continue;
                }
                if (Character.isDigit(c) && eIndex == i - 1) {
                    res.append('+');
                }
            }
            res.append(c);
        }
        return res.toString();
    }

    public String toString(NumberFormat formatter) {
        return formatter.format(this.m00) + " " + formatter.format(this.m10) + " " + formatter.format(this.m20) + "\n" + formatter.format(this.m01) + " " + formatter.format(this.m11) + " " + formatter.format(this.m21) + "\n" + formatter.format(this.m02) + " " + formatter.format(this.m12) + " " + formatter.format(this.m22) + "\n";
    }

    public Matrix3d get(Matrix3d dest) {
        return dest.set(this);
    }

    public AxisAngle4f getRotation(AxisAngle4f dest) {
        return dest.set(this);
    }

    public Quaternionf getUnnormalizedRotation(Quaternionf dest) {
        return dest.setFromUnnormalized(this);
    }

    public Quaternionf getNormalizedRotation(Quaternionf dest) {
        return dest.setFromNormalized(this);
    }

    public Quaterniond getUnnormalizedRotation(Quaterniond dest) {
        return dest.setFromUnnormalized(this);
    }

    public Quaterniond getNormalizedRotation(Quaterniond dest) {
        return dest.setFromNormalized(this);
    }

    public DoubleBuffer get(DoubleBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public DoubleBuffer get(int index, DoubleBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public FloatBuffer get(FloatBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public FloatBuffer get(int index, FloatBuffer buffer) {
        MemUtil.INSTANCE.putf(this, index, buffer);
        return buffer;
    }

    public ByteBuffer get(ByteBuffer buffer) {
        return this.get(buffer.position(), buffer);
    }

    public ByteBuffer get(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.put(this, index, buffer);
        return buffer;
    }

    public ByteBuffer getFloats(ByteBuffer buffer) {
        return this.getFloats(buffer.position(), buffer);
    }

    public ByteBuffer getFloats(int index, ByteBuffer buffer) {
        MemUtil.INSTANCE.putf(this, index, buffer);
        return buffer;
    }

    public double[] get(double[] arr, int offset) {
        arr[offset + 0] = this.m00;
        arr[offset + 1] = this.m01;
        arr[offset + 2] = this.m02;
        arr[offset + 3] = this.m10;
        arr[offset + 4] = this.m11;
        arr[offset + 5] = this.m12;
        arr[offset + 6] = this.m20;
        arr[offset + 7] = this.m21;
        arr[offset + 8] = this.m22;
        return arr;
    }

    public double[] get(double[] arr) {
        return this.get(arr, 0);
    }

    public float[] get(float[] arr, int offset) {
        arr[offset + 0] = (float)this.m00;
        arr[offset + 1] = (float)this.m01;
        arr[offset + 2] = (float)this.m02;
        arr[offset + 3] = (float)this.m10;
        arr[offset + 4] = (float)this.m11;
        arr[offset + 5] = (float)this.m12;
        arr[offset + 6] = (float)this.m20;
        arr[offset + 7] = (float)this.m21;
        arr[offset + 8] = (float)this.m22;
        return arr;
    }

    public float[] get(float[] arr) {
        return this.get(arr, 0);
    }

    public Matrix3d set(DoubleBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
        return this;
    }

    public Matrix3d set(FloatBuffer buffer) {
        MemUtil.INSTANCE.getf(this, buffer.position(), buffer);
        return this;
    }

    public Matrix3d set(ByteBuffer buffer) {
        MemUtil.INSTANCE.get(this, buffer.position(), buffer);
        return this;
    }

    public Matrix3d setFloats(ByteBuffer buffer) {
        MemUtil.INSTANCE.getf(this, buffer.position(), buffer);
        return this;
    }

    public Matrix3d set(Vector3dc col0, Vector3dc col1, Vector3dc col2) {
        this.m00 = col0.x();
        this.m01 = col0.y();
        this.m02 = col0.z();
        this.m10 = col1.x();
        this.m11 = col1.y();
        this.m12 = col1.z();
        this.m20 = col2.x();
        this.m21 = col2.y();
        this.m22 = col2.z();
        return this;
    }

    public Matrix3d zero() {
        this.m00 = 0.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 0.0;
        return this;
    }

    public Matrix3d identity() {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d scaling(double factor) {
        this.m00 = factor;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = factor;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = factor;
        return this;
    }

    public Matrix3d scaling(double x, double y, double z) {
        this.m00 = x;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = y;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = z;
        return this;
    }

    public Matrix3d scaling(Vector3dc xyz) {
        this.m00 = xyz.x();
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = xyz.y();
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = xyz.z();
        return this;
    }

    public Matrix3d scale(Vector3dc xyz, Matrix3d dest) {
        return this.scale(xyz.x(), xyz.y(), xyz.z(), dest);
    }

    public Matrix3d scale(Vector3dc xyz) {
        return this.scale(xyz.x(), xyz.y(), xyz.z(), this);
    }

    public Matrix3d scale(double x, double y, double z, Matrix3d dest) {
        dest.m00 = this.m00 * x;
        dest.m01 = this.m01 * x;
        dest.m02 = this.m02 * x;
        dest.m10 = this.m10 * y;
        dest.m11 = this.m11 * y;
        dest.m12 = this.m12 * y;
        dest.m20 = this.m20 * z;
        dest.m21 = this.m21 * z;
        dest.m22 = this.m22 * z;
        return dest;
    }

    public Matrix3d scale(double x, double y, double z) {
        return this.scale(x, y, z, this);
    }

    public Matrix3d scale(double xyz, Matrix3d dest) {
        return this.scale(xyz, xyz, xyz, dest);
    }

    public Matrix3d scale(double xyz) {
        return this.scale(xyz, xyz, xyz);
    }

    public Matrix3d scaleLocal(double x, double y, double z, Matrix3d dest) {
        double nm00 = x * this.m00;
        double nm01 = y * this.m01;
        double nm02 = z * this.m02;
        double nm10 = x * this.m10;
        double nm11 = y * this.m11;
        double nm12 = z * this.m12;
        double nm20 = x * this.m20;
        double nm21 = y * this.m21;
        double nm22 = z * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d scaleLocal(double x, double y, double z) {
        return this.scaleLocal(x, y, z, this);
    }

    public Matrix3d rotation(double angle, Vector3dc axis) {
        return this.rotation(angle, axis.x(), axis.y(), axis.z());
    }

    public Matrix3d rotation(double angle, Vector3fc axis) {
        return this.rotation(angle, axis.x(), axis.y(), axis.z());
    }

    public Matrix3d rotation(AxisAngle4f axisAngle) {
        return this.rotation(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix3d rotation(AxisAngle4d axisAngle) {
        return this.rotation(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix3d rotation(double angle, double x, double y, double z) {
        double sin = Math.sin(angle);
        double cos = Math.cosFromSin(sin, angle);
        double C = 1.0 - cos;
        double xy = x * y;
        double xz = x * z;
        double yz = y * z;
        this.m00 = cos + x * x * C;
        this.m10 = xy * C - z * sin;
        this.m20 = xz * C + y * sin;
        this.m01 = xy * C + z * sin;
        this.m11 = cos + y * y * C;
        this.m21 = yz * C - x * sin;
        this.m02 = xz * C - y * sin;
        this.m12 = yz * C + x * sin;
        this.m22 = cos + z * z * C;
        return this;
    }

    public Matrix3d rotationX(double ang) {
        double sin;
        double cos;
        if (ang == java.lang.Math.PI || ang == -java.lang.Math.PI) {
            cos = -1.0;
            sin = 0.0;
        } else if (ang == 1.5707963267948966 || ang == -4.71238898038469) {
            cos = 0.0;
            sin = 1.0;
        } else if (ang == -1.5707963267948966 || ang == 4.71238898038469) {
            cos = 0.0;
            sin = -1.0;
        } else {
            sin = Math.sin(ang);
            cos = Math.cosFromSin(sin, ang);
        }
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = cos;
        this.m12 = sin;
        this.m20 = 0.0;
        this.m21 = -sin;
        this.m22 = cos;
        return this;
    }

    public Matrix3d rotationY(double ang) {
        double sin;
        double cos;
        if (ang == java.lang.Math.PI || ang == -java.lang.Math.PI) {
            cos = -1.0;
            sin = 0.0;
        } else if (ang == 1.5707963267948966 || ang == -4.71238898038469) {
            cos = 0.0;
            sin = 1.0;
        } else if (ang == -1.5707963267948966 || ang == 4.71238898038469) {
            cos = 0.0;
            sin = -1.0;
        } else {
            sin = Math.sin(ang);
            cos = Math.cosFromSin(sin, ang);
        }
        this.m00 = cos;
        this.m01 = 0.0;
        this.m02 = -sin;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = sin;
        this.m21 = 0.0;
        this.m22 = cos;
        return this;
    }

    public Matrix3d rotationZ(double ang) {
        double sin;
        double cos;
        if (ang == java.lang.Math.PI || ang == -java.lang.Math.PI) {
            cos = -1.0;
            sin = 0.0;
        } else if (ang == 1.5707963267948966 || ang == -4.71238898038469) {
            cos = 0.0;
            sin = 1.0;
        } else if (ang == -1.5707963267948966 || ang == 4.71238898038469) {
            cos = 0.0;
            sin = -1.0;
        } else {
            sin = Math.sin(ang);
            cos = Math.cosFromSin(sin, ang);
        }
        this.m00 = cos;
        this.m01 = sin;
        this.m02 = 0.0;
        this.m10 = -sin;
        this.m11 = cos;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
        return this;
    }

    public Matrix3d rotationXYZ(double angleX, double angleY, double angleZ) {
        double sinX = Math.sin(angleX);
        double cosX = Math.cosFromSin(sinX, angleX);
        double sinY = Math.sin(angleY);
        double cosY = Math.cosFromSin(sinY, angleY);
        double sinZ = Math.sin(angleZ);
        double cosZ = Math.cosFromSin(sinZ, angleZ);
        double m_sinX = -sinX;
        double m_sinY = -sinY;
        double m_sinZ = -sinZ;
        double nm11 = cosX;
        double nm12 = sinX;
        double nm21 = m_sinX;
        double nm22 = cosX;
        double nm00 = cosY;
        double nm01 = nm21 * m_sinY;
        double nm02 = nm22 * m_sinY;
        this.m20 = sinY;
        this.m21 = nm21 * cosY;
        this.m22 = nm22 * cosY;
        this.m00 = nm00 * cosZ;
        this.m01 = nm01 * cosZ + nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m10 = nm00 * m_sinZ;
        this.m11 = nm01 * m_sinZ + nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return this;
    }

    public Matrix3d rotationZYX(double angleZ, double angleY, double angleX) {
        double sinX = Math.sin(angleX);
        double cosX = Math.cosFromSin(sinX, angleX);
        double sinY = Math.sin(angleY);
        double cosY = Math.cosFromSin(sinY, angleY);
        double sinZ = Math.sin(angleZ);
        double cosZ = Math.cosFromSin(sinZ, angleZ);
        double m_sinZ = -sinZ;
        double m_sinY = -sinY;
        double m_sinX = -sinX;
        double nm00 = cosZ;
        double nm01 = sinZ;
        double nm10 = m_sinZ;
        double nm11 = cosZ;
        double nm20 = nm00 * sinY;
        double nm21 = nm01 * sinY;
        double nm22 = cosY;
        this.m00 = nm00 * cosY;
        this.m01 = nm01 * cosY;
        this.m02 = m_sinY;
        this.m10 = nm10 * cosX + nm20 * sinX;
        this.m11 = nm11 * cosX + nm21 * sinX;
        this.m12 = nm22 * sinX;
        this.m20 = nm10 * m_sinX + nm20 * cosX;
        this.m21 = nm11 * m_sinX + nm21 * cosX;
        this.m22 = nm22 * cosX;
        return this;
    }

    public Matrix3d rotationYXZ(double angleY, double angleX, double angleZ) {
        double sinX = Math.sin(angleX);
        double cosX = Math.cosFromSin(sinX, angleX);
        double sinY = Math.sin(angleY);
        double cosY = Math.cosFromSin(sinY, angleY);
        double sinZ = Math.sin(angleZ);
        double cosZ = Math.cosFromSin(sinZ, angleZ);
        double m_sinY = -sinY;
        double m_sinX = -sinX;
        double m_sinZ = -sinZ;
        double nm00 = cosY;
        double nm02 = m_sinY;
        double nm20 = sinY;
        double nm22 = cosY;
        double nm10 = nm20 * sinX;
        double nm11 = cosX;
        double nm12 = nm22 * sinX;
        this.m20 = nm20 * cosX;
        this.m21 = m_sinX;
        this.m22 = nm22 * cosX;
        this.m00 = nm00 * cosZ + nm10 * sinZ;
        this.m01 = nm11 * sinZ;
        this.m02 = nm02 * cosZ + nm12 * sinZ;
        this.m10 = nm00 * m_sinZ + nm10 * cosZ;
        this.m11 = nm11 * cosZ;
        this.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return this;
    }

    public Matrix3d rotation(Quaterniondc quat) {
        double w2 = quat.w() * quat.w();
        double x2 = quat.x() * quat.x();
        double y2 = quat.y() * quat.y();
        double z2 = quat.z() * quat.z();
        double zw = quat.z() * quat.w();
        double xy = quat.x() * quat.y();
        double xz = quat.x() * quat.z();
        double yw = quat.y() * quat.w();
        double yz = quat.y() * quat.z();
        double xw = quat.x() * quat.w();
        this.m00 = w2 + x2 - z2 - y2;
        this.m01 = xy + zw + zw + xy;
        this.m02 = xz - yw + xz - yw;
        this.m10 = -zw + xy - zw + xy;
        this.m11 = y2 - z2 + w2 - x2;
        this.m12 = yz + yz + xw + xw;
        this.m20 = yw + xz + xz + yw;
        this.m21 = yz + yz - xw - xw;
        this.m22 = z2 - y2 - x2 + w2;
        return this;
    }

    public Matrix3d rotation(Quaternionfc quat) {
        double w2 = quat.w() * quat.w();
        double x2 = quat.x() * quat.x();
        double y2 = quat.y() * quat.y();
        double z2 = quat.z() * quat.z();
        double zw = quat.z() * quat.w();
        double xy = quat.x() * quat.y();
        double xz = quat.x() * quat.z();
        double yw = quat.y() * quat.w();
        double yz = quat.y() * quat.z();
        double xw = quat.x() * quat.w();
        this.m00 = w2 + x2 - z2 - y2;
        this.m01 = xy + zw + zw + xy;
        this.m02 = xz - yw + xz - yw;
        this.m10 = -zw + xy - zw + xy;
        this.m11 = y2 - z2 + w2 - x2;
        this.m12 = yz + yz + xw + xw;
        this.m20 = yw + xz + xz + yw;
        this.m21 = yz + yz - xw - xw;
        this.m22 = z2 - y2 - x2 + w2;
        return this;
    }

    public Vector3d transform(Vector3d v) {
        return v.mul(this);
    }

    public Vector3d transform(Vector3dc v, Vector3d dest) {
        v.mul(this, dest);
        return dest;
    }

    public Vector3d transform(double x, double y, double z, Vector3d dest) {
        dest.set(this.m00 * x + this.m10 * y + this.m20 * z, this.m01 * x + this.m11 * y + this.m21 * z, this.m02 * x + this.m12 * y + this.m22 * z);
        return dest;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeDouble(this.m00);
        out.writeDouble(this.m01);
        out.writeDouble(this.m02);
        out.writeDouble(this.m10);
        out.writeDouble(this.m11);
        out.writeDouble(this.m12);
        out.writeDouble(this.m20);
        out.writeDouble(this.m21);
        out.writeDouble(this.m22);
    }

    public void readExternal(ObjectInput in) throws IOException {
        this.m00 = in.readDouble();
        this.m01 = in.readDouble();
        this.m02 = in.readDouble();
        this.m10 = in.readDouble();
        this.m11 = in.readDouble();
        this.m12 = in.readDouble();
        this.m20 = in.readDouble();
        this.m21 = in.readDouble();
        this.m22 = in.readDouble();
    }

    public Matrix3d rotateX(double ang, Matrix3d dest) {
        double sin;
        double cos;
        if (ang == java.lang.Math.PI || ang == -java.lang.Math.PI) {
            cos = -1.0;
            sin = 0.0;
        } else if (ang == 1.5707963267948966 || ang == -4.71238898038469) {
            cos = 0.0;
            sin = 1.0;
        } else if (ang == -1.5707963267948966 || ang == 4.71238898038469) {
            cos = 0.0;
            sin = -1.0;
        } else {
            sin = Math.sin(ang);
            cos = Math.cosFromSin(sin, ang);
        }
        double rm11 = cos;
        double rm21 = -sin;
        double rm12 = sin;
        double rm22 = cos;
        double nm10 = this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m12 * rm21 + this.m22 * rm22;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m00 = this.m00;
        dest.m01 = this.m01;
        dest.m02 = this.m02;
        return dest;
    }

    public Matrix3d rotateX(double ang) {
        return this.rotateX(ang, this);
    }

    public Matrix3d rotateY(double ang, Matrix3d dest) {
        double sin;
        double cos;
        if (ang == java.lang.Math.PI || ang == -java.lang.Math.PI) {
            cos = -1.0;
            sin = 0.0;
        } else if (ang == 1.5707963267948966 || ang == -4.71238898038469) {
            cos = 0.0;
            sin = 1.0;
        } else if (ang == -1.5707963267948966 || ang == 4.71238898038469) {
            cos = 0.0;
            sin = -1.0;
        } else {
            sin = Math.sin(ang);
            cos = Math.cosFromSin(sin, ang);
        }
        double rm00 = cos;
        double rm20 = sin;
        double rm02 = -sin;
        double rm22 = cos;
        double nm00 = this.m00 * rm00 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m22 * rm02;
        dest.m20 = this.m00 * rm20 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = this.m10;
        dest.m11 = this.m11;
        dest.m12 = this.m12;
        return dest;
    }

    public Matrix3d rotateY(double ang) {
        return this.rotateY(ang, this);
    }

    public Matrix3d rotateZ(double ang, Matrix3d dest) {
        double sin;
        double cos;
        if (ang == java.lang.Math.PI || ang == -java.lang.Math.PI) {
            cos = -1.0;
            sin = 0.0;
        } else if (ang == 1.5707963267948966 || ang == -4.71238898038469) {
            cos = 0.0;
            sin = 1.0;
        } else if (ang == -1.5707963267948966 || ang == 4.71238898038469) {
            cos = 0.0;
            sin = -1.0;
        } else {
            sin = Math.sin(ang);
            cos = Math.cosFromSin(sin, ang);
        }
        double rm00 = cos;
        double rm10 = -sin;
        double rm01 = sin;
        double rm11 = cos;
        double nm00 = this.m00 * rm00 + this.m10 * rm01;
        double nm01 = this.m01 * rm00 + this.m11 * rm01;
        double nm02 = this.m02 * rm00 + this.m12 * rm01;
        dest.m10 = this.m00 * rm10 + this.m10 * rm11;
        dest.m11 = this.m01 * rm10 + this.m11 * rm11;
        dest.m12 = this.m02 * rm10 + this.m12 * rm11;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m20 = this.m20;
        dest.m21 = this.m21;
        dest.m22 = this.m22;
        return dest;
    }

    public Matrix3d rotateZ(double ang) {
        return this.rotateZ(ang, this);
    }

    public Matrix3d rotateXYZ(double angleX, double angleY, double angleZ) {
        return this.rotateXYZ(angleX, angleY, angleZ, this);
    }

    public Matrix3d rotateXYZ(double angleX, double angleY, double angleZ, Matrix3d dest) {
        double sinX = Math.sin(angleX);
        double cosX = Math.cosFromSin(sinX, angleX);
        double sinY = Math.sin(angleY);
        double cosY = Math.cosFromSin(sinY, angleY);
        double sinZ = Math.sin(angleZ);
        double cosZ = Math.cosFromSin(sinZ, angleZ);
        double m_sinX = -sinX;
        double m_sinY = -sinY;
        double m_sinZ = -sinZ;
        double nm10 = this.m10 * cosX + this.m20 * sinX;
        double nm11 = this.m11 * cosX + this.m21 * sinX;
        double nm12 = this.m12 * cosX + this.m22 * sinX;
        double nm20 = this.m10 * m_sinX + this.m20 * cosX;
        double nm21 = this.m11 * m_sinX + this.m21 * cosX;
        double nm22 = this.m12 * m_sinX + this.m22 * cosX;
        double nm00 = this.m00 * cosY + nm20 * m_sinY;
        double nm01 = this.m01 * cosY + nm21 * m_sinY;
        double nm02 = this.m02 * cosY + nm22 * m_sinY;
        dest.m20 = this.m00 * sinY + nm20 * cosY;
        dest.m21 = this.m01 * sinY + nm21 * cosY;
        dest.m22 = this.m02 * sinY + nm22 * cosY;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return dest;
    }

    public Matrix3d rotateZYX(double angleZ, double angleY, double angleX) {
        return this.rotateZYX(angleZ, angleY, angleX, this);
    }

    public Matrix3d rotateZYX(double angleZ, double angleY, double angleX, Matrix3d dest) {
        double sinX = Math.sin(angleX);
        double cosX = Math.cosFromSin(sinX, angleX);
        double sinY = Math.sin(angleY);
        double cosY = Math.cosFromSin(sinY, angleY);
        double sinZ = Math.sin(angleZ);
        double cosZ = Math.cosFromSin(sinZ, angleZ);
        double m_sinZ = -sinZ;
        double m_sinY = -sinY;
        double m_sinX = -sinX;
        double nm00 = this.m00 * cosZ + this.m10 * sinZ;
        double nm01 = this.m01 * cosZ + this.m11 * sinZ;
        double nm02 = this.m02 * cosZ + this.m12 * sinZ;
        double nm10 = this.m00 * m_sinZ + this.m10 * cosZ;
        double nm11 = this.m01 * m_sinZ + this.m11 * cosZ;
        double nm12 = this.m02 * m_sinZ + this.m12 * cosZ;
        double nm20 = nm00 * sinY + this.m20 * cosY;
        double nm21 = nm01 * sinY + this.m21 * cosY;
        double nm22 = nm02 * sinY + this.m22 * cosY;
        dest.m00 = nm00 * cosY + this.m20 * m_sinY;
        dest.m01 = nm01 * cosY + this.m21 * m_sinY;
        dest.m02 = nm02 * cosY + this.m22 * m_sinY;
        dest.m10 = nm10 * cosX + nm20 * sinX;
        dest.m11 = nm11 * cosX + nm21 * sinX;
        dest.m12 = nm12 * cosX + nm22 * sinX;
        dest.m20 = nm10 * m_sinX + nm20 * cosX;
        dest.m21 = nm11 * m_sinX + nm21 * cosX;
        dest.m22 = nm12 * m_sinX + nm22 * cosX;
        return dest;
    }

    public Matrix3d rotateYXZ(Vector3d angles) {
        return this.rotateYXZ(angles.y, angles.x, angles.z);
    }

    public Matrix3d rotateYXZ(double angleY, double angleX, double angleZ) {
        return this.rotateYXZ(angleY, angleX, angleZ, this);
    }

    public Matrix3d rotateYXZ(double angleY, double angleX, double angleZ, Matrix3d dest) {
        double sinX = Math.sin(angleX);
        double cosX = Math.cosFromSin(sinX, angleX);
        double sinY = Math.sin(angleY);
        double cosY = Math.cosFromSin(sinY, angleY);
        double sinZ = Math.sin(angleZ);
        double cosZ = Math.cosFromSin(sinZ, angleZ);
        double m_sinY = -sinY;
        double m_sinX = -sinX;
        double m_sinZ = -sinZ;
        double nm20 = this.m00 * sinY + this.m20 * cosY;
        double nm21 = this.m01 * sinY + this.m21 * cosY;
        double nm22 = this.m02 * sinY + this.m22 * cosY;
        double nm00 = this.m00 * cosY + this.m20 * m_sinY;
        double nm01 = this.m01 * cosY + this.m21 * m_sinY;
        double nm02 = this.m02 * cosY + this.m22 * m_sinY;
        double nm10 = this.m10 * cosX + nm20 * sinX;
        double nm11 = this.m11 * cosX + nm21 * sinX;
        double nm12 = this.m12 * cosX + nm22 * sinX;
        dest.m20 = this.m10 * m_sinX + nm20 * cosX;
        dest.m21 = this.m11 * m_sinX + nm21 * cosX;
        dest.m22 = this.m12 * m_sinX + nm22 * cosX;
        dest.m00 = nm00 * cosZ + nm10 * sinZ;
        dest.m01 = nm01 * cosZ + nm11 * sinZ;
        dest.m02 = nm02 * cosZ + nm12 * sinZ;
        dest.m10 = nm00 * m_sinZ + nm10 * cosZ;
        dest.m11 = nm01 * m_sinZ + nm11 * cosZ;
        dest.m12 = nm02 * m_sinZ + nm12 * cosZ;
        return dest;
    }

    public Matrix3d rotate(double ang, double x, double y, double z) {
        return this.rotate(ang, x, y, z, this);
    }

    public Matrix3d rotate(double ang, double x, double y, double z, Matrix3d dest) {
        double s = Math.sin(ang);
        double c = Math.cosFromSin(s, ang);
        double C = 1.0 - c;
        double xx = x * x;
        double xy = x * y;
        double xz = x * z;
        double yy = y * y;
        double yz = y * z;
        double zz = z * z;
        double rm00 = xx * C + c;
        double rm01 = xy * C + z * s;
        double rm02 = xz * C - y * s;
        double rm10 = xy * C - z * s;
        double rm11 = yy * C + c;
        double rm12 = yz * C + x * s;
        double rm20 = xz * C + y * s;
        double rm21 = yz * C - x * s;
        double rm22 = zz * C + c;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3d rotateLocal(double ang, double x, double y, double z, Matrix3d dest) {
        double s = Math.sin(ang);
        double c = Math.cosFromSin(s, ang);
        double C = 1.0 - c;
        double xx = x * x;
        double xy = x * y;
        double xz = x * z;
        double yy = y * y;
        double yz = y * z;
        double zz = z * z;
        double lm00 = xx * C + c;
        double lm01 = xy * C + z * s;
        double lm02 = xz * C - y * s;
        double lm10 = xy * C - z * s;
        double lm11 = yy * C + c;
        double lm12 = yz * C + x * s;
        double lm20 = xz * C + y * s;
        double lm21 = yz * C - x * s;
        double lm22 = zz * C + c;
        double nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        double nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        double nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        double nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        double nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        double nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        double nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        double nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        double nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d rotateLocal(double ang, double x, double y, double z) {
        return this.rotateLocal(ang, x, y, z, this);
    }

    public Matrix3d rotateLocal(Quaterniondc quat, Matrix3d dest) {
        double w2 = quat.w() * quat.w();
        double x2 = quat.x() * quat.x();
        double y2 = quat.y() * quat.y();
        double z2 = quat.z() * quat.z();
        double zw = quat.z() * quat.w();
        double xy = quat.x() * quat.y();
        double xz = quat.x() * quat.z();
        double yw = quat.y() * quat.w();
        double yz = quat.y() * quat.z();
        double xw = quat.x() * quat.w();
        double lm00 = w2 + x2 - z2 - y2;
        double lm01 = xy + zw + zw + xy;
        double lm02 = xz - yw + xz - yw;
        double lm10 = -zw + xy - zw + xy;
        double lm11 = y2 - z2 + w2 - x2;
        double lm12 = yz + yz + xw + xw;
        double lm20 = yw + xz + xz + yw;
        double lm21 = yz + yz - xw - xw;
        double lm22 = z2 - y2 - x2 + w2;
        double nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        double nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        double nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        double nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        double nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        double nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        double nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        double nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        double nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d rotateLocal(Quaterniondc quat) {
        return this.rotateLocal(quat, this);
    }

    public Matrix3d rotateLocal(Quaternionfc quat, Matrix3d dest) {
        double w2 = quat.w() * quat.w();
        double x2 = quat.x() * quat.x();
        double y2 = quat.y() * quat.y();
        double z2 = quat.z() * quat.z();
        double zw = quat.z() * quat.w();
        double xy = quat.x() * quat.y();
        double xz = quat.x() * quat.z();
        double yw = quat.y() * quat.w();
        double yz = quat.y() * quat.z();
        double xw = quat.x() * quat.w();
        double lm00 = w2 + x2 - z2 - y2;
        double lm01 = xy + zw + zw + xy;
        double lm02 = xz - yw + xz - yw;
        double lm10 = -zw + xy - zw + xy;
        double lm11 = y2 - z2 + w2 - x2;
        double lm12 = yz + yz + xw + xw;
        double lm20 = yw + xz + xz + yw;
        double lm21 = yz + yz - xw - xw;
        double lm22 = z2 - y2 - x2 + w2;
        double nm00 = lm00 * this.m00 + lm10 * this.m01 + lm20 * this.m02;
        double nm01 = lm01 * this.m00 + lm11 * this.m01 + lm21 * this.m02;
        double nm02 = lm02 * this.m00 + lm12 * this.m01 + lm22 * this.m02;
        double nm10 = lm00 * this.m10 + lm10 * this.m11 + lm20 * this.m12;
        double nm11 = lm01 * this.m10 + lm11 * this.m11 + lm21 * this.m12;
        double nm12 = lm02 * this.m10 + lm12 * this.m11 + lm22 * this.m12;
        double nm20 = lm00 * this.m20 + lm10 * this.m21 + lm20 * this.m22;
        double nm21 = lm01 * this.m20 + lm11 * this.m21 + lm21 * this.m22;
        double nm22 = lm02 * this.m20 + lm12 * this.m21 + lm22 * this.m22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d rotateLocal(Quaternionfc quat) {
        return this.rotateLocal(quat, this);
    }

    public Matrix3d rotate(Quaterniondc quat) {
        return this.rotate(quat, this);
    }

    public Matrix3d rotate(Quaterniondc quat, Matrix3d dest) {
        double w2 = quat.w() * quat.w();
        double x2 = quat.x() * quat.x();
        double y2 = quat.y() * quat.y();
        double z2 = quat.z() * quat.z();
        double zw = quat.z() * quat.w();
        double xy = quat.x() * quat.y();
        double xz = quat.x() * quat.z();
        double yw = quat.y() * quat.w();
        double yz = quat.y() * quat.z();
        double xw = quat.x() * quat.w();
        double rm00 = w2 + x2 - z2 - y2;
        double rm01 = xy + zw + zw + xy;
        double rm02 = xz - yw + xz - yw;
        double rm10 = -zw + xy - zw + xy;
        double rm11 = y2 - z2 + w2 - x2;
        double rm12 = yz + yz + xw + xw;
        double rm20 = yw + xz + xz + yw;
        double rm21 = yz + yz - xw - xw;
        double rm22 = z2 - y2 - x2 + w2;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3d rotate(Quaternionfc quat) {
        return this.rotate(quat, this);
    }

    public Matrix3d rotate(Quaternionfc quat, Matrix3d dest) {
        double w2 = quat.w() * quat.w();
        double x2 = quat.x() * quat.x();
        double y2 = quat.y() * quat.y();
        double z2 = quat.z() * quat.z();
        double zw = quat.z() * quat.w();
        double xy = quat.x() * quat.y();
        double xz = quat.x() * quat.z();
        double yw = quat.y() * quat.w();
        double yz = quat.y() * quat.z();
        double xw = quat.x() * quat.w();
        double rm00 = w2 + x2 - z2 - y2;
        double rm01 = xy + zw + zw + xy;
        double rm02 = xz - yw + xz - yw;
        double rm10 = -zw + xy - zw + xy;
        double rm11 = y2 - z2 + w2 - x2;
        double rm12 = yz + yz + xw + xw;
        double rm20 = yw + xz + xz + yw;
        double rm21 = yz + yz - xw - xw;
        double rm22 = z2 - y2 - x2 + w2;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3d rotate(AxisAngle4f axisAngle) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix3d rotate(AxisAngle4f axisAngle, Matrix3d dest) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z, dest);
    }

    public Matrix3d rotate(AxisAngle4d axisAngle) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z);
    }

    public Matrix3d rotate(AxisAngle4d axisAngle, Matrix3d dest) {
        return this.rotate(axisAngle.angle, axisAngle.x, axisAngle.y, axisAngle.z, dest);
    }

    public Matrix3d rotate(double angle, Vector3dc axis) {
        return this.rotate(angle, axis.x(), axis.y(), axis.z());
    }

    public Matrix3d rotate(double angle, Vector3dc axis, Matrix3d dest) {
        return this.rotate(angle, axis.x(), axis.y(), axis.z(), dest);
    }

    public Matrix3d rotate(double angle, Vector3fc axis) {
        return this.rotate(angle, axis.x(), axis.y(), axis.z());
    }

    public Matrix3d rotate(double angle, Vector3fc axis, Matrix3d dest) {
        return this.rotate(angle, axis.x(), axis.y(), axis.z(), dest);
    }

    public Vector3d getRow(int row, Vector3d dest) throws IndexOutOfBoundsException {
        switch (row) {
            case 0: {
                dest.x = this.m00;
                dest.y = this.m10;
                dest.z = this.m20;
                break;
            }
            case 1: {
                dest.x = this.m01;
                dest.y = this.m11;
                dest.z = this.m21;
                break;
            }
            case 2: {
                dest.x = this.m02;
                dest.y = this.m12;
                dest.z = this.m22;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return dest;
    }

    public Matrix3d setRow(int row, Vector3dc src) throws IndexOutOfBoundsException {
        switch (row) {
            case 0: {
                this.m00 = src.x();
                this.m01 = src.y();
                this.m02 = src.z();
                break;
            }
            case 1: {
                this.m10 = src.x();
                this.m11 = src.y();
                this.m12 = src.z();
                break;
            }
            case 2: {
                this.m20 = src.x();
                this.m21 = src.y();
                this.m22 = src.z();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public Vector3d getColumn(int column, Vector3d dest) throws IndexOutOfBoundsException {
        switch (column) {
            case 0: {
                dest.x = this.m00;
                dest.y = this.m01;
                dest.z = this.m02;
                break;
            }
            case 1: {
                dest.x = this.m10;
                dest.y = this.m11;
                dest.z = this.m12;
                break;
            }
            case 2: {
                dest.x = this.m20;
                dest.y = this.m21;
                dest.z = this.m22;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return dest;
    }

    public Matrix3d setColumn(int column, Vector3dc src) throws IndexOutOfBoundsException {
        switch (column) {
            case 0: {
                this.m00 = src.x();
                this.m01 = src.y();
                this.m02 = src.z();
                break;
            }
            case 1: {
                this.m10 = src.x();
                this.m11 = src.y();
                this.m12 = src.z();
                break;
            }
            case 2: {
                this.m20 = src.x();
                this.m21 = src.y();
                this.m22 = src.z();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
        return this;
    }

    public Matrix3d normal() {
        return this.normal(this);
    }

    public Matrix3d normal(Matrix3d dest) {
        double m00m11 = this.m00 * this.m11;
        double m01m10 = this.m01 * this.m10;
        double m02m10 = this.m02 * this.m10;
        double m00m12 = this.m00 * this.m12;
        double m01m12 = this.m01 * this.m12;
        double m02m11 = this.m02 * this.m11;
        double det = (m00m11 - m01m10) * this.m22 + (m02m10 - m00m12) * this.m21 + (m01m12 - m02m11) * this.m20;
        double s = 1.0 / det;
        double nm00 = (this.m11 * this.m22 - this.m21 * this.m12) * s;
        double nm01 = (this.m20 * this.m12 - this.m10 * this.m22) * s;
        double nm02 = (this.m10 * this.m21 - this.m20 * this.m11) * s;
        double nm10 = (this.m21 * this.m02 - this.m01 * this.m22) * s;
        double nm11 = (this.m00 * this.m22 - this.m20 * this.m02) * s;
        double nm12 = (this.m20 * this.m01 - this.m00 * this.m21) * s;
        double nm20 = (m01m12 - m02m11) * s;
        double nm21 = (m02m10 - m00m12) * s;
        double nm22 = (m00m11 - m01m10) * s;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        dest.m20 = nm20;
        dest.m21 = nm21;
        dest.m22 = nm22;
        return dest;
    }

    public Matrix3d lookAlong(Vector3dc dir, Vector3dc up) {
        return this.lookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z(), this);
    }

    public Matrix3d lookAlong(Vector3dc dir, Vector3dc up, Matrix3d dest) {
        return this.lookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z(), dest);
    }

    public Matrix3d lookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ, Matrix3d dest) {
        double invDirLength = 1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        double dirnX = dirX * invDirLength;
        double dirnY = dirY * invDirLength;
        double dirnZ = dirZ * invDirLength;
        double rightX = dirnY * upZ - dirnZ * upY;
        double rightY = dirnZ * upX - dirnX * upZ;
        double rightZ = dirnX * upY - dirnY * upX;
        double invRightLength = 1.0 / Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ);
        double upnX = (rightY *= invRightLength) * dirnZ - (rightZ *= invRightLength) * dirnY;
        double upnY = rightZ * dirnX - (rightX *= invRightLength) * dirnZ;
        double upnZ = rightX * dirnY - rightY * dirnX;
        double rm00 = rightX;
        double rm01 = upnX;
        double rm02 = -dirnX;
        double rm10 = rightY;
        double rm11 = upnY;
        double rm12 = -dirnY;
        double rm20 = rightZ;
        double rm21 = upnZ;
        double rm22 = -dirnZ;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3d lookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ) {
        return this.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Matrix3d setLookAlong(Vector3dc dir, Vector3dc up) {
        return this.setLookAlong(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z());
    }

    public Matrix3d setLookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ) {
        double invDirLength = 1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        double dirnX = dirX * invDirLength;
        double dirnY = dirY * invDirLength;
        double dirnZ = dirZ * invDirLength;
        double rightX = dirnY * upZ - dirnZ * upY;
        double rightY = dirnZ * upX - dirnX * upZ;
        double rightZ = dirnX * upY - dirnY * upX;
        double invRightLength = 1.0 / Math.sqrt(rightX * rightX + rightY * rightY + rightZ * rightZ);
        double upnX = (rightY *= invRightLength) * dirnZ - (rightZ *= invRightLength) * dirnY;
        double upnY = rightZ * dirnX - (rightX *= invRightLength) * dirnZ;
        double upnZ = rightX * dirnY - rightY * dirnX;
        this.m00 = rightX;
        this.m01 = upnX;
        this.m02 = -dirnX;
        this.m10 = rightY;
        this.m11 = upnY;
        this.m12 = -dirnY;
        this.m20 = rightZ;
        this.m21 = upnZ;
        this.m22 = -dirnZ;
        return this;
    }

    public Vector3d getScale(Vector3d dest) {
        dest.x = Math.sqrt(this.m00 * this.m00 + this.m01 * this.m01 + this.m02 * this.m02);
        dest.y = Math.sqrt(this.m10 * this.m10 + this.m11 * this.m11 + this.m12 * this.m12);
        dest.z = Math.sqrt(this.m20 * this.m20 + this.m21 * this.m21 + this.m22 * this.m22);
        return dest;
    }

    public Vector3d positiveZ(Vector3d dir) {
        dir.x = this.m10 * this.m21 - this.m11 * this.m20;
        dir.y = this.m20 * this.m01 - this.m21 * this.m00;
        dir.z = this.m00 * this.m11 - this.m01 * this.m10;
        dir.normalize();
        return dir;
    }

    public Vector3d normalizedPositiveZ(Vector3d dir) {
        dir.x = this.m02;
        dir.y = this.m12;
        dir.z = this.m22;
        return dir;
    }

    public Vector3d positiveX(Vector3d dir) {
        dir.x = this.m11 * this.m22 - this.m12 * this.m21;
        dir.y = this.m02 * this.m21 - this.m01 * this.m22;
        dir.z = this.m01 * this.m12 - this.m02 * this.m11;
        dir.normalize();
        return dir;
    }

    public Vector3d normalizedPositiveX(Vector3d dir) {
        dir.x = this.m00;
        dir.y = this.m10;
        dir.z = this.m20;
        return dir;
    }

    public Vector3d positiveY(Vector3d dir) {
        dir.x = this.m12 * this.m20 - this.m10 * this.m22;
        dir.y = this.m00 * this.m22 - this.m02 * this.m20;
        dir.z = this.m02 * this.m10 - this.m00 * this.m12;
        dir.normalize();
        return dir;
    }

    public Vector3d normalizedPositiveY(Vector3d dir) {
        dir.x = this.m01;
        dir.y = this.m11;
        dir.z = this.m21;
        return dir;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.m00);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m01);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m02);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m10);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m11);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m12);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m20);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m21);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.m22);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Matrix3d other = (Matrix3d)obj;
        if (Double.doubleToLongBits(this.m00) != Double.doubleToLongBits(other.m00)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m01) != Double.doubleToLongBits(other.m01)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m02) != Double.doubleToLongBits(other.m02)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m10) != Double.doubleToLongBits(other.m10)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m11) != Double.doubleToLongBits(other.m11)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m12) != Double.doubleToLongBits(other.m12)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m20) != Double.doubleToLongBits(other.m20)) {
            return false;
        }
        if (Double.doubleToLongBits(this.m21) != Double.doubleToLongBits(other.m21)) {
            return false;
        }
        return Double.doubleToLongBits(this.m22) == Double.doubleToLongBits(other.m22);
    }

    public Matrix3d swap(Matrix3d other) {
        double tmp = this.m00;
        this.m00 = other.m00;
        other.m00 = tmp;
        tmp = this.m01;
        this.m01 = other.m01;
        other.m01 = tmp;
        tmp = this.m02;
        this.m02 = other.m02;
        other.m02 = tmp;
        tmp = this.m10;
        this.m10 = other.m10;
        other.m10 = tmp;
        tmp = this.m11;
        this.m11 = other.m11;
        other.m11 = tmp;
        tmp = this.m12;
        this.m12 = other.m12;
        other.m12 = tmp;
        tmp = this.m20;
        this.m20 = other.m20;
        other.m20 = tmp;
        tmp = this.m21;
        this.m21 = other.m21;
        other.m21 = tmp;
        tmp = this.m22;
        this.m22 = other.m22;
        other.m22 = tmp;
        return this;
    }

    public Matrix3d add(Matrix3dc other) {
        return this.add(other, this);
    }

    public Matrix3d add(Matrix3dc other, Matrix3d dest) {
        dest.m00 = this.m00 + other.m00();
        dest.m01 = this.m01 + other.m01();
        dest.m02 = this.m02 + other.m02();
        dest.m10 = this.m10 + other.m10();
        dest.m11 = this.m11 + other.m11();
        dest.m12 = this.m12 + other.m12();
        dest.m20 = this.m20 + other.m20();
        dest.m21 = this.m21 + other.m21();
        dest.m22 = this.m22 + other.m22();
        return dest;
    }

    public Matrix3d sub(Matrix3dc subtrahend) {
        return this.sub(subtrahend, this);
    }

    public Matrix3d sub(Matrix3dc subtrahend, Matrix3d dest) {
        dest.m00 = this.m00 - subtrahend.m00();
        dest.m01 = this.m01 - subtrahend.m01();
        dest.m02 = this.m02 - subtrahend.m02();
        dest.m10 = this.m10 - subtrahend.m10();
        dest.m11 = this.m11 - subtrahend.m11();
        dest.m12 = this.m12 - subtrahend.m12();
        dest.m20 = this.m20 - subtrahend.m20();
        dest.m21 = this.m21 - subtrahend.m21();
        dest.m22 = this.m22 - subtrahend.m22();
        return dest;
    }

    public Matrix3d mulComponentWise(Matrix3dc other) {
        return this.mulComponentWise(other, this);
    }

    public Matrix3d mulComponentWise(Matrix3dc other, Matrix3d dest) {
        dest.m00 = this.m00 * other.m00();
        dest.m01 = this.m01 * other.m01();
        dest.m02 = this.m02 * other.m02();
        dest.m10 = this.m10 * other.m10();
        dest.m11 = this.m11 * other.m11();
        dest.m12 = this.m12 * other.m12();
        dest.m20 = this.m20 * other.m20();
        dest.m21 = this.m21 * other.m21();
        dest.m22 = this.m22 * other.m22();
        return dest;
    }

    public Matrix3d setSkewSymmetric(double a, double b, double c) {
        this.m22 = 0.0;
        this.m11 = 0.0;
        this.m00 = 0.0;
        this.m01 = -a;
        this.m02 = b;
        this.m10 = a;
        this.m12 = -c;
        this.m20 = -b;
        this.m21 = c;
        return this;
    }

    public Matrix3d lerp(Matrix3dc other, double t) {
        return this.lerp(other, t, this);
    }

    public Matrix3d lerp(Matrix3dc other, double t, Matrix3d dest) {
        dest.m00 = this.m00 + (other.m00() - this.m00) * t;
        dest.m01 = this.m01 + (other.m01() - this.m01) * t;
        dest.m02 = this.m02 + (other.m02() - this.m02) * t;
        dest.m10 = this.m10 + (other.m10() - this.m10) * t;
        dest.m11 = this.m11 + (other.m11() - this.m11) * t;
        dest.m12 = this.m12 + (other.m12() - this.m12) * t;
        dest.m20 = this.m20 + (other.m20() - this.m20) * t;
        dest.m21 = this.m21 + (other.m21() - this.m21) * t;
        dest.m22 = this.m22 + (other.m22() - this.m22) * t;
        return dest;
    }

    public Matrix3d rotateTowards(Vector3dc direction, Vector3dc up, Matrix3d dest) {
        return this.rotateTowards(direction.x(), direction.y(), direction.z(), up.x(), up.y(), up.z(), dest);
    }

    public Matrix3d rotateTowards(Vector3dc direction, Vector3dc up) {
        return this.rotateTowards(direction.x(), direction.y(), direction.z(), up.x(), up.y(), up.z(), this);
    }

    public Matrix3d rotateTowards(double dirX, double dirY, double dirZ, double upX, double upY, double upZ) {
        return this.rotateTowards(dirX, dirY, dirZ, upX, upY, upZ, this);
    }

    public Matrix3d rotateTowards(double dirX, double dirY, double dirZ, double upX, double upY, double upZ, Matrix3d dest) {
        double invDirLength = 1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        double ndirX = dirX * invDirLength;
        double ndirY = dirY * invDirLength;
        double ndirZ = dirZ * invDirLength;
        double leftX = upY * ndirZ - upZ * ndirY;
        double leftY = upZ * ndirX - upX * ndirZ;
        double leftZ = upX * ndirY - upY * ndirX;
        double invLeftLength = 1.0 / Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        double upnX = ndirY * (leftZ *= invLeftLength) - ndirZ * (leftY *= invLeftLength);
        double upnY = ndirZ * (leftX *= invLeftLength) - ndirX * leftZ;
        double upnZ = ndirX * leftY - ndirY * leftX;
        double rm00 = leftX;
        double rm01 = leftY;
        double rm02 = leftZ;
        double rm10 = upnX;
        double rm11 = upnY;
        double rm12 = upnZ;
        double rm20 = ndirX;
        double rm21 = ndirY;
        double rm22 = ndirZ;
        double nm00 = this.m00 * rm00 + this.m10 * rm01 + this.m20 * rm02;
        double nm01 = this.m01 * rm00 + this.m11 * rm01 + this.m21 * rm02;
        double nm02 = this.m02 * rm00 + this.m12 * rm01 + this.m22 * rm02;
        double nm10 = this.m00 * rm10 + this.m10 * rm11 + this.m20 * rm12;
        double nm11 = this.m01 * rm10 + this.m11 * rm11 + this.m21 * rm12;
        double nm12 = this.m02 * rm10 + this.m12 * rm11 + this.m22 * rm12;
        dest.m20 = this.m00 * rm20 + this.m10 * rm21 + this.m20 * rm22;
        dest.m21 = this.m01 * rm20 + this.m11 * rm21 + this.m21 * rm22;
        dest.m22 = this.m02 * rm20 + this.m12 * rm21 + this.m22 * rm22;
        dest.m00 = nm00;
        dest.m01 = nm01;
        dest.m02 = nm02;
        dest.m10 = nm10;
        dest.m11 = nm11;
        dest.m12 = nm12;
        return dest;
    }

    public Matrix3d rotationTowards(Vector3dc dir, Vector3dc up) {
        return this.rotationTowards(dir.x(), dir.y(), dir.z(), up.x(), up.y(), up.z());
    }

    public Matrix3d rotationTowards(double dirX, double dirY, double dirZ, double upX, double upY, double upZ) {
        double invDirLength = 1.0 / Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
        double ndirX = dirX * invDirLength;
        double ndirY = dirY * invDirLength;
        double ndirZ = dirZ * invDirLength;
        double leftX = upY * ndirZ - upZ * ndirY;
        double leftY = upZ * ndirX - upX * ndirZ;
        double leftZ = upX * ndirY - upY * ndirX;
        double invLeftLength = 1.0 / Math.sqrt(leftX * leftX + leftY * leftY + leftZ * leftZ);
        double upnX = ndirY * (leftZ *= invLeftLength) - ndirZ * (leftY *= invLeftLength);
        double upnY = ndirZ * (leftX *= invLeftLength) - ndirX * leftZ;
        double upnZ = ndirX * leftY - ndirY * leftX;
        this.m00 = leftX;
        this.m01 = leftY;
        this.m02 = leftZ;
        this.m10 = upnX;
        this.m11 = upnY;
        this.m12 = upnZ;
        this.m20 = ndirX;
        this.m21 = ndirY;
        this.m22 = ndirZ;
        return this;
    }

    public Vector3d getEulerAnglesZYX(Vector3d dest) {
        dest.x = (float)Math.atan2(this.m12, this.m22);
        dest.y = (float)Math.atan2(-this.m02, Math.sqrt(this.m12 * this.m12 + this.m22 * this.m22));
        dest.z = (float)Math.atan2(this.m01, this.m00);
        return dest;
    }

    public Matrix3dc toImmutable() {
        if (!Options.DEBUG) {
            return this;
        }
        return new Proxy(this);
    }

    private final class Proxy
    implements Matrix3dc {
        private final Matrix3dc delegate;

        Proxy(Matrix3dc delegate) {
            this.delegate = delegate;
        }

        public double m00() {
            return this.delegate.m00();
        }

        public double m01() {
            return this.delegate.m01();
        }

        public double m02() {
            return this.delegate.m02();
        }

        public double m10() {
            return this.delegate.m10();
        }

        public double m11() {
            return this.delegate.m11();
        }

        public double m12() {
            return this.delegate.m12();
        }

        public double m20() {
            return this.delegate.m20();
        }

        public double m21() {
            return this.delegate.m21();
        }

        public double m22() {
            return this.delegate.m22();
        }

        public Matrix3d mul(Matrix3dc right, Matrix3d dest) {
            return this.delegate.mul(right, dest);
        }

        public Matrix3d mul(Matrix3fc right, Matrix3d dest) {
            return this.delegate.mul(right, dest);
        }

        public double determinant() {
            return this.delegate.determinant();
        }

        public Matrix3d invert(Matrix3d dest) {
            return this.delegate.invert(dest);
        }

        public Matrix3d transpose(Matrix3d dest) {
            return this.delegate.transpose(dest);
        }

        public Matrix3d get(Matrix3d dest) {
            return this.delegate.get(dest);
        }

        public AxisAngle4f getRotation(AxisAngle4f dest) {
            return this.delegate.getRotation(dest);
        }

        public Quaternionf getUnnormalizedRotation(Quaternionf dest) {
            return this.delegate.getUnnormalizedRotation(dest);
        }

        public Quaternionf getNormalizedRotation(Quaternionf dest) {
            return this.delegate.getNormalizedRotation(dest);
        }

        public Quaterniond getUnnormalizedRotation(Quaterniond dest) {
            return this.delegate.getUnnormalizedRotation(dest);
        }

        public Quaterniond getNormalizedRotation(Quaterniond dest) {
            return this.delegate.getNormalizedRotation(dest);
        }

        public DoubleBuffer get(DoubleBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public DoubleBuffer get(int index, DoubleBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public FloatBuffer get(FloatBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public FloatBuffer get(int index, FloatBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public ByteBuffer get(ByteBuffer buffer) {
            return this.delegate.get(buffer);
        }

        public ByteBuffer get(int index, ByteBuffer buffer) {
            return this.delegate.get(index, buffer);
        }

        public ByteBuffer getFloats(ByteBuffer buffer) {
            return this.delegate.getFloats(buffer);
        }

        public ByteBuffer getFloats(int index, ByteBuffer buffer) {
            return this.delegate.getFloats(index, buffer);
        }

        public double[] get(double[] arr, int offset) {
            return this.delegate.get(arr, offset);
        }

        public double[] get(double[] arr) {
            return this.delegate.get(arr);
        }

        public float[] get(float[] arr, int offset) {
            return this.delegate.get(arr, offset);
        }

        public float[] get(float[] arr) {
            return this.delegate.get(arr);
        }

        public Matrix3d scale(Vector3dc xyz, Matrix3d dest) {
            return this.delegate.scale(xyz, dest);
        }

        public Matrix3d scale(double x, double y, double z, Matrix3d dest) {
            return this.delegate.scale(x, y, z, dest);
        }

        public Matrix3d scale(double xyz, Matrix3d dest) {
            return this.delegate.scale(xyz, dest);
        }

        public Matrix3d scaleLocal(double x, double y, double z, Matrix3d dest) {
            return this.delegate.scaleLocal(x, y, z, dest);
        }

        public Vector3d transform(Vector3d v) {
            return this.delegate.transform(v);
        }

        public Vector3d transform(Vector3dc v, Vector3d dest) {
            return this.delegate.transform(v, dest);
        }

        public Vector3d transform(double x, double y, double z, Vector3d dest) {
            return this.delegate.transform(x, y, z, dest);
        }

        public Matrix3d rotateX(double ang, Matrix3d dest) {
            return this.delegate.rotateX(ang, dest);
        }

        public Matrix3d rotateY(double ang, Matrix3d dest) {
            return this.delegate.rotateY(ang, dest);
        }

        public Matrix3d rotateZ(double ang, Matrix3d dest) {
            return this.delegate.rotateZ(ang, dest);
        }

        public Matrix3d rotateXYZ(double angleX, double angleY, double angleZ, Matrix3d dest) {
            return this.delegate.rotateXYZ(angleX, angleY, angleZ, dest);
        }

        public Matrix3d rotateZYX(double angleZ, double angleY, double angleX, Matrix3d dest) {
            return this.delegate.rotateZYX(angleZ, angleY, angleX, dest);
        }

        public Matrix3d rotateYXZ(double angleY, double angleX, double angleZ, Matrix3d dest) {
            return this.delegate.rotateYXZ(angleY, angleX, angleZ, dest);
        }

        public Matrix3d rotate(double ang, double x, double y, double z, Matrix3d dest) {
            return this.delegate.rotate(ang, x, y, z, dest);
        }

        public Matrix3d rotateLocal(double ang, double x, double y, double z, Matrix3d dest) {
            return this.delegate.rotateLocal(ang, x, y, z, dest);
        }

        public Matrix3d rotateLocal(Quaterniondc quat, Matrix3d dest) {
            return this.delegate.rotateLocal(quat, dest);
        }

        public Matrix3d rotateLocal(Quaternionfc quat, Matrix3d dest) {
            return this.delegate.rotateLocal(quat, dest);
        }

        public Matrix3d rotate(Quaterniondc quat, Matrix3d dest) {
            return this.delegate.rotate(quat, dest);
        }

        public Matrix3d rotate(Quaternionfc quat, Matrix3d dest) {
            return this.delegate.rotate(quat, dest);
        }

        public Matrix3d rotate(AxisAngle4f axisAngle, Matrix3d dest) {
            return this.delegate.rotate(axisAngle, dest);
        }

        public Matrix3d rotate(AxisAngle4d axisAngle, Matrix3d dest) {
            return this.delegate.rotate(axisAngle, dest);
        }

        public Matrix3d rotate(double angle, Vector3dc axis, Matrix3d dest) {
            return this.delegate.rotate(angle, axis, dest);
        }

        public Matrix3d rotate(double angle, Vector3fc axis, Matrix3d dest) {
            return this.delegate.rotate(angle, axis, dest);
        }

        public Vector3d getRow(int row, Vector3d dest) throws IndexOutOfBoundsException {
            return this.delegate.getRow(row, dest);
        }

        public Vector3d getColumn(int column, Vector3d dest) throws IndexOutOfBoundsException {
            return this.delegate.getColumn(column, dest);
        }

        public Matrix3d normal(Matrix3d dest) {
            return this.delegate.normal(dest);
        }

        public Matrix3d lookAlong(Vector3dc dir, Vector3dc up, Matrix3d dest) {
            return this.delegate.lookAlong(dir, up, dest);
        }

        public Matrix3d lookAlong(double dirX, double dirY, double dirZ, double upX, double upY, double upZ, Matrix3d dest) {
            return this.delegate.lookAlong(dirX, dirY, dirZ, upX, upY, upZ, dest);
        }

        public Vector3d getScale(Vector3d dest) {
            return this.delegate.getScale(dest);
        }

        public Vector3d positiveZ(Vector3d dir) {
            return this.delegate.positiveZ(dir);
        }

        public Vector3d normalizedPositiveZ(Vector3d dir) {
            return this.delegate.normalizedPositiveZ(dir);
        }

        public Vector3d positiveX(Vector3d dir) {
            return this.delegate.positiveX(dir);
        }

        public Vector3d normalizedPositiveX(Vector3d dir) {
            return this.delegate.normalizedPositiveX(dir);
        }

        public Vector3d positiveY(Vector3d dir) {
            return this.delegate.positiveY(dir);
        }

        public Vector3d normalizedPositiveY(Vector3d dir) {
            return this.delegate.normalizedPositiveY(dir);
        }

        public Matrix3d add(Matrix3dc other, Matrix3d dest) {
            return this.delegate.add(other, dest);
        }

        public Matrix3d sub(Matrix3dc subtrahend, Matrix3d dest) {
            return this.delegate.sub(subtrahend, dest);
        }

        public Matrix3d mulComponentWise(Matrix3dc other, Matrix3d dest) {
            return this.delegate.mulComponentWise(other, dest);
        }

        public Matrix3d lerp(Matrix3dc other, double t, Matrix3d dest) {
            return this.delegate.lerp(other, t, dest);
        }

        public Matrix3d rotateTowards(Vector3dc direction, Vector3dc up, Matrix3d dest) {
            return this.delegate.rotateTowards(direction, up, dest);
        }

        public Matrix3d rotateTowards(double dirX, double dirY, double dirZ, double upX, double upY, double upZ, Matrix3d dest) {
            return this.delegate.rotateTowards(dirX, dirY, dirZ, upX, upY, upZ, dest);
        }

        public Vector3d getEulerAnglesZYX(Vector3d dest) {
            return this.delegate.getEulerAnglesZYX(dest);
        }
    }
}

