/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.render.block;

import com.google.common.collect.ImmutableList;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.render.block.IBlockRenderingHandler;
import com.infinityraider.infinitylib.render.item.BakedInfItemModel;
import com.infinityraider.infinitylib.render.tessellation.TessellatorBakedQuad;
import com.infinityraider.infinitylib.utility.HashableBlockState;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class BakedInfBlockModel<B extends BlockBase>
implements IBakedModel {
    @Nonnull
    private final B block;
    @Nonnull
    private final VertexFormat format;
    @Nonnull
    private final IBlockRenderingHandler<B> renderer;
    @Nonnull
    private final Function<ResourceLocation, TextureAtlasSprite> textureFunction;
    @Nullable
    private final BakedInfItemModel itemRenderer;
    @Nonnull
    private final Map<HashableBlockState, ImmutableList<BakedQuad>> cachedQuads;

    BakedInfBlockModel(@Nonnull B block, @Nonnull VertexFormat format, @Nonnull IBlockRenderingHandler<B> renderer, @Nonnull Function<ResourceLocation, TextureAtlasSprite> textureFunction, boolean hasInventoryRendering) {
        this.block = (BlockBase)Objects.requireNonNull(block, "The block for a BakedInfBlockModel must not be null!");
        this.format = Objects.requireNonNull(format, "The vertex format for a BakedInfBlockModel must not be null!");
        this.renderer = Objects.requireNonNull(renderer, "The renderer for a BakedInfBlockModel must not be null!");
        this.textureFunction = Objects.requireNonNull(textureFunction, "The texture provider for a BakedInfBlockModel must not be null!");
        this.itemRenderer = hasInventoryRendering ? new BakedInfItemModel(format, this.renderer, textureFunction) : null;
        this.cachedQuads = new HashMap<HashableBlockState, ImmutableList<BakedQuad>>();
    }

    @Nonnull
    public ImmutableList<BakedQuad> getQuads(IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.cachedQuads.computeIfAbsent(new HashableBlockState(state, side), key -> this.createQuads(state, side, rand));
    }

    @Nonnull
    private ImmutableList<BakedQuad> createQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        TessellatorBakedQuad tessellator = TessellatorBakedQuad.getInstance();
        tessellator.setCurrentFace(side);
        tessellator.setTextureFunction(this.textureFunction);
        tessellator.startDrawingQuads(this.format);
        this.renderer.renderWorldBlockStatic(tessellator, state, this.block, side);
        ImmutableList<BakedQuad> result = tessellator.getQuads();
        tessellator.draw();
        return result;
    }

    public boolean func_177555_b() {
        return this.renderer.applyAmbientOcclusion();
    }

    public boolean func_177556_c() {
        return this.renderer.doInventoryRendering();
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.renderer.getIcon();
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        if (this.itemRenderer != null) {
            return this.itemRenderer.func_188617_f();
        }
        return ItemOverrideList.field_188022_a;
    }
}

