/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.specialpotioneffect;

import com.google.common.primitives.Ints;
import com.infinityraider.infinitylib.modules.specialpotioneffect.MessageSyncPotions;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;

public class PotionTracker
implements ISerializable {
    private final EntityLivingBase entity;
    private Set<Integer> activeEffects = new HashSet<Integer>();

    protected PotionTracker(EntityLivingBase entity) {
        this.entity = entity;
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }

    public void updatePotionEffects(List<Potion> potions) {
        boolean update = false;
        Iterator<Integer> it = this.activeEffects.iterator();
        while (it.hasNext()) {
            int id = it.next();
            Potion potion = Potion.func_188412_a((int)id);
            if (!potions.contains(potion)) {
                it.remove();
                update = true;
                continue;
            }
            potions.remove(potion);
        }
        if (potions.size() > 0) {
            this.activeEffects.addAll(potions.stream().map(Potion::func_188409_a).collect(Collectors.toList()));
            update = true;
        }
        if (update) {
            this.syncToClient();
        }
    }

    public List<Potion> getActivePotions() {
        return this.activeEffects.stream().map(Potion::func_188412_a).collect(Collectors.toList());
    }

    protected void syncToClient() {
        new MessageSyncPotions(this).sendToAll();
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.activeEffects.clear();
        if (tag.func_74764_b("IL_POTIONS")) {
            this.activeEffects = Arrays.stream(tag.func_74759_k("IL_POTIONS")).boxed().collect(Collectors.toSet());
        }
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("IL_POTIONS", Ints.toArray(this.activeEffects));
        return tag;
    }
}

