/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.spawn;

import crazypants.enderio.base.Log;
import crazypants.enderio.zoo.spawn.IBiomeFilter;
import crazypants.enderio.zoo.spawn.ISpawnEntry;
import crazypants.enderio.zoo.spawn.SpawnConfig;
import crazypants.enderio.zoo.spawn.impl.SpawnEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public final class MobSpawns {
    public static final MobSpawns instance = new MobSpawns();
    private final List<ISpawnEntry> spawnEntries = new ArrayList<ISpawnEntry>();

    private MobSpawns() {
    }

    public void loadSpawnConfig() {
        List<SpawnEntry> entries = SpawnConfig.loadSpawnConfig();
        if (entries != null) {
            Log.info((Object[])new Object[]{"Applying " + entries.size() + " spawn entries from config."});
            for (SpawnEntry entry : entries) {
                this.addSpawn(entry);
            }
        } else {
            Log.info((Object[])new Object[]{"No spawn entries found in config."});
        }
    }

    public void addSpawn(ISpawnEntry entry) {
        if (entry == null) {
            return;
        }
        this.spawnEntries.add(entry);
        String mobname = entry.getMobName();
        if (mobname == null) {
            Log.warn((Object[])new Object[]{"Skipping spawn entry " + entry.getId() + " as mob name is null"});
            return;
        }
        Class clz = EntityList.getClass((ResourceLocation)new ResourceLocation(mobname));
        if (clz == null) {
            Log.warn((Object[])new Object[]{"Skipping spawn entry " + entry.getId() + " as mob " + entry.getMobName() + " is not registered"});
            return;
        }
        if (entry.isRemove()) {
            Log.debug((Object[])new Object[]{"EnderIO.MobSpawns.addSpawn: Removing spawns defined in entry: ", entry, " for biomes: "});
            for (IBiomeFilter filter : entry.getFilters()) {
                Biome[] biomes = filter.getMatchedBiomes();
                MobSpawns.printBiomeNames(biomes);
                EntityRegistry.removeSpawn((Class)clz, (EnumCreatureType)entry.getCreatureType(), (Biome[])biomes);
            }
            return;
        }
        Log.debug((Object[])new Object[]{"MobSpawns.addSpawn: Adding spawns defined in entry: ", entry, " for biomes: "});
        for (IBiomeFilter filter : entry.getFilters()) {
            Biome[] biomes = filter.getMatchedBiomes();
            MobSpawns.printBiomeNames(biomes);
            EntityRegistry.addSpawn((Class)clz, (int)entry.getRate(), (int)entry.getMinGroupSize(), (int)entry.getMaxGroupSize(), (EnumCreatureType)entry.getCreatureType(), (Biome[])biomes);
        }
    }

    protected static void printBiomeNames(Biome[] biomes) {
        for (Biome biome : biomes) {
            if (biome != null) {
                Log.debug((Object[])new Object[]{" - ", biome.getRegistryName()});
                continue;
            }
            Log.debug((Object[])new Object[]{" - null"});
        }
    }

    public Collection<ISpawnEntry> getEntries() {
        return this.spawnEntries;
    }
}

