/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity.ai;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import info.loenwind.autoconfig.factory.IValue;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAINearestAttackableTargetBounded<T extends EntityLivingBase>
extends EntityAINearestAttackableTarget<T> {
    private IValue<Double> distanceOverride = null;
    private final int targetChance;
    private IValue<Double> vertDistOverride = null;

    public EntityAINearestAttackableTargetBounded(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAINearestAttackableTargetBounded(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestAttackableTargetBounded(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super T> targetSelector) {
        super(creature, classTarget, chance, checkSight, onlyNearby, targetSelector);
        this.targetChance = chance;
    }

    @Nonnull
    public EntityAINearestAttackableTargetBounded<T> setMaxDistanceToTarget(@Nonnull IValue<Double> distance) {
        this.distanceOverride = distance;
        return this;
    }

    @Nonnull
    public EntityAINearestAttackableTargetBounded<T> setMaxVerticalDistanceToTarget(@Nonnull IValue<Double> vertDist) {
        this.vertDistOverride = vertDist;
        return this;
    }

    protected double func_111175_f() {
        if (this.distanceOverride != null) {
            return (Double)this.distanceOverride.get();
        }
        return super.func_111175_f();
    }

    public boolean func_75250_a() {
        if (this.func_111175_f() > 0.0 && (this.targetChance <= 0 || this.field_75299_d.func_70681_au().nextInt(this.targetChance) == 0)) {
            EntityLivingBase t;
            double horizDist = this.func_111175_f();
            double vertDist = this.getVerticalDistance();
            AxisAlignedBB bb = this.field_75299_d.func_174813_aQ().func_72321_a(horizDist, vertDist, horizDist);
            List list = this.field_75299_d.func_130014_f_().func_175647_a(this.field_75307_b, bb, Predicates.and((Predicate)this.field_82643_g, (Predicate)EntitySelectors.field_180132_d));
            Collections.sort(list, this.field_75306_g);
            if (!list.isEmpty() && (t = (EntityLivingBase)list.get(0)) != null) {
                this.field_75309_a = t;
                return true;
            }
        }
        return false;
    }

    private double getVerticalDistance() {
        if (this.vertDistOverride != null) {
            return (Double)this.vertDistOverride.get();
        }
        return 4.0;
    }
}

