/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity.ai;

import crazypants.enderio.zoo.entity.EntityUtil;
import crazypants.enderio.zoo.entity.SpawnUtil;
import info.loenwind.autoconfig.factory.IValue;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityAIMountedArrowAttack
extends EntityAIBase {
    @Nonnull
    private final EntityLiving entityHost;
    @Nonnull
    private final IRangedAttackMob rangedAttackEntityHost;
    private EntityLivingBase attackTarget;
    private IValue<Double> entityMoveSpeed;
    private IValue<Double> mountedEntityMoveSpeed;
    private int timeUntilNextAttack = -1;
    private int timeTargetVisible;
    private IValue<Integer> minRangedAttackTime;
    private IValue<Integer> maxRangedAttackTime;
    private IValue<Float> attackRange;
    private int runAwayTimer = 0;
    private PathPoint runningAwayTo;
    private IValue<Boolean> useRunAwayTactic;

    public EntityAIMountedArrowAttack(@Nonnull IRangedAttackMob host, IValue<Double> moveSpeed, IValue<Double> mountedEntityMoveSpeed, IValue<Integer> minAttackTime, IValue<Integer> maxAttackTime, IValue<Float> attackRange, IValue<Boolean> useRunAwayTactic) {
        this.rangedAttackEntityHost = host;
        this.entityHost = (EntityLiving)host;
        this.entityMoveSpeed = moveSpeed;
        this.mountedEntityMoveSpeed = mountedEntityMoveSpeed;
        this.minRangedAttackTime = minAttackTime;
        this.maxRangedAttackTime = maxAttackTime;
        this.attackRange = attackRange;
        this.useRunAwayTactic = useRunAwayTactic;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase toAttack = this.entityHost.func_70638_az();
        if (toAttack == null) {
            return false;
        }
        this.attackTarget = toAttack;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.getNavigator().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.timeTargetVisible = 0;
        this.timeUntilNextAttack = -1;
        this.runAwayTimer = 0;
        this.runningAwayTo = null;
    }

    public void func_75246_d() {
        EntityLivingBase attackTarget2 = this.attackTarget;
        if (attackTarget2 == null) {
            return;
        }
        double distToTargetSq = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, attackTarget2.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean canSeeTarget = this.entityHost.func_70635_at().func_75522_a((Entity)attackTarget2);
        this.timeTargetVisible = canSeeTarget ? ++this.timeTargetVisible : 0;
        boolean runningAway = this.isRunningAway();
        if (!runningAway) {
            --this.runAwayTimer;
        }
        float attackRangeSq = ((Float)this.attackRange.get()).floatValue() * ((Float)this.attackRange.get()).floatValue();
        if (!runningAway && distToTargetSq <= (double)attackRangeSq && this.timeTargetVisible >= 20) {
            this.getNavigator().func_75499_g();
        } else if (distToTargetSq > (double)attackRangeSq * 0.9) {
            this.getNavigator().func_75497_a((Entity)attackTarget2, this.getMoveSpeed());
        }
        if (canSeeTarget && this.entityHost.func_184218_aH() && distToTargetSq < 36.0 && this.runAwayTimer <= 0 && this.runAway()) {
            --this.timeUntilNextAttack;
            return;
        }
        if (runningAway) {
            --this.timeUntilNextAttack;
            return;
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)attackTarget2, 30.0f, 30.0f);
        if (--this.timeUntilNextAttack == 0) {
            if (distToTargetSq > (double)attackRangeSq || !canSeeTarget) {
                return;
            }
            float rangeRatio = MathHelper.func_76133_a((double)distToTargetSq) / ((Float)this.attackRange.get()).floatValue();
            rangeRatio = MathHelper.func_76131_a((float)rangeRatio, (float)0.1f, (float)1.0f);
            this.rangedAttackEntityHost.func_82196_d(attackTarget2, rangeRatio);
            this.timeUntilNextAttack = MathHelper.func_76141_d((float)(rangeRatio * (float)((Integer)this.maxRangedAttackTime.get() - (Integer)this.minRangedAttackTime.get()) + (float)((Integer)this.minRangedAttackTime.get()).intValue()));
        } else if (this.timeUntilNextAttack < 0) {
            float rangeRatio = MathHelper.func_76133_a((double)distToTargetSq) / ((Float)this.attackRange.get()).floatValue();
            this.timeUntilNextAttack = MathHelper.func_76141_d((float)(rangeRatio * (float)((Integer)this.maxRangedAttackTime.get() - (Integer)this.minRangedAttackTime.get()) + (float)((Integer)this.minRangedAttackTime.get()).intValue()));
        }
    }

    private boolean isRunningAway() {
        if (this.runningAwayTo == null) {
            return false;
        }
        if (this.getNavigator().func_75500_f()) {
            this.runningAwayTo = null;
            return false;
        }
        Path path = this.getNavigator().func_75505_d();
        PathPoint dest = path != null ? path.func_75870_c() : null;
        return dest != null && dest.equals((Object)this.runningAwayTo);
    }

    private boolean runAway() {
        Path path;
        if (!((Boolean)this.useRunAwayTactic.get()).booleanValue()) {
            return false;
        }
        this.runAwayTimer = 40;
        Vec3d targetDir = new Vec3d(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        Vec3d entityPos = EntityUtil.getEntityPosition((Entity)this.entityHost);
        targetDir = entityPos.func_178788_d(targetDir).func_72432_b().func_186678_a((double)((Float)this.attackRange.get()).floatValue() * 0.9).func_178787_e(entityPos);
        BlockPos probePoint = new BlockPos((int)Math.round(targetDir.field_72450_a), (int)Math.round(this.entityHost.field_70163_u), (int)Math.round(targetDir.field_72449_c));
        World world = this.entityHost.func_130014_f_();
        BlockPos clearGround = SpawnUtil.findClearGround(world, probePoint);
        if (clearGround == null) {
            return false;
        }
        boolean res = this.getNavigator().func_75492_a((double)clearGround.func_177958_n() + 0.5, (double)clearGround.func_177956_o(), (double)clearGround.func_177952_p() + 0.5, ((Double)this.mountedEntityMoveSpeed.get()).doubleValue());
        this.runningAwayTo = this.getNavigator().func_75500_f() ? null : ((path = this.getNavigator().func_75505_d()) != null ? path.func_75870_c() : null);
        return res;
    }

    private double getMoveSpeed() {
        return (Double)(this.entityHost.func_184218_aH() ? this.mountedEntityMoveSpeed : this.entityMoveSpeed).get();
    }

    protected PathNavigate getNavigator() {
        return this.entityHost.func_70661_as();
    }
}

